package com.digiwin.mobile.mobileuibot.task.strategy.custom.experimentaloptimizationdetection;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiRequestSubmit;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParam;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitResult;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.*;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTime;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePicker;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePickerTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumericTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectList;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.InputWindowSelectStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.multi.InputWindowMultiSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.rule.JsRule;
import com.digiwin.mobile.mobileuibot.core.rule.JsRuleService;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRuleCondition;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRule;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer.UiBotModelDesignerUniversalParsingPageStrategy;
import com.digiwin.mobile.mobileuibot.designer.uibot.rule.DesignerTrigger;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.digiwhale.model.MPersonCard;
import com.digiwin.mobile.mobileuibot.proxy.digiwhale.service.DigiwhaleProxyServie;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.task.model.MobileInspectionStatusEnum;
import com.digiwin.mobile.mobileuibot.task.model.MobileJudgmentTypeEnum;
import com.fasterxml.jackson.core.type.TypeReference;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author xujin
 * @desc 试验结果录入-检测数据条目详情任务卡
 */
@Component("taskDetailBuildDetectionDataDetailStrategy")
public class TaskDetailBuildDetectionDataDetailStrategy implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TaskDetailBuildDetectionDataDetailStrategy.class);

    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;

    @Autowired
    private DigiwhaleProxyServie digiwhaleProxyServie;

    @Autowired
    private UiBotModelDesignerUniversalParsingPageStrategy uiBotModelDesignerUniversalParsingPageStrategy;

    @Autowired
    private JsRuleService jsRuleService;

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        AppRequestContext.getContextEntity().setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);
        StopWatch stopWatch = new StopWatch("Build Detection Data Detail Page");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();

        ApiRawData apiRawData = apiRequest.getRawData();

        Map<String, Object> taskInfo = (Map<String, Object>) apiRawData.get("rawMap");
        Map<String, Object> executeContext = (Map<String, Object>) apiRawData.get("executeContext");
        PcUiBotExecuteContext pcUiBotExecuteContext = JsonUtil.objectToJavaObject(executeContext, PcUiBotExecuteContext.class);

        // 获取最新taskInfo，因为上一页面点击进来的数据还是老数据
        JSONObject newTaskInfoa = uiBotModelDesignerUniversalParsingPageStrategy.utInspectionResultsRegistrationHandle(apiRequest, pcUiBotExecuteContext, taskInfo);
        taskInfo = newTaskInfoa.getInnerMap();

        String planTemplate = (String) MapUtil.getOrDefault(taskInfo, "plan_template", StringUtils.EMPTY);

        // 根据parameter_no 获取对应inspectionParameterInfo的最新值
        Map<String, Object> inspectionParameterInfo = (Map<String, Object>) apiRawData.get("data");
        String parameterNo = String.valueOf(inspectionParameterInfo.get("parameter_no"));

        List<Map<String, Object>> inspectionParameterInfoList = (List<Map<String, Object>>) MapUtil.getOrDefault(taskInfo, "inspection_parameter_info", Collections.emptyList());
        Optional<Map<String, Object>> parameters = inspectionParameterInfoList.stream().filter(e -> parameterNo.equals(e.get("parameter_no"))).findFirst();
        if (parameters.isPresent()) {
            inspectionParameterInfo = parameters.get();
        }
        // 上一页的部分编辑参数改动后需要带到当前页面，替换原来老数据，使保存的数据是新数据
        handleInitData(apiRequest, taskInfo, inspectionParameterInfo);

        // 录入人 没有的话用当前操作人，有的话如果与当前操作人不一致，就不能编辑和保存
        boolean canEdit = true;
        String entryUserNo = String.valueOf(MapUtil.getOrDefault(inspectionParameterInfo, "entry_user_no", StringUtils.EMPTY));
        if (StringUtils.isEmpty(entryUserNo)) {
            inspectionParameterInfo.put("entry_user_no", apiRequest.getUserId());
        } else if (!apiRequest.getUserId().equals(entryUserNo)) {
            canEdit = false;
        }

        String entryUserName = String.valueOf(MapUtil.getOrDefault(inspectionParameterInfo, "entry_user_name", StringUtils.EMPTY));
        if (StringUtils.isEmpty(entryUserName)) {
            MPersonCard personCard = digiwhaleProxyServie.getPersonByUserId("userId=" + inspectionParameterInfo.get("entry_user_no"));
            if (!Objects.isNull(personCard)) {
                inspectionParameterInfo.put("entry_user_name", personCard.getpName());
            }
        }

        // 这个字段是前端使用在js规则里判定是不是非空
        Map<String, Object> judgmentEditMap = new HashMap<>();

        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case CustomGroup.COMPONENT_TYPE:
                    List<UiBotLayout> uiBotNewLayouts = new ArrayList<>();

                    CustomGroup customGroupPageData = JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), CustomGroup.class);
                    List<UiBotLayout> customGroupContentLayouts = customGroupPageData.getContent().getLayout();
                    UiBotPageData customGroupContentPageData = customGroupPageData.getContent().getPageData();

                    for (UiBotLayout customGroupContentLayout : customGroupContentLayouts) {
                        String customGroupContentSchema = customGroupContentLayout.getSchema();
                        switch (customGroupContentLayout.getType()) {
                            case Field.COMPONENT_TYPE:
                                buildDynamicsField(uiBotModel, pageSetting, customGroupContentLayout, customGroupContentPageData, inspectionParameterInfo, uiBotNewLayouts, judgmentEditMap, canEdit, locale);
                                break;
                            case Attachment.COMPONENT_TYPE:
                                Attachment<AttachmentRawData> attachment = buildAttachment(inspectionParameterInfo, customGroupContentLayout, locale);
                                uiBotNewLayouts.add(customGroupContentLayout);
                                customGroupContentPageData.put(customGroupContentSchema, attachment);
                                break;
                            case InputWindowSingleSelect.COMPONENT_TYPE:
                                Object dynamicsInspectionResultPageDataVal = buildInputWindowSelect(customGroupContentLayout, inspectionParameterInfo, taskInfo, planTemplate, canEdit, locale);
                                uiBotNewLayouts.add(customGroupContentLayout);
                                customGroupContentPageData.put(customGroupContentSchema, dynamicsInspectionResultPageDataVal);
                                break;
                            case InputMultiText.COMPONENT_TYPE:
                                Object dynamicsRemarkPageDataVal = null;
                                String remark = (String) MapUtil.getOrDefault(inspectionParameterInfo, "remark", StringUtils.EMPTY);
                                if (canEdit) {
                                    dynamicsRemarkPageDataVal = InputMultiText.create(customGroupContentSchema, localeService.getLanguageValue(locale,
                                                    customGroupContentLayout.getLabel()), remark, true, false, false, locale,
                                            255);
                                } else {
                                    customGroupContentLayout.setType(Field.COMPONENT_TYPE);
                                    dynamicsRemarkPageDataVal = Field.createLabelLeftValueRightField(localeService.getLanguageValue(locale, customGroupContentLayout.getLabel()), remark);
                                }
                                uiBotNewLayouts.add(customGroupContentLayout);
                                customGroupContentPageData.put(customGroupContentSchema, dynamicsRemarkPageDataVal);
                                break;
                        }
                    }
                    customGroupPageData.getContent().setLayout(uiBotNewLayouts);
                    customGroupPageData.getContent().setPageData(customGroupContentPageData);
                    pageData.put(layout.getSchema(), customGroupPageData);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    buildButton(uiBotModel, apiRequest, taskInfo, inspectionParameterInfo, pageData, judgmentEditMap, canEdit, schema);
                default:
                    break;
            }
        }
        return uiBotModel;
    }

    /**
     * 构建动态参数，根据judgment_standard_list里的数量和类型判断有多少个，展示还是可编辑
     *
     * @param layout
     * @param inspectionParameterInfo
     * @param inspectionParameterInfo
     * @param uiBotNewLayouts
     * @param judgmentEditMap
     * @param canEdit
     * @param locale
     * @return
     */
    private void buildDynamicsField(UiBotModel uiBotModel, PageSetting pageSetting, UiBotLayout layout, UiBotPageData pageData, Map<String, Object> inspectionParameterInfo,
                                    List<UiBotLayout> uiBotNewLayouts, Map<String, Object> judgmentEditMap, boolean canEdit, String locale) {
        if ("dynamics_field".equalsIgnoreCase(layout.getSchema())) {
            List<Map<String, Object>> judgmentStandardList = (List<Map<String, Object>>) MapUtil.getOrDefault(inspectionParameterInfo, "judgment_standard_list", Collections.emptyList());
            if (CollectionUtils.isEmpty(judgmentStandardList)) {
                return;
            }

            JsRule autoDetermineDynamicssSeqJsRule = null;
            JsRule blankDynamicssSeqJsRule = null;
            List<JsRule> jsRuleList = jsRuleService.findByPageId(pageSetting.getPageId());
            if (!CollectionUtils.isEmpty(jsRuleList)) {
                Optional<JsRule> autoDetermineDynamicsSeqJsRuleOption = jsRuleList.stream()
                        .filter(e -> "auto_determine_rule_dynamics_seq".equals(e.getSchema())).findFirst();
                if (autoDetermineDynamicsSeqJsRuleOption.isPresent()) {
                    autoDetermineDynamicssSeqJsRule = autoDetermineDynamicsSeqJsRuleOption.get();
                    Optional<String> apiUrl = Optional.ofNullable(autoDetermineDynamicssSeqJsRule.getTrigger()).map(DesignerTrigger::getApiUrl);
                    if (apiUrl.isPresent() && StringUtils.isNotEmpty(apiUrl.get())) {
                        autoDetermineDynamicssSeqJsRule.getTrigger().setApiUrl(AppContext.getBaseUrl() + apiUrl.get());
                    }
                }

                Optional<JsRule> blankDynamicsSeqJsRuleOption = jsRuleList.stream().filter(e -> "blank_rule_dynamics_seq".equals(e.getSchema())).findFirst();
                if (blankDynamicsSeqJsRuleOption.isPresent()) {
                    blankDynamicssSeqJsRule = blankDynamicsSeqJsRuleOption.get();
                }
            }
            List<UiBotRule> uiBotRuleList = new ArrayList<>(2);

            // 数据量动态展示，judgmentType 为1 不可编辑， 2可编辑
            for (Map<String, Object> judgmentStandard : judgmentStandardList) {
                String judgmentName = String.valueOf(MapUtil.getOrDefault(judgmentStandard, "judgment_name", StringUtils.EMPTY));
                String judgmentValue = String.valueOf(MapUtil.getOrDefault(judgmentStandard, "judgment_value", StringUtils.EMPTY));
                String judgmentSeq = String.valueOf(MapUtil.getOrDefault(judgmentStandard, "judgment_seq", StringUtils.EMPTY));

                UiBotLayout newLayout = new UiBotLayout();
                newLayout.setSchema("dynamics_seq_" + judgmentSeq);
                if (MobileJudgmentTypeEnum.CAN_NOT_EDIT.getType().equals(judgmentStandard.get("judgment_type"))) {
                    Field field = Field.createLabelLeftValueRightField(judgmentName, judgmentValue);
                    newLayout.setType(Field.COMPONENT_TYPE);
                    uiBotNewLayouts.add(newLayout);
                    pageData.put(newLayout.getSchema(), field);
                } else {
                    if (canEdit) {
                        InputSingleText inputSingleText = InputSingleText.create(newLayout.getSchema(), judgmentName, true,
                                true, locale, judgmentValue, false);
                        inputSingleText.setPlaceholder(localeService.getLanguageValue(locale, "请输入"));

                        RelationRule relationRule = new RelationRule();
                        List<CommonRule> commonRuleList = relationRule.getRuleList();
                        CommonRule riskLevelNameRule = new CommonRule();

                        riskLevelNameRule.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
                        riskLevelNameRule.setTargetSchema("inspection_result");
                        riskLevelNameRule.setTargetText(StringUtils.EMPTY);
                        riskLevelNameRule.setTargetSelectId(StringUtils.EMPTY);
                        riskLevelNameRule.setTargetSelectList(Collections.emptyList());
                        commonRuleList.add(riskLevelNameRule);
                        inputSingleText.setRelationRule(relationRule);

                        judgmentEditMap.put(newLayout.getSchema(), judgmentValue);
                        newLayout.setType(InputSingleText.COMPONENT_TYPE);
                        pageData.put(newLayout.getSchema(), inputSingleText);

                        if (ObjectUtils.isNotEmpty(autoDetermineDynamicssSeqJsRule)) {
                            UiBotRule uiBotRule = new UiBotRule();
                            BeanUtils.copyProperties(autoDetermineDynamicssSeqJsRule, uiBotRule);
                            uiBotRule.setSchema(newLayout.getSchema());
                            uiBotRuleList.add(uiBotRule);
                        }

                        if (ObjectUtils.isNotEmpty(blankDynamicssSeqJsRule)) {
                            UiBotRule uiBotRule = new UiBotRule();
                            BeanUtils.copyProperties(blankDynamicssSeqJsRule, uiBotRule);
                            uiBotRule.setSchema(newLayout.getSchema());
                            uiBotRuleList.add(uiBotRule);
                        }
                    } else {
                        newLayout.setType(Field.COMPONENT_TYPE);
                        Field field = Field.createLabelLeftValueRightField(judgmentName, judgmentValue);
                        pageData.put(newLayout.getSchema(), field);
                    }
                    uiBotNewLayouts.add(newLayout);
                }
            }
            uiBotModel.setRules(uiBotRuleList);
        } else {
            String schemaData = String.valueOf(MapUtil.getOrDefault(inspectionParameterInfo, layout.getSchema(), StringUtils.EMPTY));

            // 检测结果需要将枚举值转为对应文字
            if ("inspection_status".equalsIgnoreCase(layout.getSchema())) {
                schemaData = localeService.getLanguageValue(locale, MobileInspectionStatusEnum.getNameByStatus(schemaData));
            }
            Field field = Field.createLabelLeftValueRightField(localeService.getLanguageValue(locale, layout.getLabel()), schemaData);
            uiBotNewLayouts.add(layout);
            pageData.put(layout.getSchema(), field);
        }
    }

    /**
     * 构建附件信息
     *
     * @param inspectionParameterInfo
     * @param customGroupContentLayout
     * @param locale
     * @return
     */
    private Attachment<AttachmentRawData> buildAttachment(Map<String, Object> inspectionParameterInfo, UiBotLayout customGroupContentLayout, String locale) {
        List<Map<String, Object>> basisAttachment = (List<Map<String, Object>>) MapUtil.getOrDefault(inspectionParameterInfo, "basis_attachment", Collections.emptyList());
        Attachment<AttachmentRawData> attachment = new Attachment<>();
        attachment.setTitle(localeService.getLanguageValue(locale, customGroupContentLayout.getLabel()));
        attachment.setType(AttachmentTypeEnum.READ_ONLY.getValue());
        attachment.setStyleType(AttachmentStyleTypeEnum.TITLE_WEAKENED.getValue());
        attachment.setRawData(new AttachmentRawDataDigiwinAthena());
        if (!CollectionUtils.isEmpty(basisAttachment)) {
            Map<String, Object> dataMap = basisAttachment.get(0);
            if (dataMap.get("data") != null) {
                List<Map<String, Object>> dataList = (List<Map<String, Object>>) dataMap.get("data");
                if (!CollectionUtils.isEmpty(dataList)) {
                    List<AttachmentFile> fileList = dataList.stream().map(data -> {
                        AttachmentFile file = new AttachmentFile();
                        file.setFileId((String) data.get("id"));
                        if (data.get("size") instanceof Double) {
                            Double size = (Double) data.get("size");
                            file.setFileSize(size.longValue());
                        } else if (data.get("size") instanceof Long) {
                            file.setFileSize((Long) data.get("size"));
                        } else if (data.get("size") instanceof String) {
                            file.setFileSize(new BigDecimal((String) data.get("size")).longValue());
                        }
                        file.setUploader((String) data.get("upload_user_name"));
                        file.setFileName((String) data.get("name"));
                        String createDate = data.get("create_date") == null ? "" : String.valueOf(data.get("create_date"));
                        if (org.springframework.util.StringUtils.hasLength(createDate)) {
                            createDate = createDate.replaceAll("/", "-");
                        }
                        file.setUploadTime(createDate);
                        file.setFileExtension(AttachmentUtil.getAttachmentFileSuffix((String) data.get("name")));
                        // 试验优测-检验结果录入-子条目详情页-检验依据附件使用的是Athena来访问的不是CTP
                        file.setShareUrl(AppContext.getApiUrlSetting().getDmcUrl() + "/api/dmc/v2/file/Athena/preview/" + file.getFileId());
                        return file;
                    }).collect(Collectors.toList());
                    attachment.setFileList(fileList);
                }
            }
        }
        return attachment;
    }

    /**
     * 构建开窗组件，方案模板为检测方案，开窗单选， 方案模板为检测等级方案，开窗多选
     *
     * @param layout
     * @param inspectionParameterInfo
     * @param planTemplate
     * @param canEdit
     * @param locale
     * @return
     */
    private Object buildInputWindowSelect(UiBotLayout layout, Map<String, Object> inspectionParameterInfo, Map<String, Object> taskInfo, String planTemplate, boolean canEdit, String locale) {
        List<Map<String, Object>> resultList;
        Object dynamicsInspectionResultPageDataVal = null;
        String inspectionResult = (String) MapUtil.getOrDefault(inspectionParameterInfo, "inspection_result", StringUtils.EMPTY);

        if (canEdit) {
            List<Map<String, Object>> judegmentResultList = (List<Map<String, Object>>) MapUtil.getOrDefault(taskInfo, "judegment_result_list", Collections.emptyList());
            resultList = judegmentResultList.stream().map(e -> {
                Map<String, Object> resultMap = new HashMap<>(2);
                resultMap.put("name", String.valueOf(e.get("inspection_result_cn")));
                resultMap.put("value", String.valueOf(e.get("inspection_result")));
                return resultMap;
            }).collect(Collectors.toList());
            dynamicsInspectionResultPageDataVal = buildInputWindowSingleSelect(resultList, layout, inspectionResult, locale);
        } else {
            layout.setType(Field.COMPONENT_TYPE);
            dynamicsInspectionResultPageDataVal = Field.createLabelLeftValueRightField(localeService.getLanguageValue(locale, layout.getLabel()), inspectionResult);
        }
        return dynamicsInspectionResultPageDataVal;
    }

    private InputWindowSingleSelect buildInputWindowSingleSelect(List<Map<String, Object>> resultList, UiBotLayout layout, String initValue, String locale) {
        Map<String, Object> rawDataMap = new HashMap<>(2);
        rawDataMap.put("isDetectionDataDetail", true);
        rawDataMap.put("resultList", resultList);
        String url = AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list?componentSchema=" + layout.getSchema();
        InputWindowSingleSelect windowSingleSelect = InputWindowSingleSelect.create(rawDataMap, layout.getSchema(), localeService.getLanguageValue(locale, layout.getLabel()), url, locale, true);
        windowSingleSelect.setDefaultSelectId(initValue);
        return windowSingleSelect;
    }

    private InputWindowMultiSelect buildInputWindowMultiSelect(List<Map<String, Object>> resultList, UiBotLayout layout, String initValue, String locale) {
        Map<String, Object> rawDataMap = new HashMap<>(2);
        rawDataMap.put("isDetectionDataDetail", true);
        rawDataMap.put("resultList", resultList);
        InputWindowMultiSelect windowMultiSelect = InputWindowMultiSelect.create(layout,
                AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list",
                rawDataMap, locale, 0, InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue(),
                false, true, localeService, true
        );
        if (StringUtils.isNotEmpty(initValue)) {
            windowMultiSelect.setSelectIdList(Arrays.asList(StringUtils.split(initValue, ",")));
        }
        return windowMultiSelect;
    }

    /**
     * 构建按钮组件
     *
     * @param uiBotModel
     * @param schema
     * @param pageData
     * @return
     */
    private void buildButton(UiBotModel uiBotModel, ApiRequest apiRequest, Map<String, Object> taskInfo, Map<String, Object> inspectionParameterInfo,
                             UiBotPageData pageData, Map<String, Object> judgmentEditMap, boolean canEdit, String schema) {
        List<BottomButtonDigiwinAthena> buttonList = JsonUtil.objectToJavaObject(pageData.get(schema), new TypeReference<List<BottomButtonDigiwinAthena>>() {
        });
        Iterator<BottomButtonDigiwinAthena> buttonListIter = buttonList.iterator();
        while (buttonListIter.hasNext()) {
            BottomButtonDigiwinAthena button = buttonListIter.next();
            if (button.getIsCheckButton()) {

                // 录入人不一致，保存按钮不展示
                if (!canEdit) {
                    buttonListIter.remove();
                }
                Action saveAction = button.getAction();

                Map<String, Object> commonRawDataMap = new HashMap(2);
                commonRawDataMap.put("parameter_no", inspectionParameterInfo.get("parameter_no"));
                commonRawDataMap.put("actionId", "bm.qmsc.quality.inspection.application.item.update");
                commonRawDataMap.put("pageId", PageSettingIdPresetEnum.MOBILE_ATHENA_INSPECTION_RESULTS_REGISTRATION_SUB_ITEM_CUSTOMIZE_DETAIL.toString());
                commonRawDataMap.put("refreshDataId", apiRequest.getRawData().getString("rootDataId"));
                commonRawDataMap.put("prePageId", apiRequest.getRawData().getString("prePageId"));
                commonRawDataMap.putAll(judgmentEditMap);

                Map<String, Object> rawDataMap = new HashMap(commonRawDataMap);
                rawDataMap.put("task_info_detail", taskInfo);
                saveAction.setRawData(rawDataMap);

                UiBotPageData uiBotPageData = new UiBotPageData();
                Map<String, Object> taskInfoMap = new HashMap(taskInfo);
                taskInfoMap.putAll(new HashMap<>(commonRawDataMap));
                taskInfoMap.put("locale", apiRequest.getLocale());
                taskInfoMap.put("iamUserToken", apiRequest.getIamUserToken());
                taskInfoMap.put("tenantId", apiRequest.getTenantId());
                taskInfoMap.put("userId", apiRequest.getUserId());
                uiBotPageData.put("task_info", taskInfoMap);
                uiBotModel.setRawUiBotPageData(uiBotPageData);
            } else {
                button.setName(localeService.getLanguageValue(apiRequest.getLocale(), button.getName()));
            }
        }
        pageData.put(schema, buttonList);
    }

    /**
     * 上一页的部分编辑参数改动后需要带到当前页面，替换原来老数据，使保存的数据是新数据
     *
     * @param apiRequest
     * @param taskInfo
     * @param inspectionParameterInfo
     * @return
     */
    private void handleInitData(ApiRequest apiRequest, Map<String, Object> taskInfo, Map<String, Object> inspectionParameterInfo) {
        if (!CollectionUtils.isEmpty(apiRequest.getSubmitParam())) {
            for (ActionSubmitParam actionSubmitParam : apiRequest.getSubmitParam()) {
                String schema = actionSubmitParam.getSchema();
                switch (actionSubmitParam.getType()) {
                    case InputDateTimePicker.COMPONENT_TYPE:
                        InputDateTimePicker inputDateTimePicker = JsonUtil.objectToJavaObject(actionSubmitParam.getParams(), InputDateTimePicker.class);
                        Optional datetimeValueOpt = Optional.ofNullable(inputDateTimePicker).map(InputDateTimePicker::getDatetimeValue);
                        if (datetimeValueOpt.isPresent() && inputDateTimePicker != null) {
                            String inputDateTime = InputDateTime.getDateTypeDateStringByType(inputDateTimePicker.getDatetimeValue(), InputDateTimePickerTypeEnum.YEAR_MONTH_DATE_HOUR_MINUTE.getType());
                            inspectionParameterInfo.put(schema, inputDateTime);
                        }
                        break;
                    case SingleSelectList.COMPONENT_TYPE:
                        // 综合判定结果和综合判定等级（total_judgment_result， total_judgment_level）
                        SingleSelectList singleSelectList = JsonUtil.objectToJavaObject(actionSubmitParam.getParams(), SingleSelectList.class);
                        taskInfo.put(schema, singleSelectList.getSelectId());
                        break;
                    case InputWindowMultiSelect.COMPONENT_TYPE:
                        // 检验员（inspector_link_info）
                        InputWindowMultiSelect inputWindowMultiSelect = JsonUtil.objectToJavaObject(actionSubmitParam.getParams(), InputWindowMultiSelect.class);
                        List<Object> selectDetailList = inputWindowMultiSelect.getSelectDetailList();
                        if (CollectionUtils.isEmpty(selectDetailList)) {
                            break;
                        }
                        List<Map<String, Object>> inspectorLinkInfoMapList = new ArrayList<>();
                        for (Object inspectorLinkInfoObj : selectDetailList) {
                            Map<String, Object> inspectorLinkInfoMap = new HashMap<>(2);
                            Map<String, Object> inspectorLinkInfoObjMap = JsonUtil.objectToJavaObject(inspectorLinkInfoObj, Map.class);
                            inspectorLinkInfoMap.put("inspector_no", inspectorLinkInfoObjMap.get("inspector_no"));
                            inspectorLinkInfoMap.put("inspector_name", inspectorLinkInfoObjMap.get("inspector_name"));
                            inspectorLinkInfoMapList.add(inspectorLinkInfoMap);
                        }
                        inspectionParameterInfo.put(schema, inspectorLinkInfoMapList);
                        break;
                    case Attachment.COMPONENT_TYPE:
                        Map<String, Object> attachmentMap = JsonUtil.objectToJavaObject(actionSubmitParam.getParams(), Map.class);
                        List<AttachmentFile> fileList = JsonUtil.objectToJavaObject(attachmentMap.get("fileList"), new TypeReference<List<AttachmentFile>>() {
                        });
                        if (CollectionUtils.isEmpty(fileList)) {
                            break;
                        }
                        List<Map<String, Object>> attachmentFileDataList = new ArrayList<>();
                        for (AttachmentFile attachmentFile : fileList) {
                            Map<String, Object> attachmentFileMap = new HashMap<>(2);
                            attachmentFileMap.put("id", attachmentFile.getFileId());
                            attachmentFileMap.put("name", attachmentFile.getFileName());
                            if ("video_attachment".equalsIgnoreCase(schema)) {
                                String shareUrl = AppContext.getApiUrlSetting().getDmcUrl() + "/api/dmc/v2/file/CTP/preview/" + attachmentFile.getFileId();
                                attachmentFileMap.put("category", shareUrl);
                                attachmentFileMap.put("is_cover", "N");
                                attachmentFileMap.put("video_cover_id", StringUtils.EMPTY);
                                attachmentFileMap.put("upload_user_id", attachmentFile.getFileId());
                                attachmentFileMap.put("row_data", "0");
                            }
                            attachmentFileDataList.add(attachmentFileMap);
                        }
                        Map<String, Object> dataMap = new HashMap<>(1);
                        dataMap.put("data", attachmentFileDataList);
                        dataMap.put("row_data", StringUtils.EMPTY);
                        taskInfo.put(schema, Collections.singletonList(dataMap));
                        break;
                    default:
                        break;
                }
            }
        }
    }


    /**
     * 提交
     *
     * @param apiRequestSubmit
     * @return
     */
    public ActionSubmitResult submit(ApiRequestSubmit apiRequestSubmit) {
        String locale = apiRequestSubmit.getLocale();
        JSONObject rawData = apiRequestSubmit.getRawData();
        Map<String, Object> taskInfoDetail = rawData.getJSONObject("task_info_detail").getInnerMap();
        String parameterNo = rawData.getString("parameter_no");
        String refreshDataId = rawData.getString("refreshDataId");

        List<Map<String, Object>> inspectionParameterInfoList = (List<Map<String, Object>>) MapUtil.getOrDefault(taskInfoDetail, "inspection_parameter_info", Collections.emptyList());
        Optional<Map<String, Object>> parameters = inspectionParameterInfoList.stream().filter(e -> parameterNo.equals(e.get("parameter_no"))).findFirst();
        Map<String, Object> inspectionParameterInfoItem;
        if (parameters.isPresent()) {
            inspectionParameterInfoItem = parameters.get();
        } else {
            inspectionParameterInfoItem = new HashMap<>();
        }
        //inspection_status 1.已检测; 2.待检测
        inspectionParameterInfoItem.put("inspection_status", "1");

        // 录入人信息
        if (StringUtils.isEmpty((String) MapUtil.getOrDefault(inspectionParameterInfoItem, "entry_user_no", StringUtils.EMPTY))) {
            inspectionParameterInfoItem.put("entry_user_no", apiRequestSubmit.getUserId());
        }
        if (StringUtils.isEmpty((String) MapUtil.getOrDefault(inspectionParameterInfoItem, "entry_user_name", StringUtils.EMPTY))) {
            MPersonCard personCard = digiwhaleProxyServie.getPersonByUserId("userId=" + inspectionParameterInfoItem.get("entry_user_no"));
            if (!Objects.isNull(personCard)) {
                inspectionParameterInfoItem.put("entry_user_name", personCard.getpName());
            }
        }

        // 当前操作的inspection_parameter_info需要更新对应值
        List<Map<String, Object>> judgmentStandardListByParameterNo = (List<Map<String, Object>>) MapUtil.getOrDefault(inspectionParameterInfoItem, "judgment_standard_list", Collections.emptyList());
        for (ActionSubmitParam actionSubmitParam : apiRequestSubmit.getSubmitParams()) {
            switch (actionSubmitParam.getType()) {
                case InputSingleText.COMPONENT_TYPE:
                    InputSingleText inputSingleText = JsonUtil.objectToJavaObject(actionSubmitParam.getParams(), InputSingleText.class);
                    for (Map<String, Object> judgmentStandard : judgmentStandardListByParameterNo) {
                        String schema = actionSubmitParam.getSchema();
                        String dynamicsSeq = schema.replaceFirst("dynamics_seq_", "");
                        if (MobileJudgmentTypeEnum.CAN_EDIT.getType().equals(judgmentStandard.get("judgment_type")) && judgmentStandard.get("judgment_seq").equals(dynamicsSeq)) {
                            judgmentStandard.put("judgment_value", inputSingleText.getText());
                        }
                    }
                    break;
                case InputWindowSingleSelect.COMPONENT_TYPE:
                    InputWindowSingleSelect inputWindowSingleSelect = JsonUtil.objectToJavaObject(actionSubmitParam.getParams(), InputWindowSingleSelect.class);
                    inspectionParameterInfoItem.put("inspection_result", inputWindowSingleSelect.getSelectId());
                    break;
                case InputWindowMultiSelect.COMPONENT_TYPE:
                    InputWindowMultiSelect inputWindowMultiSelect = JsonUtil.objectToJavaObject(actionSubmitParam.getParams(), InputWindowMultiSelect.class);
                    String selectIdStr = StringUtils.join(inputWindowMultiSelect.getSelectIdList(), ",");
                    inspectionParameterInfoItem.put("inspection_result", selectIdStr);
                    inspectionParameterInfoItem.put("inspection_resultData", inputWindowMultiSelect.getSelectIdList());
                    break;
                case InputMultiText.COMPONENT_TYPE:
                    InputMultiText inputMultiText = JsonUtil.objectToJavaObject(actionSubmitParam.getParams(), InputMultiText.class);
                    inspectionParameterInfoItem.put("remark", inputMultiText.getText());
                    break;
                default:
                    break;
            }
        }

        for (Map<String, Object> inspectionParameterInfo : inspectionParameterInfoList) {
            inspectionParameterInfo.put("is_check", inspectionParameterInfo.get("parameter_no").equals(parameterNo));
            List<Map<String, Object>> judgmentStandardList = (List<Map<String, Object>>) MapUtil.getOrDefault(inspectionParameterInfo, "judgment_standard_list", Collections.emptyList());
            for (Map<String, Object> judgmentStandard : judgmentStandardList) {
                inspectionParameterInfo.put(String.valueOf(judgmentStandard.get("judgment_seq")), judgmentStandard);
            }
        }

        Map<String, Object> paramterMap = new HashMap(1);
        paramterMap.put("task_info", Collections.singletonList(taskInfoDetail));

        Map<String, Object> rawDataMap = new HashMap(2);
        rawDataMap.put("parameter", paramterMap);
        rawDataMap.put("actionId", "bm.qmsc.quality.inspection.application.item.update");

        // 当前数据保存完还需要待检测的数据，优先处理当前数据后的待处理数据，再处理当前数据前的待处理数据
        List<Integer> lessParameterSeqList = inspectionParameterInfoList.stream().filter(e ->
                MapUtils.getInteger(e, "parameter_seq") < MapUtils.getInteger(inspectionParameterInfoItem, "parameter_seq")
                        && "2".equals(MapUtils.getString(e, "inspection_status"))).map(e -> MapUtils.getInteger(e, "parameter_seq")).collect(Collectors.toList());

        List<Integer> moreParameterSeqList = inspectionParameterInfoList.stream().filter(e ->
                MapUtils.getInteger(e, "parameter_seq") > MapUtils.getInteger(inspectionParameterInfoItem, "parameter_seq")
                        && "2".equals(MapUtils.getString(e, "inspection_status"))).map(e -> MapUtils.getInteger(e, "parameter_seq")).collect(Collectors.toList());
        moreParameterSeqList.addAll(lessParameterSeqList);

        DigiwinAthenaApiResponse<JSONObject> resp = digiwinAtdmProxyService
                .handleByActionId(apiRequestSubmit.getLocale(), apiRequestSubmit.getIamUserToken(), apiRequestSubmit.getTenantId(), "", rawDataMap);

        boolean isSuccess = resp.getStatus() == 200 && StringUtils.isEmpty(resp.getErrorMessage());
        Action action = new Action<>();
        if (isSuccess) {
            if (!CollectionUtils.isEmpty(moreParameterSeqList)) {
                // 下一个条目索引，从0开始，因为parameter_seq是从1开始，所以减1
                action.setNextHandleIndex(moreParameterSeqList.get(0) - 1);
                action.setType(ActionTypeEnum.JUMP_NEXT_DATA_AND_REFRASH.getValue());
                action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_INSPECTION_RESULTS_REGISTRATION_SUB_ITEM_CUSTOMIZE_DETAIL.name());
            } else {
                action.setType(ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue());
            }
            action.setRefreshDataId(refreshDataId);
            action.setRefreshPageId("popUp2");
            action.setSuccessMsg(localeService.getLanguageValue(locale, "保存成功"));
            return ActionSubmitResult.create(true, action);
        } else {
            action.setType(ActionTypeEnum.ACTION_CURRENT_PAGE.getValue());
            action.setToastMsg(localeService.getLanguageValue(locale, "保存失败"));
            return ActionSubmitResult.create(false, action);
        }
    }

    public List<String> autoJudgmentProcess(Map<String, Object> paramMap) {
        String locale = (String) paramMap.get("locale");
        String iamUserToken = (String) paramMap.get("iamUserToken");
        String tenantId = (String) paramMap.get("tenantId");

        String parameterNo = (String) paramMap.get("parameter_no");

        List<Map<String, Object>> inspectionParameterInfoList = (List<Map<String, Object>>) MapUtil.getOrDefault(paramMap, "inspection_parameter_info", Collections.emptyList());
        Optional<Map<String, Object>> parameterOption = inspectionParameterInfoList.stream().filter(e -> parameterNo.equals(e.get("parameter_no"))).findFirst();
        Map<String, Object> inspectionParameterInfoItem;
        if (parameterOption.isPresent()) {
            inspectionParameterInfoItem = parameterOption.get();
        } else {
            inspectionParameterInfoItem = new HashMap<>();
        }

        // 录入人信息
        if (StringUtils.isEmpty((String) MapUtil.getOrDefault(inspectionParameterInfoItem, "entry_user_no", StringUtils.EMPTY))) {
            inspectionParameterInfoItem.put("entry_user_no", paramMap.get("userId"));
        }
        if (StringUtils.isEmpty((String) MapUtil.getOrDefault(inspectionParameterInfoItem, "entry_user_name", StringUtils.EMPTY))) {
            MPersonCard personCard = digiwhaleProxyServie.getPersonByUserId("userId=" + inspectionParameterInfoItem.get("entry_user_no"));
            if (!Objects.isNull(personCard)) {
                inspectionParameterInfoItem.put("entry_user_name", personCard.getpName());
            }
        }

        // 当前操作的inspection_parameter_info需要更新对应值
        List<Map<String, Object>> judgmentStandardListByParameterNo = (List<Map<String, Object>>) MapUtil.getOrDefault(inspectionParameterInfoItem, "judgment_standard_list", Collections.emptyList());
        for (Map<String, Object> judgmentStandard : judgmentStandardListByParameterNo) {
            judgmentStandard.put("judgment_value", paramMap.get("dynamics_seq_" + judgmentStandard.get("judgment_seq")));
        }

        for (Map<String, Object> inspectionParameterInfo : inspectionParameterInfoList) {
            inspectionParameterInfo.put("is_check", inspectionParameterInfo.get("parameter_no").equals(parameterNo));
            List<Map<String, Object>> judgmentStandardList = (List<Map<String, Object>>) MapUtil.getOrDefault(inspectionParameterInfo, "judgment_standard_list", Collections.emptyList());
            for (Map<String, Object> judgmentStandard : judgmentStandardList) {
                inspectionParameterInfo.put(String.valueOf(judgmentStandard.get("judgment_seq")), judgmentStandard);
            }
        }

        Map<String, Object> taskInfoMap = new HashMap<>(1);
        taskInfoMap.put("inspection_no", paramMap.get("inspection_no"));
        taskInfoMap.put("inspection_parameter_info", inspectionParameterInfoList);
        taskInfoMap.put("judgment_header_list", paramMap.get("judgment_header_list"));
        taskInfoMap.put("plan_template", paramMap.get("plan_template"));
        taskInfoMap.put("quality_inspection_no", paramMap.get("quality_inspection_no"));

        Map<String, Object> paramterMap = new HashMap(1);
        paramterMap.put("task_info", Collections.singletonList(taskInfoMap));
        paramterMap.put("check_method", "1");

        Map<String, Object> rawDataMap = new HashMap(2);
        rawDataMap.put("parameter", paramterMap);
        rawDataMap.put("actionId", "bm.qmsc.inspection.result.auto.judgment.process");

        DigiwinAthenaApiResponse<JSONObject> resp = digiwinAtdmProxyService
                .handleByActionId(locale, iamUserToken, tenantId, "", rawDataMap);

        boolean isSuccess = resp.getStatus() == 200 && StringUtils.isEmpty(resp.getErrorMessage());
        if (isSuccess) {
            Map<String, Object> response = resp.getResponse().getInnerMap();
            List<Map<String, Object>> respTaskInfoList = (List<Map<String, Object>>) MapUtil.getOrDefault(response, "task_info", Collections.emptyList());
            Optional<List<String>> inspectionResultList = respTaskInfoList.stream().map(e -> {
                List<Map<String, Object>> respInspectionParameterInfoList = (List<Map<String, Object>>) MapUtil.getOrDefault(e, "inspection_parameter_info", Collections.emptyList());
                List<String> inspectionResults = respInspectionParameterInfoList.stream()
                        .filter(i -> parameterNo.equals(i.get("parameter_no")))
                        .map(c -> (List<String>) CollectionUtils.arrayToList(StringUtils.split((String) c.get("inspection_result"), ",")))
                        .flatMap(Collection::stream)
                        .collect(Collectors.toList());
                return inspectionResults;
            }).findFirst();
            if (inspectionResultList.isPresent() && !CollectionUtils.isEmpty(inspectionResultList.get())) {
                return inspectionResultList.get();
            }
        }
        return Collections.emptyList();
    }

    private List<Map<String, Object>> buildInputWindowSingleSelectData(String locale) {
        List<Map<String, Object>> dataList = new ArrayList<>(2);
        Map<String, Object> qualifiedData = new HashMap<>(2);
        qualifiedData.put("name", localeService.getLanguageValue(locale, "合格"));
        qualifiedData.put("value", "OK");
        dataList.add(qualifiedData);
        Map<String, Object> unqualifiedData = new HashMap<>(2);
        unqualifiedData.put("name", localeService.getLanguageValue(locale, "不合格"));
        unqualifiedData.put("value", "NG");
        dataList.add(unqualifiedData);
        return dataList;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
