package com.digiwin.mobile.mobileuibot.task.strategy.custom.manualtask;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardContent;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.io.IOException;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 功能: 手动任务的前置任务展示
 *
 * @author: xujin
 * @date: created at 2023/10/23
 */
@Component("taskDetailBuildPreviousManualTaskDetailStrategy")
public class TaskDetailBuildPreviousManualTaskDetailStrategy implements UiBotModelBuildStrategy {

    private static final org.slf4j.Logger logger =
            LoggerFactory.getLogger(TaskDetailBuildPreviousManualTaskDetailStrategy.class);

    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        if (!useMockData) {
            uiBotModel = this.doActually(pageSetting, apiRequest);
        } else {
            uiBotModel = this.doMockData(apiRequest);
        }
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        Map<String, Object> rawData = apiRequest.getRawData();

        Map<String, Object> taskInfoMap = new HashMap<>(2);
        taskInfoMap.put("project_no", rawData.get("project_no"));
        taskInfoMap.put("task_no", rawData.get("task_no"));

        Map<String, Object> parameterMap = new HashMap<>(1);
        parameterMap.put("task_info", Collections.singletonList(taskInfoMap));

        Map<String, Object> rawDataMap = new HashMap(2);
        rawDataMap.put("parameter", parameterMap);
        rawDataMap.put("actionId", "before.task.info.get");

        DigiwinAthenaApiResponse<JSONObject> beforeTaskResp = null;
        try {
            beforeTaskResp = digiwinAtdmProxyService
                    .handleByActionId(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), "", rawDataMap);
        } catch (Exception e) {
            logger.error("get before task info error: ", e);
        }
        List<Map<String, Object>> beforeTaskInfoList = Optional.ofNullable(beforeTaskResp).map(DigiwinAthenaApiResponse::getResponse).map(e -> (List<Map<String, Object>>) e.get("before_task_info")).orElse(Collections.emptyList());
        if (CollectionUtils.isEmpty(beforeTaskInfoList)) {
            return UiBotModel.emptyUibotModel(locale);
        }

        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();

        List<UiBotLayout> newLayouts = new ArrayList<>();
        UiBotPageData newPageData = new UiBotPageData();
        for (UiBotLayout layout : uiBotModel.getLayout()) {
            switch (layout.getType()) {
                case Card.COMPONENT_TYPE:
                    Card cardPageData = JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), Card.class);
                    for (Map<String, Object> beforeTaskInfo : beforeTaskInfoList) {
                        String uuid = UUIDUtil.getUuid();
                        UiBotLayout copyUiBotLayout = new UiBotLayout();
                        BeanUtils.copyProperties(layout, copyUiBotLayout);
                        copyUiBotLayout.setSchema(uuid);
                        newLayouts.add(copyUiBotLayout);
                        Card copyCardPageData = JsonUtil.objectToJavaObject(cardPageData, new TypeReference<Card>() {
                        });
                        copyCardPageData.setTitle((String) MapUtil.getOrDefault(beforeTaskInfo, copyCardPageData.getTitle(), StringUtils.EMPTY));
                        copyCardPageData.setSubTitle((String) MapUtil.getOrDefault(beforeTaskInfo, copyCardPageData.getSubTitle(), StringUtils.EMPTY));

                        List<CardContent> copyCardContent = copyCardPageData.getContent();
                        for (CardContent cardContent : copyCardContent) {
                            String label = localeService.getLanguageValue(locale, cardContent.getLabel());
                            if ("manualAssignmentDelivery".equalsIgnoreCase(cardContent.getSchema()) || "manualAssignmentAttachment".equalsIgnoreCase(cardContent.getSchema())) {
                                Map<String, Object> attachment = (Map<String, Object>) MapUtil.getOrDefault(beforeTaskInfo, "attachment", Collections.emptyMap());
                                List<Map<String, Object>> attachmentData = (List<Map<String, Object>>) MapUtil.getOrDefault(attachment, "data", Collections.emptyList());
                                List<Map<String, Object>> displayAttachment = attachmentData.stream().filter(e -> cardContent.getSchema().equals(e.get("category"))).collect(Collectors.toList());
                                if (CollectionUtils.isEmpty(displayAttachment)) {
                                    cardContent.setFile(null);
                                    cardContent.setValue("-");
                                    cardContent.setValueStyleType(1);
                                    cardContent.setLabel(label);
                                    continue;
                                }
                                Attachment file = cardContent.getFile();
                                cardContent.setFile(Attachment.createAttachment(displayAttachment, file, label));
                            } else {
                                cardContent.setLabel(label);
                                cardContent.setValue((String) MapUtil.getOrDefault(beforeTaskInfo, cardContent.getSchema(), StringUtils.EMPTY));
                                cardContent.setValueStyleType(1);
                            }
                        }
                        newPageData.put(copyUiBotLayout.getSchema(), copyCardPageData);
                    }
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    newLayouts.add(layout);
                    newPageData.put(layout.getSchema(), Collections.singletonList(BottomButtonDigiwinAthena.createNormalCancelButton(locale)));
                    break;
                default:
                    break;
            }
        }
        uiBotModel.setLayout(newLayouts);
        uiBotModel.setPageData(newPageData);
        return uiBotModel;
    }

    private UiBotModel doMockData(ApiRequest apiRequest) {
        return null;
    }
}
