package com.digiwin.mobile.mobileuibot.task.strategy.custom.manualtask;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiRequestSubmit;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParam;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumericTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.InputWindowSelectStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.multi.InputWindowMultiSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.rule.RuleDataTypeEnum;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRuleCondition;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRule;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRule;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleScopeEnum;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRuleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author xujin
 * @desc 手动任务代为报工
 */
@Component("taskDetailBuildReplaceReportTaskDetailStrategy")
public class TaskDetailBuildReplaceReportTaskDetailStrategy implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TaskDetailBuildReplaceReportTaskDetailStrategy.class);

    private static final String ESP_EMPLOYEE_INFO_PROCESS = "esp_employee.info.process";

    private static final String EMPLOYEE_INFO_PROCESS = "employee.info.process";

    private static final String GROUPID_PREFIX = "Group";

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build Replace Report Task Detail Page");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        ApiRawData apiRawData = apiRequest.getRawData();

        // 获取上一次保存的执行人清单（前端保存）
        Map<String, Object> rawData = apiRawData.getInnerMap();
        List<List<ActionSubmitParam>> executorInfoByGroupList = JsonUtil.objectToJavaObject(rawData.get("executorInfoByGroupList"), new TypeReference<List<List<ActionSubmitParam>>>() {
        });

        // 获取上一页批量选择的执行人信息， 并根据有多少个执行人渲染多少组
        List<ActionSubmitParam> actionSubmitParamList = apiRequest.getSubmitParam();
        if (!CollectionUtils.isEmpty(actionSubmitParamList)) {
            Optional<ActionSubmitParam> workHoursOpt = actionSubmitParamList.stream().filter(e -> "executor".equalsIgnoreCase(e.getSchema())).findFirst();
            if (workHoursOpt.isPresent() && Objects.nonNull(workHoursOpt.get().getParams())) {
                InputWindowMultiSelect executor = JsonUtil.objectToJavaObject(workHoursOpt.get().getParams(), InputWindowMultiSelect.class);
                List<Map<String, Object>> selectDetailList = JsonUtil.objectToJavaObject(executor.getSelectDetailList(), new TypeReference<List<Map<String, Object>>>() {
                });

                if (!CollectionUtils.isEmpty(selectDetailList)) {
                    // 获取保存过的执行人清单
                    Map<String, List<ActionSubmitParam>> executorInfoByGroupMapById;
                    if (!CollectionUtils.isEmpty(executorInfoByGroupList)) {
                        executorInfoByGroupMapById = executorInfoByGroupList.stream().collect(Collectors.toMap(e -> {
                            Optional<ActionSubmitParam> inputWindowSingleSelectOpt = e.stream().filter(item -> InputWindowSingleSelect.COMPONENT_TYPE.equalsIgnoreCase(item.getType())).findFirst();
                            if (inputWindowSingleSelectOpt.isPresent()) {
                                InputWindowSingleSelect inputWindowSingleSelect = JsonUtil.objectToJavaObject(inputWindowSingleSelectOpt.get().getParams(), InputWindowSingleSelect.class);
                                return inputWindowSingleSelect.getSelectId();
                            }
                            return "";
                        }, e -> e, (c1, c2) -> c1));
                    } else {
                        executorInfoByGroupMapById = null;
                    }

                    executorInfoByGroupList = selectDetailList.stream().map(selectDetail -> {
                        String selectId = MapUtils.getString(selectDetail, "employee_no") + "_" + MapUtils.getString(selectDetail, "department_no");
                        String selectName = MapUtils.getString(selectDetail, "employee_name");

                        // 上一页选择的执行人不在保存过的执行人清单，说明是新增，否则是编辑
                        if (Objects.isNull(executorInfoByGroupMapById) || !executorInfoByGroupMapById.containsKey(selectId)) {
                            ActionSubmitParam actionSubmitParam = new ActionSubmitParam();
                            actionSubmitParam.setType(InputWindowSingleSelect.COMPONENT_TYPE);
                            actionSubmitParam.setSchema("executor_no");
                            InputWindowSingleSelect inputWindowSingleSelect = new InputWindowSingleSelect();
                            inputWindowSingleSelect.setSelectId(selectId);
                            inputWindowSingleSelect.setTitle(selectName);
                            actionSubmitParam.setParams(inputWindowSingleSelect);
                            return Collections.singletonList(actionSubmitParam);
                        }
                        return executorInfoByGroupMapById.get(selectId);
                    }).collect(Collectors.toList());
                }
            }
        }

        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case CustomGroup.COMPONENT_TYPE:
                    CustomGroup customGroup = JsonUtil.objectToJavaObject(pageData.get(schema), CustomGroup.class);
                    CustomGroupContent customGroupContent = customGroup.getContent();
                    List<UiBotLayout> uiBotLayoutList = customGroupContent.getLayout();

                    List<String> initGroupIds = new ArrayList<>();
                    List<UiBotLayout> uiBotLayoutCopyLinkedList = new LinkedList<>();
                    int suffixIndex = 0;
                    // 初始化渲染content内容,有多少值渲染多少组，每组通过后缀标识唯一性
                    if (!CollectionUtils.isEmpty(executorInfoByGroupList)) {
                        for (List<ActionSubmitParam> executorInfoByGroup : executorInfoByGroupList) {
                            List<UiBotLayout> uiBotLayoutCopyList = handleUiBotLayoutList(uiBotLayoutList, customGroupContent, executorInfoByGroup, locale, suffixIndex, true, apiRawData);
                            uiBotLayoutCopyLinkedList.addAll(uiBotLayoutCopyList);
                            initGroupIds.add(GROUPID_PREFIX + suffixIndex);
                            suffixIndex++;
                        }
                    } else {
                        // 没有值，就渲染一组，指定后缀
                        List<UiBotLayout> uiBotLayoutCopyList = handleUiBotLayoutList(uiBotLayoutList, customGroupContent, Collections.emptyList(), locale, suffixIndex, false, apiRawData);
                        uiBotLayoutCopyLinkedList.addAll(uiBotLayoutCopyList);
                        initGroupIds.add(GROUPID_PREFIX + suffixIndex);
                    }
                    customGroup.setInitGroupIds(initGroupIds);
                    customGroupContent.setLayout(uiBotLayoutCopyLinkedList);

                    // 指定contentCopy格式体，前端根据该结构体来整体操作新增和删除
                    CustomGroupContent customGroupCopyContent = customGroup.getContentCopy();
                    for (UiBotLayout uiBotLayout : customGroupCopyContent.getLayout()) {
                        handleCustomGroup(uiBotLayout, customGroupCopyContent.getPageData(), locale, false, null, apiRawData);
                    }
                    pageData.put(schema, customGroup);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    List<BottomButtonDigiwinAthena> buttonList = buildButton(locale, apiRequest);
                    pageData.put(schema, buttonList);
                default:
                    break;
            }
        }
        return uiBotModel;
    }

    private List<UiBotLayout> handleUiBotLayoutList(List<UiBotLayout> uiBotLayoutList, CustomGroupContent
            customGroupContent
            , List<ActionSubmitParam> executorInfo, String locale, int suffixIndex, boolean hasInitVal, ApiRawData
                                                            apiRawData) {
        List<UiBotLayout> uiBotLayoutCopyList = uiBotLayoutList.stream().map(e -> {
            UiBotLayout uiBotLayoutCopy = new UiBotLayout();
            BeanUtils.copyProperties(e, uiBotLayoutCopy);
            return uiBotLayoutCopy;
        }).collect(Collectors.toList());
        for (UiBotLayout uiBotLayoutCopyDetail : uiBotLayoutCopyList) {
            String customGroupContentSchema = uiBotLayoutCopyDetail.getSchema();
            if (StringUtils.isNotEmpty(customGroupContentSchema)) {
                uiBotLayoutCopyDetail.setSchema(customGroupContentSchema + "_" + GROUPID_PREFIX + suffixIndex);
            }
            uiBotLayoutCopyDetail.setGroupId(GROUPID_PREFIX + suffixIndex);

            ActionSubmitParam actionSubmitParam = null;
            if (hasInitVal) {
                Optional<ActionSubmitParam> executorInfoOpt = executorInfo.stream().filter(e -> uiBotLayoutCopyDetail.getType().equals(e.getType())).findFirst();
                if (executorInfoOpt.isPresent()) {
                    actionSubmitParam = executorInfoOpt.get();
                }
            }
            handleCustomGroup(uiBotLayoutCopyDetail, customGroupContent.getPageData(), locale, hasInitVal, actionSubmitParam, apiRawData);
        }
        return uiBotLayoutCopyList;
    }


    /**
     * 根据layout数据组装对应pageData
     *
     * @param layout
     * @param pageData
     * @param locale
     * @param hasInitVal
     * @param actionSubmitParam
     */
    private void handleCustomGroup(UiBotLayout layout, UiBotPageData pageData, String locale, boolean hasInitVal
            , ActionSubmitParam actionSubmitParam, ApiRawData apiRawData) {
        String schema = layout.getSchema();
        switch (layout.getType()) {
            case InputNumeric.COMPONENT_TYPE:
                String value = StringUtils.EMPTY;
                if (hasInitVal) {
                    if (actionSubmitParam != null) {
                        InputNumeric initInputNumeric = JsonUtil.objectToJavaObject(actionSubmitParam.getParams(), InputNumeric.class);
                        value = initInputNumeric.getText();
                    }
                }
                InputNumeric inputNumeric = buildInputNumeric(layout, value, locale, apiRawData);
                pageData.put(schema, inputNumeric);
                break;
            case InputWindowSingleSelect.COMPONENT_TYPE:
                String defaultSelectId = StringUtils.EMPTY;
                String defaultShowValue = StringUtils.EMPTY;
                if (hasInitVal) {
                    if (actionSubmitParam != null) {
                        InputWindowSingleSelect initInputWindowSingleSelect = JsonUtil.objectToJavaObject(actionSubmitParam.getParams(), InputWindowSingleSelect.class);
                        defaultSelectId = initInputWindowSingleSelect.getSelectId();
                        defaultShowValue = initInputWindowSingleSelect.getTitle();
                    }
                }
                InputWindowSingleSelect inputWindowSingleSelect = buildInputWindowSingleSelect(layout, schema, defaultSelectId, defaultShowValue, locale);
                pageData.put(schema, inputWindowSingleSelect);
                break;
            default:
                break;
        }
    }

    /**
     * 构建InputNumeric组件
     *
     * @param uiBotLayout
     * @param locale
     * @return
     */
    private InputNumeric buildInputNumeric(UiBotLayout uiBotLayout, String value, String locale, ApiRawData
            apiRawData) {
        InputNumeric inputNumeric = InputNumeric.create(99999999, 2,
                value, localeService.getLanguageValue(locale, uiBotLayout.getLabel()),
                InputNumericTypeEnum.DECIMAL_ALLOW_NEGATIVE.getValue(), true, "");
        inputNumeric.setPlaceholder(localeService.getLanguageValue(locale, "请输入"));
        Object isworkHourZero = apiRawData.get("isworkHourZero");
        //交付设计器.工时不可为0
        if (ObjectUtils.isNotEmpty(isworkHourZero) && (Boolean) isworkHourZero) {
            if (uiBotLayout.getSchema().contains("work_hours")) {
                List<ValidateRule> validateRuleList = new ArrayList<>(1);
                ValidateRule validateRule = new ValidateRule();
                validateRule.setSchema(uiBotLayout.getSchema());
                validateRule.setScope(ValidateRuleScopeEnum.EDIT.getScope());
                validateRule.setType(ValidateRuleTypeEnum.APPOINT.getType());
                validateRule.setOperatorType(2);
                validateRule.setParameter("0");
                validateRule.setErrorMessage(localeService.getLanguageValue(locale, "工时不能等于0"));
                validateRule.setOrder(1);
                validateRule.setParameterDataType(RuleDataTypeEnum.DOUBLE.getDataType());
                validateRuleList.add(validateRule);
                inputNumeric.setValidateRuleList(validateRuleList);
            }
        }
        return inputNumeric;
    }

    /**
     * 构建单选组件
     *
     * @param uiBotLayout
     * @param schema
     * @param locale
     * @return
     */
    private InputWindowSingleSelect buildInputWindowSingleSelect(UiBotLayout uiBotLayout, String schema, String
            defaultSelectId, String defaultShowValue, String locale) {
        Map<String, Object> rawDataMap = buildEmployeeDataSourceList();
        InputWindowSingleSelect windowSingleSelect = new InputWindowSingleSelect();
        windowSingleSelect.setSchema(uiBotLayout.getSchema());
        windowSingleSelect.setTitle(uiBotLayout.getLabel());
        windowSingleSelect.setUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list?componentSchema=" + schema);
        windowSingleSelect.setRawData(rawDataMap);
        windowSingleSelect.setType(InputWindowSingleSelect.COMPONENT_TYPE);
        windowSingleSelect.setStyle(InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue());
        windowSingleSelect.setPlaceholder(localeService.getLanguageValue(locale, "请选择"));
        if (StringUtils.isNotEmpty(defaultSelectId)) {
            windowSingleSelect.setDefaultSelectId(defaultSelectId);
        }
        if (StringUtils.isNotEmpty(defaultShowValue)) {
            windowSingleSelect.setDefaultShowValue(defaultShowValue);
        }
        windowSingleSelect.setRequired(true);
        return windowSingleSelect;
    }

    /**
     * 构建按钮组件
     *
     * @param locale
     * @param apiRequest
     * @return
     */
    private List<BottomButtonDigiwinAthena> buildButton(String locale, ApiRequest apiRequest) {
        Map<String, Object> rawData = apiRequest.getRawData().getInnerMap();
        List<BottomButtonDigiwinAthena> buttonList = new ArrayList<>(2);
        BottomButtonDigiwinAthena cancelButton = BottomButtonDigiwinAthena.createNormalCancelButton(locale, "上一步");
        buttonList.add(cancelButton);
        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        button.setName(localeService.getLanguageValue(locale, "保存"));

        Action buttonAction = new Action();
        buttonAction.setType(ActionTypeEnum.CALL_API_SHOW_SUCCESS_MSG_REFRESH_CURRENT_PAGE.getValue());
        buttonAction.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/handleAction");

        Map<String, Object> rawDataMap = new HashMap<>();
        rawDataMap.put("isReplaceReportExecutorSave", true);
        rawDataMap.put("detailInfo", apiRequest.getSubmitParam());
        rawDataMap.put("totalWorkHours", rawData.get("totalWorkHours"));
        Map<String, Object> requestRawDataMap = apiRequest.getRawData().getInnerMap();
        if (!CollectionUtils.isEmpty(requestRawDataMap)) {
            rawDataMap.putAll(requestRawDataMap);
        }
        buttonAction.setRawData(rawDataMap);
        button.setAction(buttonAction);
        button.setType(BottomButtonStyleEnum.STRESS.getValue());
        buttonList.add(button);
        return buttonList;
    }

    private Map<String, Object> buildEmployeeDataSourceList() {
        PcUiBotDataSourceDTO pcUiBotDataSourceDTO = new PcUiBotDataSourceDTO();
        pcUiBotDataSourceDTO.setType("ESP");
        pcUiBotDataSourceDTO.setActionId(ESP_EMPLOYEE_INFO_PROCESS);

        PcUiBotQueryAction pcUiBotQueryAction = new PcUiBotQueryAction();
        pcUiBotQueryAction.setCategory("ESP");
        pcUiBotQueryAction.setActionId(ESP_EMPLOYEE_INFO_PROCESS);

        PcUiBotActionServiceId pcUiBotActionServiceId = new PcUiBotActionServiceId();
        pcUiBotActionServiceId.setHostAcct("athena");
        pcUiBotActionServiceId.setName(EMPLOYEE_INFO_PROCESS);
        pcUiBotQueryAction.setServiceId(pcUiBotActionServiceId);

        Map<String, Object> projectMemberInfoMap = new HashMap<>(1);
        projectMemberInfoMap.put("project_no", StringUtils.EMPTY);

        Map<String, Object> parasMap = new HashMap<>(1);
        parasMap.put("project_member_info", Collections.singletonList(projectMemberInfoMap));
        pcUiBotQueryAction.setParas(parasMap);

        pcUiBotDataSourceDTO.setAction(pcUiBotQueryAction);

        Map<String, Object> dataSourceListMap = new HashMap<>(1);
        dataSourceListMap.put("dataSourceList", Collections.singletonList(pcUiBotDataSourceDTO));

        Map<String, Object> paramMap = new HashMap<>(2);
        paramMap.put("dataSourceSet", dataSourceListMap);
        paramMap.put("executeContext", Collections.emptyMap());
        return paramMap;
    }

    public Action handleSaveAction(ApiRequestSubmit apiRequestSubmit) {
        String locale = apiRequestSubmit.getLocale();
        Map<String, Object> apiRawDataMap = apiRequestSubmit.getRawData().getInnerMap();

        // 耗用总工时
        String totalWorkHoursStr = MapUtils.getString(apiRawDataMap, "totalWorkHours");
        BigDecimal totalWorkHours = new BigDecimal(StringUtils.isNotBlank(totalWorkHoursStr) ? totalWorkHoursStr : "0");

        // 工时
        BigDecimal sumWorkHours = new BigDecimal(0);
        List<List<ActionSubmitParam>> groupSubmitParamList = apiRequestSubmit.getGroupSubmitParamList();
        if (!CollectionUtils.isEmpty(groupSubmitParamList)) {

            Set<String> employeeNos = new HashSet<>();
            for (List<ActionSubmitParam> groupSubmitParam : groupSubmitParamList) {
                for (ActionSubmitParam groupSubmitParamDetail : groupSubmitParam) {
                    switch (groupSubmitParamDetail.getType()) {
                        case InputWindowSingleSelect.COMPONENT_TYPE:
                            InputWindowSingleSelect employeeNoInputWindowSingleSelect = JsonUtil.objectToJavaObject(groupSubmitParamDetail.getParams(), InputWindowSingleSelect.class);
                            if (employeeNos.contains(employeeNoInputWindowSingleSelect.getSelectId())) {
                                throw new ServiceException(localeService.getLanguageValue(locale, "不能同时录入相同的执行人！"));
                            }
                            employeeNos.add(employeeNoInputWindowSingleSelect.getSelectId());
                            break;
                        case InputNumeric.COMPONENT_TYPE:
                            InputNumeric workHoursInputNumeric = JsonUtil.objectToJavaObject(groupSubmitParamDetail.getParams(), InputNumeric.class);
                            String workHours = workHoursInputNumeric.getText();
                            sumWorkHours = sumWorkHours.add(new BigDecimal(StringUtils.isNotBlank(workHours) ? workHours : "0"));
                            break;
                    }
                }
            }
        }

        // 耗用总工时与执行人清单工时累计不可小于0
        if (totalWorkHours.add(sumWorkHours).compareTo(BigDecimal.ZERO) < 0) {
            throw new ServiceException(localeService.getLanguageValue(locale, "耗用总工时与执行人清单工时累计不可小于0"));
        }

        Action action = new Action();
        action.setType(ActionTypeEnum.BACK_AND_TRANSFER_GROUP_DATA_TO_PREFIX.getValue());
        action.setToastMsg(localeService.getLanguageValue(locale, "保存成功"));

        // 用于详情页的工时字段更新为执行人清单的所有工时总和
        Map<String, Object> workHoursMap = (Map<String, Object>) MapUtil.getOrDefault(apiRawDataMap, "work_hours", Collections.emptyMap());
        if (!CollectionUtils.isEmpty(workHoursMap)) {
            InputNumeric workHours = JsonUtil.objectToJavaObject(workHoursMap, InputNumeric.class);
            workHours.setText(sumWorkHours.toString());
            workHours.setRequired(true);

            Map<String, Object> workHoursRawData = new HashMap<>(1);
            workHoursRawData.put("groupSubmitParamList", apiRequestSubmit.getGroupSubmitParamList());
            workHours.setRawData(workHoursRawData);

            List<ValidateRule> validateRuleList = CollectionUtils.isEmpty(workHours.getValidateRuleList()) ?
                    new ArrayList<>() : workHours.getValidateRuleList();

            ValidateRule validateSameWorkHoursRule = new ValidateRule();
            validateSameWorkHoursRule.setSchema("work_hours");
            validateSameWorkHoursRule.setScope(ValidateRuleScopeEnum.EDIT.getScope());
            validateSameWorkHoursRule.setType(ValidateRuleTypeEnum.APPOINT.getType());
            validateSameWorkHoursRule.setParameter(sumWorkHours.toString());
            validateSameWorkHoursRule.setOperatorType(1);
            validateSameWorkHoursRule.setParameterDataType(RuleDataTypeEnum.DOUBLE.getDataType());
            validateSameWorkHoursRule.setErrorMessage(localeService.getLanguageValue(locale, "与执行人清单累计工时(" + sumWorkHours + "）未保持一致！"));
            validateRuleList.add(validateSameWorkHoursRule);

            ValidateRule validateSumWorkHoursRule = new ValidateRule();
            validateSumWorkHoursRule.setSchema("work_hours");
            validateSumWorkHoursRule.setScope(ValidateRuleScopeEnum.EDIT.getScope());
            validateSumWorkHoursRule.setType(ValidateRuleTypeEnum.APPOINT.getType());
            validateSumWorkHoursRule.setParameter(totalWorkHours.negate().toString());
            validateSumWorkHoursRule.setOperatorType(6);
            validateSumWorkHoursRule.setParameterDataType(RuleDataTypeEnum.DOUBLE.getDataType());
            validateSumWorkHoursRule.setErrorMessage(localeService.getLanguageValue(locale, "耗用总工时与工时累计不可小于0！"));
            validateRuleList.add(validateSumWorkHoursRule);
            workHours.setValidateRuleList(validateRuleList);

            RelationRule relationRule = Optional.ofNullable(workHours.getRelationRule()).orElse(new RelationRule());
            List<CommonRule> ruleList = Optional.ofNullable(relationRule.getRuleList()).orElse(new ArrayList<>());

            // 代为报工选择后报工日期不可编辑
            CommonRule reportDateNotEditCommonRule = new CommonRule();
            reportDateNotEditCommonRule.setTargetSchema("report_date");
            reportDateNotEditCommonRule.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
            reportDateNotEditCommonRule.setTargetHidden(false);
            reportDateNotEditCommonRule.setTargetEnable(true);
            reportDateNotEditCommonRule.setTargetRequired(false);
            ruleList.add(reportDateNotEditCommonRule);

            // 代为报工选择后报工日期如果不为空，赋值系统时间
            CommonRule reportDateSetDefaultDateCommonRule = new CommonRule();
            reportDateSetDefaultDateCommonRule.setTargetSchema("report_date");
            reportDateSetDefaultDateCommonRule.setCondition(CommonRuleCondition.CONDITION_EMPTY_RESET.getType());
            reportDateSetDefaultDateCommonRule.setTargetText(DateTimeUtil.getTodayDateTextInMobileShowDefaultPattern());
            reportDateSetDefaultDateCommonRule.setTargetHidden(false);
            reportDateSetDefaultDateCommonRule.setTargetEnable(true);
            reportDateSetDefaultDateCommonRule.setTargetRequired(false);
            ruleList.add(reportDateSetDefaultDateCommonRule);

            relationRule.setRuleList(ruleList);
            workHours.setRelationRule(relationRule);

            Map<String, Object> rawData = new HashMap<>(1);
            rawData.put("work_hours", workHours);
            action.setRawData(rawData);
        }
        return action;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
