package com.digiwin.mobile.mobileuibot.task.strategy.custom.manualtask;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParam;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.InputWindowSelectStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.multi.InputWindowMultiSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActionServiceId;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotQueryAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * <p>功能描述：代为报工执行人批量选择页</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: taskDetailBuildReplaceReportExecutorDetailStrategy
 * @Author: xujin
 * @Date: 2024年8月05日 11点55分
 */
@Component("taskDetailBuildReplaceReportTaskExecutorDetailStrategy")
public class TaskDetailBuildReplaceReportTaskExecutorDetailStrategy implements UiBotModelBuildStrategy {
    private static final Logger logger =
            LoggerFactory.getLogger(TaskDetailBuildReplaceReportTaskExecutorDetailStrategy.class);

    private static final String ESP_EMPLOYEE_INFO_PROCESS = "esp_employee.info.process";

    private static final String EMPLOYEE_INFO_PROCESS = "employee.info.process";

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("Build Replace Report Executor Detail Page");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        String locale = apiRequest.getLocale();
        ApiRawData apiRawData = apiRequest.getRawData();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();

        // 执行人清单保存后重新编辑-获取保存的执行人清单内容
        List<ActionSubmitParam> actionSubmitParamList = apiRequest.getSubmitParam();
        if (!CollectionUtils.isEmpty(actionSubmitParamList)) {
            // 工时
            Optional<ActionSubmitParam> workHoursOpt = actionSubmitParamList.stream().filter(e -> "work_hours".equalsIgnoreCase(e.getSchema())).findFirst();
            if (workHoursOpt.isPresent()) {
                InputNumeric workHours = JsonUtil.objectToJavaObject(workHoursOpt.get().getParams(), InputNumeric.class);
                if (!CollectionUtils.isEmpty(workHours.getRawData())) {
                    apiRawData.put("executorInfoByGroupList", workHours.getRawData().get("groupSubmitParamList"));
                }
            }

            // 耗用总工时
            Optional<ActionSubmitParam> totalWorkHoursActionOpt = actionSubmitParamList.stream().filter(e -> "total_work_hours".equalsIgnoreCase(e.getSchema())).findFirst();
            if (totalWorkHoursActionOpt.isPresent()) {
                InputNumeric totalWorkHoursInputNumeric = JsonUtil.objectToJavaObject(totalWorkHoursActionOpt.get().getParams(), InputNumeric.class);
                apiRawData.put("totalWorkHours", totalWorkHoursInputNumeric.getText());
            }
        }


        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case CustomGroup.COMPONENT_TYPE:
                    CustomGroup customGroup = JsonUtil.objectToJavaObject(uiBotModel.getPageData().get(schema), CustomGroup.class);
                    handleCustomGroup(customGroup, apiRawData, locale);
                    uiBotModel.getPageData().put(schema, customGroup);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    List<BottomButtonDigiwinAthena> bottomButtonList = new ArrayList<>();
                    bottomButtonList.add(BottomButtonDigiwinAthena.createNormalCancelButton(locale));

                    BottomButtonDigiwinAthena confirmeButton = new BottomButtonDigiwinAthena();
                    confirmeButton.setName(localeService.getLanguageValue(locale, "下一步"));

                    Action buttonAction = new Action();
                    buttonAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_REPLACE_REPORT_TASK_DETAIL.toString());
                    buttonAction.setJumpPageTitle(localeService.getLanguageValue(locale, "执行人清单"));
                    buttonAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
                    buttonAction.setRawData(apiRawData);

                    confirmeButton.setAction(buttonAction);
                    confirmeButton.setType(BottomButtonStyleEnum.STRESS.getValue());
                    bottomButtonList.add(confirmeButton);

                    uiBotModel.getPageData().put(schema, bottomButtonList);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }

    private void handleCustomGroup(CustomGroup customGroup, ApiRawData apiRawData, String locale) {
        CustomGroupContent customGroupContent = customGroup.getContent();
        List<UiBotLayout> customGroupUiBotLayouts = customGroupContent.getLayout();
        for (UiBotLayout customGroupUiBotLayout : customGroupUiBotLayouts) {
            String customGroupSchema = customGroupUiBotLayout.getSchema();
            switch (customGroupUiBotLayout.getType()) {
                case InputWindowMultiSelect.COMPONENT_TYPE:
                    InputWindowMultiSelect inputWindowMultiSelect = buildInputWindowMultiSelect(customGroupUiBotLayout, apiRawData, customGroupSchema, locale);
                    customGroupContent.getPageData().put(customGroupSchema, inputWindowMultiSelect);
                    break;
            }
        }
    }


    /**
     * 构建单选组件
     *
     * @param uiBotLayout
     * @param schema
     * @param locale
     * @return
     */
    private InputWindowMultiSelect buildInputWindowMultiSelect(UiBotLayout uiBotLayout, ApiRawData apiRawData, String schema, String locale) {
        Map<String, Object> rawDataMap = buildEmployeeDataSourceList();
        InputWindowMultiSelect inputWindowMultiSelect = new InputWindowMultiSelect();
        inputWindowMultiSelect.setSchema(uiBotLayout.getSchema());
        inputWindowMultiSelect.setTitle(localeService.getLanguageValue(locale, uiBotLayout.getLabel()));
        inputWindowMultiSelect.setUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list?componentSchema=" + schema);
        inputWindowMultiSelect.setRawData(rawDataMap);
        inputWindowMultiSelect.setType(InputWindowSingleSelect.COMPONENT_TYPE);
        inputWindowMultiSelect.setStyle(InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue());
        inputWindowMultiSelect.setPlaceholder(localeService.getLanguageValue(locale, "请选择"));

        // 获取保存过的执行人清单中的所有执行人
        List<List<ActionSubmitParam>> groupSubmitParamList = JsonUtil.objectToJavaObject(apiRawData.get("executorInfoByGroupList"), new TypeReference<List<List<ActionSubmitParam>>>() {
        });
        if (!CollectionUtils.isEmpty(groupSubmitParamList)) {
            List<InputWindowSingleSelect> iputWindowSingleSelectList = groupSubmitParamList.stream().flatMap(Collection::stream)
                    .filter(e -> InputWindowSingleSelect.COMPONENT_TYPE.equalsIgnoreCase(e.getType()))
                    .map(e -> {
                        InputWindowSingleSelect iputWindowSingleSelect = JsonUtil.objectToJavaObject(e.getParams(), InputWindowSingleSelect.class);
                        return iputWindowSingleSelect;
                    }).collect(Collectors.toList());
            inputWindowMultiSelect.setSelectIdList(iputWindowSingleSelectList.stream().map(InputWindowSingleSelect::getSelectId).collect(Collectors.toList()));
            inputWindowMultiSelect.setTextList(iputWindowSingleSelectList.stream().map(InputWindowSingleSelect::getTitle).collect(Collectors.toList()));
        }
        return inputWindowMultiSelect;
    }

    private Map<String, Object> buildEmployeeDataSourceList() {
        PcUiBotDataSourceDTO pcUiBotDataSourceDTO = new PcUiBotDataSourceDTO();
        pcUiBotDataSourceDTO.setType("ESP");
        pcUiBotDataSourceDTO.setActionId(ESP_EMPLOYEE_INFO_PROCESS);

        PcUiBotQueryAction pcUiBotQueryAction = new PcUiBotQueryAction();
        pcUiBotQueryAction.setCategory("ESP");
        pcUiBotQueryAction.setActionId(ESP_EMPLOYEE_INFO_PROCESS);

        PcUiBotActionServiceId pcUiBotActionServiceId = new PcUiBotActionServiceId();
        pcUiBotActionServiceId.setHostAcct("athena");
        pcUiBotActionServiceId.setName(EMPLOYEE_INFO_PROCESS);
        pcUiBotQueryAction.setServiceId(pcUiBotActionServiceId);

        Map<String, Object> projectMemberInfoMap = new HashMap<>(1);
        projectMemberInfoMap.put("project_no", StringUtils.EMPTY);

        Map<String, Object> parasMap = new HashMap<>(1);
        parasMap.put("project_member_info", Collections.singletonList(projectMemberInfoMap));
        pcUiBotQueryAction.setParas(parasMap);

        pcUiBotDataSourceDTO.setAction(pcUiBotQueryAction);

        Map<String, Object> dataSourceListMap = new HashMap<>(1);
        dataSourceListMap.put("dataSourceList", Collections.singletonList(pcUiBotDataSourceDTO));

        Map<String, Object> paramMap = new HashMap<>(2);
        paramMap.put("dataSourceSet", dataSourceListMap);
        paramMap.put("executeContext", Collections.emptyMap());
        return paramMap;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
