package com.digiwin.mobile.mobileuibot.task.strategy.custom.mergeworkhour;

import cn.hutool.core.util.ObjectUtil;
import com.digiwin.dap.middleware.dmc.model.ShareInfo;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.cardgroup.CardGroup;
import com.digiwin.mobile.mobileuibot.core.component.graphicdisplay.GraphicDisplay;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentFile;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.picture.Picture;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionListChoiceEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionListStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.search.Pic;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTab;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabs;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.dmc.config.DigiwinDmcConfig;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.constant.KnowledgeMapsConstant;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.mdc.service.DigiwinMdcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.model.TaskProductStateEnum;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildStrategy;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author xujin
 * @desc 合并工时任务卡
 */
@Component("taskDetailBuildApcMergeWorkHourListStrategy")
public class TaskDetailBuildApcMergeWorkHourListStrategy implements TaskDetailBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(TaskDetailBuildApcMergeWorkHourListStrategy.class);

    private static final Integer COMPLETE_PROCESS = 100;

    @Autowired
    private LocaleService localeService;

    @Autowired
    private DigiwinDmcProxyService digiwinDmcProxyService;

    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    @Autowired
    private DigiwinMdcProxyService digiwinMdcProxyService;

    @Override
    public String getTaskDetailType() {
        return TaskStringUtil.CUSTOM_TASK_TYPE_MERGE_WOK_HOUR;
    }

    @Override
    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object... args) {
        StopWatch stopWatch = new StopWatch("Build Merge Work Hour List Page");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = JsonUtil.objectToJavaObject(args[0], DigiwinAtmcBacklogDetail.class);
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch, pcUiBotModel, digiwinAtmcBacklogDetail);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch, UiBotModel pcUiBotModel, DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail) {

        //true 则表示此条数据已经被提交成功，工作提醒点击查看更多则显示对应的图片ui
        if (ObjectUtils.isNotEmpty(pcUiBotModel.getFinished()) && pcUiBotModel.getFinished()) {
            return UiBotModel.workReminderEmptyImageUibotModel(apiRequest.getLocale());
        }
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();

        ApiRawData apiRawData = ObjectUtils.isNotEmpty(apiRequest.getRawData()) ? apiRequest.getRawData() : new ApiRawData();

        //是否是团队任务，团队任务不可编辑和提交
        boolean isTeamTask = BooleanUtils.isTrue(apiRawData.getBoolean("isTeamTask"));

        // 设计器「限制合并工时整批报工」=false,允许分批人员上线, 开关打开，只能整批提交
        Boolean variable = digiwinKnowledgeMapsProxyService.getVariable(apiRequest.getIamUserToken(),
                apiRequest.getTenantId(), apiRequest.getLocale(), KnowledgeMapsConstant.APC_MERGE_WORK_ALLOW_BATCH_SUBMIT);
        boolean isBatchLaunch = BooleanUtils.isFalse(variable);

        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case TitleBody.COMPONENT_TYPE:
                    // 单头（任务名称、基础信息）
                    TitleBody titleBody = TitleBody.createApc(digiwinAtmcBacklogDetail, pcUiBotModel, locale);
                    pageData.put(schema, titleBody);
                    break;
                case GraphicDisplay.COMPONENT_TYPE:
                    List<Map<String, Object>> woOpReportData = (List<Map<String, Object>>) pcUiBotModel.getPageData().get("wo_op_report_data");
                    Map<String, Object> attachments = null;
                    if (!CollectionUtils.isEmpty(woOpReportData)) {
                        if (ObjectUtil.isNotEmpty(woOpReportData.get(0).get("attachment"))) {
                            attachments = (Map<String, Object>) woOpReportData.get(0).get("attachment");
                        }
                        // 附件
                        GraphicDisplay graphicDisplay = new GraphicDisplay();
                        graphicDisplay.setStyle(3);
                        graphicDisplay.setTitle((String) woOpReportData.get(0).get("op_name"));
                        if (!CollectionUtils.isEmpty(attachments) && attachments != null) {
                            List<Map<String, Object>> attachmentDataList = (List<Map<String, Object>>) attachments.get("data");
                            if (!CollectionUtils.isEmpty(attachmentDataList)) {
                                List<Pic> pics = new ArrayList<>(1);
                                Pic pic = new Pic();
                                String fileId = (String) attachmentDataList.get(0).get("id");
                                if (StringUtils.isNotEmpty(fileId)) {
                                    ShareInfo shareInfo = digiwinDmcProxyService.shareFile(fileId, DigiwinDmcConfig.ATHENA_BUCKET);
                                    pic.setPicUrl(shareInfo.getUrl());
                                }
                                pics.add(pic);
                                graphicDisplay.setPics(pics);
                            }
                        }
                        pageData.put(schema, graphicDisplay);
                    }
                    break;
                case CustomTabs.COMPONENT_TYPE:
                    // 产品线E10或T100才展示特征码
                    boolean isProductGatewayE10orT100 = digiwinMdcProxyService.isProductGatewayE10orT100(apiRequest.getIamUserToken(), apiRequest.getTenantId());
                    CustomTabs customTabs = buildCustomTabs(pcUiBotModel, isBatchLaunch, locale, isTeamTask, isProductGatewayE10orT100);
                    pageData.put(schema, customTabs);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }

    private List<Map<String, Object>> getWoDetailDataList(UiBotPageData pageData) {
        List<Map<String, Object>> woOpReportDataList = (List<Map<String, Object>>) MapUtil.getOrDefault(pageData, "wo_op_report_data", Collections.emptyList());
        if (CollectionUtils.isEmpty(woOpReportDataList)) {
            return Collections.emptyList();
        }

        List<Map<String, Object>> subOpDataList = (List<Map<String, Object>>) MapUtil.getOrDefault(woOpReportDataList.get(0), "sub_op_data", Collections.emptyList());
        if (CollectionUtils.isEmpty(subOpDataList)) {
            return Collections.emptyList();
        }

        List<Map<String, Object>> woDataList = (List<Map<String, Object>>) MapUtil.getOrDefault(subOpDataList.get(0), "wo_data", Collections.emptyList());
        if (CollectionUtils.isEmpty(woDataList)) {
            return Collections.emptyList();
        }

        List<Map<String, Object>> woNoDataList = (List<Map<String, Object>>) MapUtil.getOrDefault(woDataList.get(0), "wo_no_data", Collections.emptyList());
        if (CollectionUtils.isEmpty(woNoDataList)) {
            return Collections.emptyList();
        }
        return (List<Map<String, Object>>) MapUtil.getOrDefault(woNoDataList.get(0), "wo_detail_data", Collections.emptyList());
    }

    private Picture buildPicture(UiBotPageData pageData, String locale) {
        Picture picture = new Picture();
        picture.setTitle(localeService.getLanguageValue(locale, "缩略图"));
        picture.setType(AttachmentTypeEnum.READ_ONLY.getValue());
        picture.setUsePreviewUrl(true);
        picture.setRows(1);

        List<Map<String, Object>> woOpReportData = (List<Map<String, Object>>) pageData.get("wo_op_report_data");
        if (CollectionUtils.isEmpty(woOpReportData)) {
            return picture;
        }
        if (ObjectUtil.isEmpty(woOpReportData.get(0).get("attachment"))) {
            return picture;
        }

        Map<String, Object> attachments = (Map<String, Object>) woOpReportData.get(0).get("attachment");
        List<Map<String, Object>> attachmentDataList = (List<Map<String, Object>>) attachments.get("data");
        if (!CollectionUtils.isEmpty(attachmentDataList)) {
            List<AttachmentFile> fileList = new ArrayList<>(3);
            String fileId = (String) attachmentDataList.get(0).get("id");
            if (StringUtils.isNotEmpty(fileId)) {
                ShareInfo shareInfo = digiwinDmcProxyService.shareFile(fileId, DigiwinDmcConfig.ATHENA_BUCKET);
                AttachmentFile contractAttachment = new AttachmentFile();
                contractAttachment.setPreviewUrl(shareInfo.getUrl());
                fileList.add(contractAttachment);
            }
            picture.setFileList(fileList);
        }
        return picture;
    }

    /**
     * 组装CustomTab
     *
     * @param pcUiBotModel
     * @param isBatchLaunch
     * @param locale
     * @return
     */
    private CustomTabs buildCustomTabs(UiBotModel pcUiBotModel, boolean isBatchLaunch, String locale, Boolean isTeamTask, boolean isProductGatewayE10orT100) {
        CustomTabs customTabs = new CustomTabs();

        // 未上线页签
        CustomTab offLineCustomTab = buildCustomTab(pcUiBotModel, false, isBatchLaunch, isTeamTask, isProductGatewayE10orT100, locale);

        // 已上线页签
        CustomTab onLineCustomTab = buildCustomTab(pcUiBotModel, true, isBatchLaunch, isTeamTask, isProductGatewayE10orT100, locale);

        customTabs.add(offLineCustomTab);
        customTabs.add(onLineCustomTab);
        return customTabs;
    }


    /**
     * 构建Tab页签数据，包括待处理和已完成
     *
     * @param pcUiBotModel
     * @param isOnline
     * @param locale
     * @return
     */
    private CustomTab buildCustomTab(UiBotModel pcUiBotModel, boolean isOnline, boolean isBatchLaunch, Boolean isTeamTask, boolean isProductGatewayE10orT100, String locale) {
        List<Map<String, Object>> woOpReportData = (List<Map<String, Object>>) pcUiBotModel.getPageData().get("wo_op_report_data");
        if (CollectionUtils.isEmpty(woOpReportData)) {
            return buidlEmptyTab(isOnline, locale);
        }
        List<Map<String, Object>> woOpReportDataByCheck = woOpReportData.stream().filter(e -> isOnline == (Boolean) e.get("is_check_in")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(woOpReportDataByCheck)) {
            return buidlEmptyTab(isOnline, locale);
        }
        Map<String, Object> woOpReportDataMap = woOpReportDataByCheck.get(0);
        List<Map<String, Object>> subOpData = (List<Map<String, Object>>) woOpReportDataMap.get("sub_op_data");
        int showNum = 0;
        List<CustomTabContentContainer> customTabContentContainerList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(subOpData)) {
            Map<String, String> languageNameMap = getLanguageNameMap(isOnline, locale);
            Map<Integer, String> nameMapByType = translateProdcuctNameByType(locale);

            Map<String, List<Map<String, Object>>> needHandleMapBysubOpNo = subOpData.stream().collect(Collectors.groupingBy(item -> (String) item.get("sub_op_no")));

            CustomTabContentContainer customTabContentContainer = null;
            for (Map.Entry<String, List<Map<String, Object>>> subOpDataMapItem : needHandleMapBysubOpNo.entrySet()) {
                customTabContentContainer = new CustomTabContentContainer();
                List<Card> cardList = new ArrayList<>();
                for (Map<String, Object> subOpDataMapItemValue : subOpDataMapItem.getValue()) {
                    List<Map<String, Object>> woDataList = (List<Map<String, Object>>) subOpDataMapItemValue.get("wo_data");
                    if (CollectionUtils.isEmpty(woDataList)) {
                        continue;
                    }
                    for (Map<String, Object> woData : woDataList) {
                        List<Map<String, Object>> woNoDataList = (List<Map<String, Object>>) woData.get("wo_no_data");
                        if (CollectionUtils.isEmpty(woNoDataList)) {
                            continue;
                        }

                        String docTypeNo = (String) woData.get("doc_type_no");
                        for (Map<String, Object> woNoData : woNoDataList) {
                            List<Map<String, Object>> woDetailDataList = (List<Map<String, Object>>) woNoData.get("wo_detail_data");
                            if (CollectionUtils.isEmpty(woDetailDataList)) {
                                continue;
                            }

                            String woNo = (String) woNoData.get("wo_no");

                            // 构建子制程下的卡片集合
                            builCardList(woDetailDataList, woOpReportDataMap, languageNameMap, nameMapByType, woNo,
                                    isOnline, isTeamTask, isProductGatewayE10orT100, docTypeNo, cardList, locale);
                            showNum += woDetailDataList.size();
                        }
                    }
                }

                // 标题子制程名称
                Map<String, Object> subOpDataMap = subOpDataMapItem.getValue().get(0);
                String subOpName = (String) MapUtil.getOrDefault(subOpDataMap, "sub_op_name", StringUtils.EMPTY);

                CardGroup cardGroup = new CardGroup();
                cardGroup.setTitle(StringUtils.isNotEmpty(subOpName) ? subOpName : "-");
                cardGroup.setStyleType(MultiFunctionListStyleTypeEnum.SPLIT_LINE.toString());
                if (isOnline || BooleanUtils.isTrue(isTeamTask)) {
                    // 已上线不展示勾选按钮，提交操作所有已上线数据
                    // 团队任务也不展示勾选按钮，无论已上线未上线
                    cardGroup.setChoice(MultiFunctionListChoiceEnum.NO_CHOICE.toString());
                } else {
                    cardGroup.setChoice(isBatchLaunch ? MultiFunctionListChoiceEnum.MULTIPLE_CHOICE.toString() : MultiFunctionListChoiceEnum.NO_CHOICE.toString());
                }
                cardGroup.setContent(cardList);

                customTabContentContainer.setData(cardGroup);
                customTabContentContainer.setContentCmptType(CardGroup.COMPONENT_TYPE);
                customTabContentContainerList.add(customTabContentContainer);
            }

            // 拼装底部按钮
            UiBotExecuteContext uiBotExecuteContext = pcUiBotModel.getExecuteContext();
            CustomTabContentContainer bottomButton = buildButton(uiBotExecuteContext, isOnline, isBatchLaunch, isTeamTask, locale);
            customTabContentContainerList.add(bottomButton);
        }

        String tabName = localeService.getLanguageValue(locale, isOnline ? "已上线" : "未上线") + "(" + showNum + ")";
        CustomTab customTab = new CustomTab();
        customTab.setName(tabName);
        customTab.setStyle(2);
        customTab.setAlignmentType(1);
        customTab.setIsSelected(true);
        customTab.setContent(customTabContentContainerList);
        return customTab;
    }

    /**
     * 构建子制程下的卡片集合
     *
     * @return
     */
    private void builCardList(List<Map<String, Object>> woDetailDataList, Map<String, Object> woOpReportDataMap, Map<String, String> languageNameMap,
                              Map<Integer, String> nameMapByType, String woNo, boolean isOnline,
                              Boolean isTeamTask, boolean isProductGatewayE10orT100, String docTypeNo, List<Card> cardList, String locale) {
        String opNo = (String) woOpReportDataMap.get("op_no");
        String opName = (String) woOpReportDataMap.get("op_name");
        String mergeNo = (String) woOpReportDataMap.get("merge_no");

        for (Map<String, Object> woDetailData : woDetailDataList) {

            // 这三个参数提交需要用到
            woDetailData.put("op_no", opNo);
            woDetailData.put("op_name", opName);
            woDetailData.put("wo_no", woNo);

            Map<String, Object> cardContentMap = new LinkedHashMap<>();
            cardContentMap.put(languageNameMap.get("itemName"), woDetailData.get("item_name"));
            cardContentMap.put(languageNameMap.get("itemNo"), woDetailData.get("item_no"));

            if (isProductGatewayE10orT100) {
                cardContentMap.put(languageNameMap.get("itemFeatureNo"), woDetailData.get("item_feature_no"));
                cardContentMap.put(languageNameMap.get("itemFeatureSpec"), woDetailData.get("item_feature_spec"));
            }

            if (!isOnline) {
                //未上线展示进度百分比
                String progressPercentage = null;
                if (ObjectUtil.isNotEmpty(woDetailData.get("progress_percentage"))) {
                    String progressPercentageStr = String.valueOf(woDetailData.get("progress_percentage"));
                    progressPercentage = Double.valueOf(progressPercentageStr).intValue() + "%";
                }
                cardContentMap.put(languageNameMap.get("progressPercentage"), progressPercentage);
            }
            String productionStatus = null;
            if (ObjectUtil.isNotEmpty(woDetailData.get("production_status"))) {
                productionStatus = nameMapByType.get(Integer.parseInt((String) woDetailData.get("production_status")));
            }
            cardContentMap.put(languageNameMap.get("productionStatus"), productionStatus);

            String cardDataId = UUIDUtil.getUuid();
            List<Button> buttonList = new ArrayList<>();

            if (isOnline) {
                cardContentMap.put(languageNameMap.get("remainingQty"), woDetailData.get("remaining_qty"));
                cardContentMap.put(languageNameMap.get("reportQty"), woDetailData.get("report_qty"));

                // 团队任务不展示按钮
                if (BooleanUtils.isFalse(isTeamTask)) {
                    Action handleAction = new Action();
                    handleAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_MERGE_WORK_HOUR_QUANTITY_CONFIRM.toString());
                    handleAction.setJumpPageTitle(languageNameMap.get("adjustReportQty"));
                    handleAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
                    handleAction.setDataId(cardDataId);
                    handleAction.setRawData(woDetailData);

                    Button handleButton = Button.createButton(languageNameMap.get("adjustReportQty"), UUIDUtil.getUuid(), BottomButtonStyleEnum.NORMAL.getValue(), handleAction);
                    buttonList.add(handleButton);
                }

                woDetailData.put("doc_type_no", docTypeNo);
                woDetailData.put("merge_no", mergeNo);
            }
            String cardTitle = (String) MapUtil.getOrDefault(woDetailData, "move_plot_no", StringUtils.EMPTY);
            Card card = Card.create(cardTitle, cardContentMap, buttonList, false, (String) languageNameMap.get("reportQty"));
            card.setDataId(cardDataId);
            Map<String, Object> cardRawDataMap = new HashMap<>(1);
            cardRawDataMap.put("dataDetail", woDetailData);
            card.setRawData(cardRawDataMap);
            if (!isOnline) {
                // 未上线进度100%不允许勾选
                if (ObjectUtil.isNotEmpty(woDetailData.get("progress_percentage"))) {
                    Integer progressPercentage = ((Double) woDetailData.get("progress_percentage")).intValue();
                    card.setDisableSelect(COMPLETE_PROCESS.equals(progressPercentage));
                }
            }
            cardList.add(card);
        }
    }

    /**
     * 展示字段名称map
     *
     * @param isOnline
     * @param locale
     * @return
     */
    private Map<String, String> getLanguageNameMap(boolean isOnline, String locale) {
        Map<String, String> languageValMap = new HashMap<>();
        String itemName = localeService.getLanguageValue(locale, "产品名称");
        languageValMap.put("itemName", itemName);
        String itemNo = localeService.getLanguageValue(locale, "产品编号");
        languageValMap.put("itemNo", itemNo);
        String productionStatus = localeService.getLanguageValue(locale, "制程状态");
        languageValMap.put("productionStatus", productionStatus);
        String remark = localeService.getLanguageValue(locale, "备注");
        languageValMap.put("remark", remark);
        String alreadyRemark = localeService.getLanguageValue(locale, "已备注");
        languageValMap.put("alreadyRemark", alreadyRemark);
        String itemFeatureNo = localeService.getLanguageValue(locale, "产品特征码");
        languageValMap.put("itemFeatureNo", itemFeatureNo);
        String itemFeatureSpec = localeService.getLanguageValue(locale, "特征码规格");
        languageValMap.put("itemFeatureSpec", itemFeatureSpec);
        if (isOnline) {
            String remainingQty = localeService.getLanguageValue(locale, "待出站量");
            languageValMap.put("remainingQty", remainingQty);
            String reportQty = localeService.getLanguageValue(locale, "报工数量");
            languageValMap.put("reportQty", reportQty);
            String adjustReportQty = localeService.getLanguageValue(locale, "调整报工数量");
            languageValMap.put("adjustReportQty", adjustReportQty);
        } else {
            String progressPercentage = localeService.getLanguageValue(locale, "进度百分比");
            languageValMap.put("progressPercentage", progressPercentage);
        }
        return languageValMap;
    }


    /**
     * 组装底部按钮
     *
     * @param uiBotExecuteContext
     * @param isOnline
     * @param locale
     * @return
     */
    private CustomTabContentContainer buildButton(UiBotExecuteContext uiBotExecuteContext, boolean isOnline, boolean isBatchLaunch, Boolean isTeamTask, String locale) {
        CustomTabContentContainer customTabContentContainer = new CustomTabContentContainer();
        List<BottomButtonDigiwinAthena> buttomList = new ArrayList<>(2);
        customTabContentContainer.setData(buttomList);
        customTabContentContainer.setContentCmptType(BottomButtonDigiwinAthena.COMPONENT_TYPE);

        // 团队任务不展示底部按钮
        if (BooleanUtils.isTrue(isTeamTask)) {
            return customTabContentContainer;
        }
        if (!isOnline) {
            if (isBatchLaunch) {
                Action allSelectAction = new Action();
                allSelectAction.setType(ActionTypeEnum.CALL_API.getValue());
                buttomList.add(BottomButtonDigiwinAthena.createButton(locale, allSelectAction, "全选", BottomButtonStyleEnum.SELECT_ALL.getValue(), StringUtils.EMPTY, false));
            }
            Action onlineAction = new Action();
            onlineAction.setType(ActionTypeEnum.CALL_API_SHOW_SUCCESS_MSG_REFRESH_CURRENT_PAGE.getValue());
            onlineAction.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/mergeWorkingHour/peopleOnline");

            Map<String, Object> onlineActionRawDataMap = new HashMap<>(3);
            onlineActionRawDataMap.put("executeContext", uiBotExecuteContext);
            if (uiBotExecuteContext != null) {
                onlineActionRawDataMap.put("businessUnit", uiBotExecuteContext.get("businessUnit"));
            }
            onlineActionRawDataMap.put("actionId", "wo.merge.op.report.check.in.info.process");
            onlineAction.setRawData(onlineActionRawDataMap);

            //备注上线按钮
            Action handleAction = new Action();
            handleAction.setJumpPageTitle(localeService.getLanguageValue(locale, "备注上线"));
            handleAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_REMARK_DETAIL_CONFIRM.toString());
            handleAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());

            Map<String, Object> rawData = new HashMap<>();
            rawData.put("data", onlineActionRawDataMap);
            rawData.put("isRemarkRequired", true);
            rawData.put("isShowDispatchRemark", false);
            rawData.put("isMergeWorkHour", true);
            List<BottomButtonDigiwinAthena> bottomButtonList = new ArrayList<>();
            bottomButtonList.add(BottomButtonDigiwinAthena.createNormalCancelButton(locale));
            BottomButtonDigiwinAthena saveButton = new BottomButtonDigiwinAthena();
            saveButton.setName(localeService.getLanguageValue(locale, "提交"));
            saveButton.setType(BottomButtonStyleEnum.STRESS.getValue());
            saveButton.setAction(onlineAction);
            bottomButtonList.add(saveButton);
            rawData.put("buttonList", bottomButtonList);
            handleAction.setRawData(rawData);

            buttomList.add(BottomButtonDigiwinAthena.createButton(locale, handleAction, "备注上线",
                    BottomButtonStyleEnum.NORMAL.getValue(), StringUtils.EMPTY, isBatchLaunch));
            buttomList.add(BottomButtonDigiwinAthena.createButton(locale, onlineAction, "人员上线", BottomButtonStyleEnum.STRESS.getValue(), StringUtils.EMPTY, isBatchLaunch));
        } else {
            // 取消上线
            Action cancelAction = new Action();
            cancelAction.setType(ActionTypeEnum.CALL_API_SHOW_SUCCESS_MSG_REFRESH_CURRENT_PAGE.getValue());
            cancelAction.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/mergeWorkingHour/cancelOnline");

            Map<String, Object> cancelActionRawDataMap = new HashMap<>(3);
            cancelActionRawDataMap.put("executeContext", uiBotExecuteContext);
            if (uiBotExecuteContext != null) {
                cancelActionRawDataMap.put("businessUnit", uiBotExecuteContext.get("businessUnit"));
            }
            cancelActionRawDataMap.put("actionId", "wo.merge.op.report.cancel.check.in.info.process");
            cancelAction.setRawData(cancelActionRawDataMap);

            // 人员下线
            Action offLineAction = new Action();
            offLineAction.setType(ActionTypeEnum.CALL_API_SHOW_SUCCESS_MSG_REFRESH_CURRENT_PAGE.getValue());
            offLineAction.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/mergeWorkingHour/peopleOffline");

            Map<String, Object> offLineActionRawDataMap = new HashMap<>(3);
            offLineActionRawDataMap.put("executeContext", uiBotExecuteContext);
            if (uiBotExecuteContext != null) {
                offLineActionRawDataMap.put("businessUnit", uiBotExecuteContext.get("businessUnit"));
            }
            offLineActionRawDataMap.put("actionId", "wo.op.report.info.process");
            offLineAction.setRawData(offLineActionRawDataMap);

            //备注下线按钮
            Action remarkOffLineAction = new Action();
            remarkOffLineAction.setJumpPageTitle(localeService.getLanguageValue(locale, "备注下线"));
            remarkOffLineAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_REMARK_DETAIL_CONFIRM.toString());
            remarkOffLineAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());

            Map<String, Object> rawData = new HashMap<>();
            rawData.put("data", offLineActionRawDataMap);
            rawData.put("isRemarkRequired", true);
            rawData.put("isShowDispatchRemark", false);
            rawData.put("isMergeWorkHour", true);
            List<BottomButtonDigiwinAthena> bottomButtonList = new ArrayList<>();
            bottomButtonList.add(BottomButtonDigiwinAthena.createNormalCancelButton(locale));
            BottomButtonDigiwinAthena saveButton = new BottomButtonDigiwinAthena();
            saveButton.setName(localeService.getLanguageValue(locale, "提交"));
            saveButton.setType(BottomButtonStyleEnum.STRESS.getValue());
            saveButton.setAction(offLineAction);
            bottomButtonList.add(saveButton);
            rawData.put("buttonList", bottomButtonList);
            remarkOffLineAction.setRawData(rawData);

            buttomList.add(BottomButtonDigiwinAthena.createButton(locale, cancelAction, "取消上线", BottomButtonStyleEnum.STRESS.getValue(), "#D85261", false));
            buttomList.add(BottomButtonDigiwinAthena.createButton(locale, remarkOffLineAction, "备注下线", BottomButtonStyleEnum.NORMAL.getValue(), StringUtils.EMPTY, false));
            buttomList.add(BottomButtonDigiwinAthena.createButton(locale, offLineAction, "人员下线", BottomButtonStyleEnum.STRESS.getValue(), "#31B344", false));
        }
        return customTabContentContainer;
    }

    private Map<Integer, String> translateProdcuctNameByType(String locale) {
        Map<Integer, String> nameMap = new HashMap<>(4);
        for (TaskProductStateEnum taskProductStateEnum : TaskProductStateEnum.values()) {
            nameMap.put(taskProductStateEnum.getType(), localeService.getLanguageValue(locale, taskProductStateEnum.getName()));
        }
        return nameMap;
    }

    private CustomTab buidlEmptyTab(boolean isOnline, String locale) {
        String tabName = localeService.getLanguageValue(locale, isOnline ? "已上线" : "未上线") + "(0)";
        CustomTab customTab = new CustomTab();
        customTab.setName(tabName);
        customTab.setStyle(2);
        customTab.setAlignmentType(1);
        CustomTabContentContainer customTabContentContainer = new CustomTabContentContainer();
        customTabContentContainer.setData(Empty.create(localeService.getLanguageValue(locale, "暂无数据")));
        customTabContentContainer.setContentCmptType(Empty.COMPONENT_TYPE);
        customTab.setContent(Collections.singletonList(customTabContentContainer));
        return customTab;
    }

    @Override
    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object... args) {
        return null;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}