package com.digiwin.mobile.mobileuibot.task.strategy.custom.mergeworkhour;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectList;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectListOption;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectListTypeEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActionServiceId;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDataSourceDTO;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotQueryAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * <p>功能描述：合并工时任务卡调整报工数量弹出框</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: taskDetailBuildApcWorkHourQuantityConfirmStrategy
 * @Author: xujin
 * @Date: 2023年6月12日 11点55分
 */
@Component("taskDetailBuildApcMergeWorkHourQuantityConfirmStrategy")
public class TaskDetailBuildApcMergeWorkHourQuantityConfirmStrategy implements UiBotModelBuildStrategy {
    private static final Logger logger =
            LoggerFactory.getLogger(TaskDetailBuildApcMergeWorkHourQuantityConfirmStrategy.class);

    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("Build Merge Work Hour Quantity Confirm Page");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        String locale = apiRequest.getLocale();
        ApiRawData apiRawData = apiRequest.getRawData();

        List<Integer> remainingQtyList = getRemainingQty(apiRequest);
        Integer remainingQty = apiRawData.getInteger("remaining_qty");
        Object dataValue = apiRawData.get("dataValue");

        // 拼成最终数据
        stopWatch.start("Build taskDetailBuildApcWorkHourQuantityConfirmStrategy Page Model...");
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();

        for (UiBotLayout layout : uiBotLayouts) {
            String fieldSchema = layout.getSchema();
            switch (layout.getType()) {
                case SingleSelectList.COMPONENT_TYPE:
                    SingleSelectList singleSelectList = new SingleSelectList();

                    List<SingleSelectListOption> optionList = remainingQtyList.stream().map(item->{
                        boolean selected = (Objects.equals(item, remainingQty));
                        if (dataValue != null) {
                            //选了值后默认展示选择值,前端可能有小数位带过来
                            Integer dataVal = Double.valueOf((String) dataValue).intValue();
                            selected = (dataVal.equals(item));
                        }
                        return SingleSelectListOption.create(item, selected, false, 0, StringUtils.EMPTY, StringUtils.EMPTY);
                    }).collect(Collectors.toList());

                    singleSelectList.setTitle(localeService.getLanguageValue(locale, "调整报工数量"));
                    singleSelectList.setStyle(1);
                    singleSelectList.setStyle(SingleSelectListTypeEnum.PROGRESS_REPORT.getValue());
                    singleSelectList.setOptionList(optionList);
                    uiBotModel.getPageData().put(fieldSchema, singleSelectList);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    List<BottomButtonDigiwinAthena> bottomButtonList = new ArrayList<>();
                    bottomButtonList.add(BottomButtonDigiwinAthena.createNormalCancelButton(locale));

                    BottomButtonDigiwinAthena confirmeButton = new BottomButtonDigiwinAthena();
                    confirmeButton.setName(localeService.getLanguageValue(locale, "确定"));

                    Action buttonAction = new Action();
                    buttonAction.setType(ActionTypeEnum.RETURN_AND_UPDATE.getValue());
                    buttonAction.setDataId(apiRequest.getDataId());

                    confirmeButton.setAction(buttonAction);
                    confirmeButton.setType(BottomButtonStyleEnum.STRESS.getValue());
                    bottomButtonList.add(confirmeButton);

                    uiBotModel.getPageData().put(fieldSchema, bottomButtonList);
                    break;
                default:
                    break;
            }
        }

        stopWatch.stop();
        return uiBotModel;
    }


    private List<Integer> getRemainingQty(ApiRequest apiRequest) {
        ApiRawData apiRawData = apiRequest.getRawData();
        PcUiBotDataSourceDTO pcUiBotDataSourceDTO = new PcUiBotDataSourceDTO();
        pcUiBotDataSourceDTO.setType("ESP");
        pcUiBotDataSourceDTO.setActionId("esp_wo.op.report.qty.info.get");

        PcUiBotQueryAction pcUiBotQueryAction = new PcUiBotQueryAction();
        pcUiBotQueryAction.setTitle("数量");
        pcUiBotQueryAction.setActionId("esp_wo.op.report.qty.info.get");
        pcUiBotQueryAction.setCategory("ESP");

        PcUiBotActionServiceId pcUiBotActionServiceId = new PcUiBotActionServiceId();
        pcUiBotActionServiceId.setName("wo.op.report.qty.info.get");
        pcUiBotActionServiceId.setHostAcct("athena");
        pcUiBotQueryAction.setServiceId(pcUiBotActionServiceId);

        Map<String, Object> woOpReportDataMap = new HashMap<>();
        woOpReportDataMap.put("eoc_company_id", apiRawData.get("eoc_company_id"));
        woOpReportDataMap.put("eoc_site_id", apiRawData.get("eoc_site_id"));
        woOpReportDataMap.put("eoc_region_id", apiRawData.get("eoc_region_id"));
        woOpReportDataMap.put("wo_no", apiRawData.get("wo_no"));
        woOpReportDataMap.put("plot_no", apiRawData.get("plot_no"));
        woOpReportDataMap.put("op_seq", apiRawData.get("op_seq"));
        woOpReportDataMap.put("remaining_qty", apiRawData.get("remaining_qty"));
        woOpReportDataMap.put("plan_source", apiRawData.get("plan_source"));
        woOpReportDataMap.put("report_qty", apiRawData.get("report_qty"));
        woOpReportDataMap.put("category", "5");

        Map<String, Object> paras = new HashMap<>(2);
        paras.put("report_order_control", true);
        paras.put("wo_op_report_data", Collections.singletonList(woOpReportDataMap));
        pcUiBotQueryAction.setParas(paras);

        Map<String, Object> businessUnitMap = new HashMap<>(1);
        businessUnitMap.put("eoc_company_id", apiRawData.getString("eoc_company_id"));
        businessUnitMap.put("eoc_site_id", apiRawData.getString("eoc_site_id"));
        pcUiBotQueryAction.setBusinessUnit(businessUnitMap);

        pcUiBotDataSourceDTO.setAction(pcUiBotQueryAction);

        List<PcUiBotDataSourceDTO> dataSourceList = new ArrayList<>();
        dataSourceList.add(pcUiBotDataSourceDTO);

        Map<String, Object> dataSourceListMap = new HashMap<>(1);
        dataSourceListMap.put("dataSourceList", dataSourceList);

        Map<String, Object> paramMap = new HashMap<>(2);
        paramMap.put("dataSourceSet", dataSourceListMap);
        paramMap.put("executeContext", Collections.emptyMap());
        paramMap.put("parameter", paras);
        UiBotModel uiBotModel = digiwinPcUiBotProxyService.actionShow(apiRequest.getLocale(), apiRequest.getIamUserToken(),
                JsonUtil.javaObjectToJsonString(paramMap));

        if (CollectionUtils.isEmpty(uiBotModel.getLayout()) || CollectionUtils.isEmpty(uiBotModel.getPageData())) {
            return Collections.emptyList();
        }

        List<Map<String, Object>> woOpReportDataList = (List<Map<String, Object>>) MapUtil.getOrDefault(uiBotModel.getPageData(), uiBotModel.getLayout().get(0).getSchema(), Collections.emptyList());
        if (CollectionUtils.isEmpty(woOpReportDataList)) {
            return Collections.emptyList();
        }
        return woOpReportDataList.stream().map(item -> MapUtils.getInteger(item, "report_qty")).collect(Collectors.toList());
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
