package com.digiwin.mobile.mobileuibot.task.strategy.custom.mergeworkhour;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParam;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.util.*;

/**
 * <p>功能描述：备注信息弹出框</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: taskDetailBuildApcRemarkDetailStrategy
 * @Author: xujin
 * @Date: 2023年11月7日 11点55分
 */
@Component("taskDetailBuildApcRemarkDetailStrategy")
public class TaskDetailBuildApcRemarkDetailStrategy implements UiBotModelBuildStrategy {
    private static final Logger logger =
            LoggerFactory.getLogger(TaskDetailBuildApcRemarkDetailStrategy.class);

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("Build Remark Detail Page");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        // 前端保存，信息再次编辑的时候初始化
        initDataHandle(apiRequest);

        UiBotModel uiBotModel = pageSetting.getPageModel();
        String locale = apiRequest.getLocale();
        Map<String, Object> rawData = apiRequest.getRawData().getInnerMap();

        Map<String, Object> dataDetail = (Map<String, Object>) MapUtil.getOrDefault(rawData, "data", Collections.emptyMap());
        List<BottomButtonDigiwinAthena> bottomButtonList = JsonUtil.objectToJavaObject(MapUtil.getOrDefault(rawData, "buttonList", Collections.emptyList()),
                new TypeReference<List<BottomButtonDigiwinAthena>>() {
                });
        // 备注是否必填
        boolean isRemarkRequired = (boolean) MapUtil.getOrDefault(rawData, "isRemarkRequired", false);

        // 是否展示制令备注（目前除了合并工时，其他都默认展示）
        boolean isShowDispatchRemark = (boolean) MapUtil.getOrDefault(rawData, "isShowDispatchRemark", true);

        //合并工时需要将选中的数据带过来
        if ((boolean) MapUtil.getOrDefault(rawData, "isMergeWorkHour", false)) {

            // 备注信息需要初始化展示，与应用沟通条目的备注都会一致
            List<Map<String, Object>> selectCardList = (List<Map<String, Object>>) rawData.get("selectCardList");
            for (Map<String, Object> selectCard : selectCardList) {
                Map<String, Object> selectCardRawData = (Map<String, Object>) selectCard.get("rawData");
                Map<String, Object> dataDetaiMap = (Map<String, Object>) selectCardRawData.get("dataDetail");
                if (CollectionUtils.isEmpty(dataDetaiMap)) {
                    continue;
                }
                String remark = MapUtils.getString(dataDetaiMap, "remark");
                if (StringUtils.isNotEmpty(remark)) {
                    dataDetail.put("remark", remark);
                    break;
                }
            }

            //选中和卡片数据需要传递到提交接口中
            bottomButtonList.stream().filter(bottomButtonDigiwinAthena -> 1 == bottomButtonDigiwinAthena.getType()).map(Button::getAction)
                    .map(action -> (Map) action.getRawData())
                    .forEach(map -> {
                        map.put("selectCardList", rawData.get("selectCardList"));
                        map.put("isRemarkAction", true);
                    });
        }

        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();

        // 如果存在除制令备注和备注的其他栏位，都需要从上一页rawData获取到
        UiBotModel dynamicsUiBotModel = JsonUtil.objectToJavaObject(MapUtil.getOrDefault(rawData, "dynamics_uiBotModel", UiBotModel.emptyUiBotModel()), UiBotModel.class);
        List<UiBotLayout> dynamicsUiBotLayouts = Optional.ofNullable(dynamicsUiBotModel).map(UiBotModel::getLayout).orElse(Collections.emptyList());

        List<UiBotLayout> newUiBotLayouts = new LinkedList<>();
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();

            // 其他栏位直接组装
            if (!CollectionUtils.isEmpty(dynamicsUiBotLayouts) && "dynamics_label".equalsIgnoreCase(schema)) {
                newUiBotLayouts.addAll(dynamicsUiBotLayouts);
                pageData.putAll(dynamicsUiBotModel.getPageData());
                continue;
            }

            if (StringUtils.isEmpty(layout.getType())) {
                continue;
            }

            switch (layout.getType()) {
                case Field.COMPONENT_TYPE:
                    if (isShowDispatchRemark) {
                        // 制令备注
                        String name = localeService.getLanguageValue(locale, layout.getLabel());
                        String data = String.valueOf(MapUtil.getOrDefault(dataDetail, schema, StringUtils.EMPTY));
                        Field field = Field.createLabelLeftValueRightField(name, data);
                        newUiBotLayouts.add(layout);
                        pageData.put(schema, field);
                    }
                    break;
                case InputMultiText.COMPONENT_TYPE:
                    // 备注
                    String text = String.valueOf(MapUtil.getOrDefault(dataDetail, schema, StringUtils.EMPTY));
                    newUiBotLayouts.add(layout);
                    pageData.put(schema, InputMultiText.create(schema, localeService.getLanguageValue(locale,
                                    layout.getLabel()), text, true, isRemarkRequired, true, locale,
                            255));
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    if (!CollectionUtils.isEmpty(bottomButtonList)) {
                        newUiBotLayouts.add(layout);
                        pageData.put(schema, bottomButtonList);
                    }
                    break;
                default:
                    break;
            }
        }
        uiBotModel.setLayout(newUiBotLayouts);
        return uiBotModel;
    }

    /**
     * 备注信息初始化
     *
     * @param apiRequest
     */
    public void initDataHandle(ApiRequest apiRequest) {
        if (CollectionUtils.isEmpty(apiRequest.getSubmitParam())) {
            return;
        }

        Map<String, Object> rawData = apiRequest.getRawData();
        Map<String, Object> dataDetail = (Map<String, Object>) MapUtil.getOrDefault(rawData, "data", Collections.emptyMap());
        for (ActionSubmitParam actionSubmitParam : apiRequest.getSubmitParam()) {
            switch (actionSubmitParam.getType()) {
                case InputMultiText.COMPONENT_TYPE:
                    // 备注
                    InputMultiText inputMultiText = JsonUtil.objectToJavaObject(actionSubmitParam.getParams(), InputMultiText.class);
                    dataDetail.put(actionSubmitParam.getSchema(), inputMultiText.getText());
                    break;
                default:
                    break;
            }
        }
    }


    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}