package com.digiwin.mobile.mobileuibot.task.strategy.custom.qrcode;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.index.TodoList;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildMyTaskListStrategy;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklog;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * <p>功能描述：扫码搜索-任务列表页</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: uiBotModelBuildSearchTaskListStrategy
 * @Author: xujin
 * @Date: 2024年05月09日 11点55分
 */
@Component("uiBotModelBuildQrCodeSearchTaskListStrategy")
public class UiBotModelBuildQrCodeSearchTaskListStrategy implements UiBotModelBuildStrategy {
    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildQrCodeSearchTaskListStrategy.class);

    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;

    @Autowired
    private UiBotModelBuildMyTaskListStrategy uiBotModelBuildMyTaskListStrategy;

    @Autowired
    private LocaleService localeService;

    @Autowired
    private ActivityFilterService activityFilterService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("Build QrCode SearchTask List");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        Map<String, Object> rawData = apiRequest.getRawData().getInnerMap();

        if (Objects.isNull(rawData.get("searchedBacklogList"))) {
            return UiBotModel.emptyTaskUibotModel(apiRequest.getLocale());
        }
        List<DigiwinAtmcBacklog> searchedBacklogList = JsonUtil.objectToJavaObject(rawData.get("searchedBacklogList"), new TypeReference<List<DigiwinAtmcBacklog>>() {
        });
        if (CollectionUtils.isEmpty(searchedBacklogList)) {
            return UiBotModel.emptyTaskUibotModel(apiRequest.getLocale());
        }

        String tenantVersion = activityFilterService.tenantVersion(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());

        TodoList todoList = new TodoList();
        uiBotModelBuildMyTaskListStrategy
                .paddingMobileTaskListFormWithOutFilterList(apiRequest, searchedBacklogList, todoList, true, tenantVersion);
        if (CollectionUtils.isEmpty(todoList.getTodoList())) {
            return UiBotModel.emptyTaskUibotModel(apiRequest.getLocale());
        }

        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case TodoList.COMPONENT_TYPE:
                    todoList.setCalenderType(1);
                    pageData.put(schema, todoList);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
