package com.digiwin.mobile.mobileuibot.task.strategy.custom.schedulereport;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * <p>功能描述：进度回报和工时回报的附件详情页面生成策略</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskDetailBuildApcCommonAttachmentDetailStrategy
 * @Author: xujinc
 * @Date: 2024年8月19日 11点55分
 */
@Component("taskDetailBuildApcCommonAttachmentDetailStrategy")
public class TaskDetailBuildApcCommonAttachmentDetailStrategy implements UiBotModelBuildStrategy {
    private static final Logger logger =
            LoggerFactory.getLogger(TaskDetailBuildApcCommonAttachmentDetailStrategy.class);

    // 附件类型schema前缀
    private static final String ATTACHMENT_SCHEMA_PREFIX = "source_type_";

    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("Build APC Attachemnt Detail Page");
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        if (!useMockData) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        String locale = apiRequest.getLocale();
        Map<String, Object> rawData = apiRequest.getRawData().getInnerMap();

        Map<String, Object> data = (Map<String, Object>) MapUtil.getOrDefault(rawData, "data", Collections.emptyMap());
        Map<String, Object> queryRawData = new HashMap<>();
        queryRawData.put("wo_no", data.get("wo_no"));
        queryRawData.put("plot_no", data.get("plot_no"));
        queryRawData.put("op_seq", data.get("op_seq"));
        queryRawData.put("op_no", data.get("op_no"));
        queryRawData.put("sub_op_seq", data.get("sub_op_seq"));
        queryRawData.put("sub_op_no", data.get("sub_op_no"));
        Map<String, Object> reportInfoMap = new HashMap<>(1);
        reportInfoMap.put("wo_op_report_attachment_data", Collections.singletonList(queryRawData));

        Map<String, Object> requestParamMap = new HashMap<>(2);
        requestParamMap.put("parameter", reportInfoMap);
        requestParamMap.put("actionId", "bm.opsc.lc.wo.op.report.attachment.get");
        DigiwinAthenaApiResponse<JSONObject> resp = digiwinAtdmProxyService
                .handleByActionId(locale, apiRequest.getIamUserToken(),
                        apiRequest.getTenantId(), "", requestParamMap);
        List<Map<String, Object>> woOpReportAttachmentDataList = Optional.ofNullable(resp)
                .map(DigiwinAthenaApiResponse::getResponse)
                .map(e -> (List<Map<String, Object>>) e.get("wo_op_report_attachment_data"))
                .orElse(Collections.emptyList());
        woOpReportAttachmentDataList = woOpReportAttachmentDataList.stream()
                .filter(e -> !ObjectUtils.isEmpty(e.get("attachment")))
                .collect(Collectors.toList());

        Map<String, List<Map<String, Object>>> woOpReportAttachmentDataMapBySourceType = new HashMap<>();
        if (!CollectionUtils.isEmpty(woOpReportAttachmentDataList)) {
            woOpReportAttachmentDataMapBySourceType = woOpReportAttachmentDataList.stream()
                    .collect(Collectors.groupingBy(e -> MapUtils.getString(e, "source_type")));
        }

        // 拼成最终数据
        stopWatch.start("Build APC Attachemnt Detail Page Model...");
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case CustomGroup.COMPONENT_TYPE:
                    CustomGroup customGroup = JsonUtil.objectToJavaObject(uiBotModel.getPageData().get(schema), CustomGroup.class);
                    CustomGroupContent customGroupContent = customGroup.getContent();
                    List<UiBotLayout> customGroupUiBotLayouts = customGroupContent.getLayout();
                    Iterator<UiBotLayout> customGroupUiBotLayoutIterator = customGroupUiBotLayouts.iterator();
                    while (customGroupUiBotLayoutIterator.hasNext()) {
                        UiBotLayout customGroupUiBotLayout = customGroupUiBotLayoutIterator.next();
                        String customGroupSchema = customGroupUiBotLayout.getSchema();
                        switch (customGroupUiBotLayout.getType()) {
                            case Attachment.COMPONENT_TYPE:
                                String sourceType = customGroupSchema.replace(ATTACHMENT_SCHEMA_PREFIX, "");
                                List<Map<String, Object>> attachmentDataListBySourceType = woOpReportAttachmentDataMapBySourceType.get(sourceType);
                                if (CollectionUtils.isEmpty(attachmentDataListBySourceType)) {
                                    customGroupUiBotLayoutIterator.remove();
                                    continue;
                                }
                                List<Map<String, Object>> dataList = attachmentDataListBySourceType.stream().map(e -> {
                                    Map<String, Object> attachmentBySourceType = (Map<String, Object>) MapUtil.getOrDefault(e, "attachment", Collections.emptyMap());
                                    return (List<Map<String, Object>>) MapUtil.getOrDefault(attachmentBySourceType, "data", Collections.emptyList());
                                }).flatMap(Collection::stream).collect(Collectors.toList());

                                Attachment attachment = Attachment.createAttachment(dataList, null, localeService.getLanguageValue(locale, customGroupUiBotLayout.getLabel()));
                                customGroupContent.getPageData().put(customGroupSchema, attachment);
                                break;
                        }
                    }
                    if (CollectionUtils.isEmpty(customGroupUiBotLayouts)) {
                        layout.setType(Empty.COMPONENT_TYPE);
                        uiBotModel.getPageData().put(schema, Empty.create(localeService.getLanguageValue(locale, "暂无数据"), true));
                    } else {
                        uiBotModel.getPageData().put(schema, customGroup);
                    }
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    BottomButtonDigiwinAthena submitButton = BottomButtonDigiwinAthena.createNormalCancelButton(locale, "关闭");
                    uiBotModel.getPageData().put(schema, Collections.singletonList(submitButton));
                    break;
                default:
                    break;
            }
        }

        stopWatch.stop();
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
