package com.digiwin.mobile.mobileuibot.task.strategy.custom.snm;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZhilinkBarcodeData;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZhilinkBarcodeDataResponse;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZhilinkService;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetailCustom;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildBizProcessStrategy;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildStrategy;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>功能描述：一物一码出厂任务详情页面</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskDetailBuildSnmCheckoutStrategy
 * @Author: Zaregoto
 * @Date: 2021/12/8 21:14
 */
@Slf4j
@Component("taskDetailBuildSnmCheckoutStrategy")
public class TaskDetailBuildSnmCheckoutStrategy implements TaskDetailBuildStrategy {

    @Autowired
    private TaskDetailBuildBizProcessStrategy taskDetailBuildBizProcessStrategy;

    @Autowired
    private ZhilinkService zhilinkService;

    @Override
    public String getTaskDetailType() {
        return TaskStringUtil.CUSTOM_PROJECT_CODE_ZHILINK_CHECKOUT
                + TaskStringUtil.LINK_SYMBOL + TaskStringUtil.CUSTOM_TASK_CODE_ZHILINK_CHECKOUT;
    }

    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;

    @Override
    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                                      Object... args) {
        TaskDetail taskDetail = this.build(apiRequest, pageSetting, pcUiBotModel, args);
        return uiBotModelBuildService.buildModel(pageSetting, taskDetail, true);
    }

    @Override
    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                            Object... args) {
        UiBotPageData uiBotPageData = pcUiBotModel.getPageData();
        String bizDataSchema = pcUiBotModel.searchBizDataSchema();
        Object bizDataRaw = uiBotPageData.get(bizDataSchema);
        if (bizDataRaw instanceof List) {
            List<Map<String, Object>> bizData = (List<Map<String, Object>>) bizDataRaw;
            if (bizData.isEmpty()) {
                log.error("bizData is empty, return EMPTY one. Build process stopped...");
                return TaskDetailCustom.createEmpty();
            }
            // 通过ATDM调用bm.bcsc.barcode.get，获取任务详情
            ZhilinkBarcodeDataResponse barcodeDataResponse =
                    this.zhilinkService.getCheckoutBarcodeTaskDetail(apiRequest, pcUiBotModel,
                            bizData.get(0));

            if (bizData.size() != barcodeDataResponse.getBarcodeData().size()) {
                log.error(
                        "bizData size NOT equals the one of barcodeDataResponse, return EMPTY one. Build process aborted...");
                return TaskDetailCustom.createEmpty();
            }

            // 将上方ATDM调用的api数据，与uibot返回的业务数据合并
            List<ZhilinkBarcodeData> barcodeDataList = barcodeDataResponse.getBarcodeData();
            Map<String, List<ZhilinkBarcodeData>> groupedBarcodeDataList =
                    barcodeDataList.stream()
                            .collect(Collectors.groupingBy(e -> generateZhilinkBarcodeDataGroupKey(e)));
            // 按分组条件求出qty的sum。
            Map<String, Long> groupedSumCollect =
                    barcodeDataList.stream()
                            .collect(
                                    Collectors.groupingBy(e -> generateZhilinkBarcodeDataGroupKey(e),
                                            Collectors.summingLong(ZhilinkBarcodeData::getQty))
                            );

            List<Map<String, Object>> finalBarcodeDataList = new ArrayList<>();
            for (String groupKey : groupedBarcodeDataList.keySet()) {
                Long qtySum = groupedSumCollect.get(groupKey);
                List<ZhilinkBarcodeData> groupedDataList = groupedBarcodeDataList.get(groupKey);
                if (!groupedDataList.isEmpty()) {
                    ZhilinkBarcodeData tempData = groupedDataList.get(0);
                    tempData.setQty(qtySum);

                    finalBarcodeDataList.add(JsonUtil.objectToJavaObject(tempData,
                            new TypeReference<Map<String, Object>>() {
                            }));
                }
            }

            // 更新数据到pcUiBotModel的pageData内
            String dataSchema = pcUiBotModel.searchBizDataSchema();
            pcUiBotModel.getPageData().put(dataSchema, finalBarcodeDataList);

            return this.taskDetailBuildBizProcessStrategy.build(apiRequest, pageSetting,
                    pcUiBotModel, args);

        } else {
            log.error(
                    "bizData isn't instanceof list, return EMPTY one. Build process aborted...");
            return TaskDetailCustom.createEmpty();
        }

    }

    private String generateZhilinkBarcodeDataGroupKey(ZhilinkBarcodeData zhilinkBarcodeData) {
        return zhilinkBarcodeData.getSnStorageSpacesNo() + ZhilinkService.GROUP_KEY + zhilinkBarcodeData.getItemNo();
    }
}
