package com.digiwin.mobile.mobileuibot.task.strategy.custom.snm;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.input.scan.InputScanMulti;
import com.digiwin.mobile.mobileuibot.core.component.input.scan.InputScanSingle;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZhilinkService;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetailCustom;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildStrategy;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * <p>功能描述：一物一码粘贴任务条目明细的详情页面</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskDetailBuildSnmPasteDetailItemDetailStrategy
 * @Author: Zaregoto
 * @Date: 2021/12/8 16:42
 */
@Slf4j
@Component("taskDetailBuildSnmPasteDetailItemDetailStrategy")
public class TaskDetailBuildSnmPasteDetailItemDetailStrategy
        implements TaskDetailBuildStrategy {

    @Autowired
    private LocaleService localeService;

    @Autowired
    private ZhilinkService zhilinkService;

    @Override
    public String getTaskDetailType() {
        return PageSettingIdPresetEnum.MOBILE_ATHENA_ZHILINK_PASTE_DETAIL_ITEM_DETAIL.toString();
    }

    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;

    @Override
    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                                      Object... args) {
        TaskDetail taskDetail = this.build(apiRequest, pageSetting, pcUiBotModel, args);
        return uiBotModelBuildService.buildModel(pageSetting, taskDetail, true);
    }

    @Override
    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                            Object... args) {
        TaskDetailCustom taskDetailCustom = new TaskDetailCustom(this.localeService);

        // 通过ATDM调用zhilink.wo.product.item.summary.info.get，并将数据与uibot的bizData合并。
        // 合并原因：因为有些字段uibot没有返回，但app界面需要展示，所以这样处理
        Map<String, Object> itemDataResponse =
                this.zhilinkService.woProductItemSummaryInfoGet(apiRequest, pcUiBotModel);
        List<Map<String, Object>> itemDataList =
                (List<Map<String, Object>>) itemDataResponse.get("item_data");
        String schema = pcUiBotModel.searchBizDataSchema();
        if (null != itemDataList && !itemDataList.isEmpty()) {
            pcUiBotModel.getPageData().put(schema, itemDataList);
        }
        String requestItemNo = apiRequest.getRawData().getJSONObject("data").getJSONArray(schema).getJSONObject(0).getString("item_no");
        for (Map<String, Object> currentItemData : itemDataList) {
            String itemDataItemNo = (String) currentItemData.get("item_no");
            if (Objects.equals(requestItemNo, itemDataItemNo)) {
                this.createBySingleBizDataItem(apiRequest, pageSetting, pcUiBotModel, taskDetailCustom, currentItemData);
            } else {
                continue;
            }
        }

        return taskDetailCustom;
    }

    private void createBySingleBizDataItem(ApiRequest apiRequest, PageSetting pageSetting,
                                           UiBotModel pcUiBotModel, TaskDetailCustom taskDetailCustom, Map<String, Object> bizDataItem) {
        UiBotModel pageSettingModel = pageSetting.getPageModel();
        Map<String, Object> pageData = pageSettingModel.getPageData();

        for (int i = 0; i < pageSettingModel.getLayout().size(); i++) {
            UiBotLayout pageSettingLayout = pageSettingModel.getLayout().get(i);
            String bizDataSchema = pageSettingLayout.getSchema();
            String type = pageSettingLayout.getType();
            if (type.equals(Field.COMPONENT_TYPE)) {
                String fieldLabel = Optional.ofNullable(pageSettingLayout.getmLabelText())
                        .map(labelTextMap -> labelTextMap.get(apiRequest.getLocale()))
                        .orElse(bizDataSchema);
                Field fieldComponent =
                        Field.create(fieldLabel, null, String.valueOf(bizDataItem.get(bizDataSchema)),
                                bizDataSchema);
                // 只读的话，空值，移动不显示
                if (!fieldComponent.getValue().trim().isEmpty()) {
                    taskDetailCustom.put(bizDataSchema, fieldComponent);
                }
            } else if (type.equals(InputScanSingle.COMPONENT_TYPE)) {
                InputScanSingle inputScanSingle =
                        JsonUtil.objectToJavaObject(pageData.get(pageSettingLayout.getSchema()),
                                InputScanSingle.class);

                // 对checkUrl增加工程访问前缀
                if (Optional.ofNullable(inputScanSingle.getCheck()).orElse(false)) {
                    String oldCheckUrl = inputScanSingle.getCheckUrl();
                    String newCheckUrl = AppContext.getBaseUrl() + oldCheckUrl;
                    inputScanSingle.setCheckUrl(newCheckUrl);
                }
                String fieldLabel = Optional.ofNullable(pageSettingLayout.getmLabelText())
                        .map(labelTextMap -> labelTextMap.get(apiRequest.getLocale()))
                        .orElse(bizDataSchema);
                inputScanSingle.setTitle(fieldLabel);
                // 设置rawData
                Map<String, Object> rawData = new HashMap<>();
                rawData.put("data", bizDataItem.get("wo_data"));
                inputScanSingle.setRawData(rawData);
                taskDetailCustom.put(bizDataSchema, inputScanSingle);
            } else if (type.equals(InputScanMulti.COMPONENT_TYPE)) {
                InputScanMulti inputScanMulti =
                        JsonUtil.objectToJavaObject(pageData.get(pageSettingLayout.getSchema()),
                                InputScanMulti.class);
                // 对checkUrl增加工程访问前缀
                if (Optional.ofNullable(inputScanMulti.getCheck()).orElse(false)) {
                    String oldCheckUrl = inputScanMulti.getCheckUrl();
                    String newCheckUrl = AppContext.getBaseUrl() + oldCheckUrl;
                    inputScanMulti.setCheckUrl(newCheckUrl);
                }
                String fieldLabel = Optional.ofNullable(pageSettingLayout.getmLabelText())
                        .map(labelTextMap -> labelTextMap.get(apiRequest.getLocale()))
                        .orElse(bizDataSchema);
                inputScanMulti.setTitle(fieldLabel);
                // 设置rawData
                inputScanMulti.setRawData(
                        this.zhilinkService.getScanRawDataInPasteDetail(pcUiBotModel,
                                (List<Map<String, Object>>) bizDataItem.get("wo_data")));
                taskDetailCustom.put(bizDataSchema, inputScanMulti);
            } else if (type.equals(BottomButtonDigiwinAthena.COMPONENT_TYPE)) {
                BottomButtonList bottomButtonList =
                        JsonUtil.objectToJavaObject(pageData.get(pageSettingLayout.getSchema()),
                                BottomButtonList.class);
                bottomButtonList.forEach(bottomButton -> {
                    String oldName = bottomButton.getName();
                    String newName =
                            LocaleUtil.getMobileTextByDatabaseKey(apiRequest.getLocale(), oldName);
                    bottomButton.setName(newName);
                });

                taskDetailCustom.put(bizDataSchema, bottomButtonList);
            } else {

            }

        }
    }
}
