package com.digiwin.mobile.mobileuibot.task.strategy.custom.snm;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZhilinkService;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildBizProcessStrategy;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildStrategy;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：一物一码打印任务详情页面</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskDetailBuildSnmPrintStrategy
 * @Author: Zaregoto
 * @Date: 2021/12/8 21:14
 */
@Slf4j
@Component("taskDetailBuildSnmPrintStrategy")
public class TaskDetailBuildSnmPrintStrategy implements TaskDetailBuildStrategy {

    @Autowired
    private TaskDetailBuildBizProcessStrategy taskDetailBuildBizProcessStrategy;

    @Autowired
    private ZhilinkService zhilinkService;

    @Override
    public String getTaskDetailType() {
        return TaskStringUtil.CUSTOM_PROJECT_CODE_ZHILINK_PRINT
                + TaskStringUtil.LINK_SYMBOL + TaskStringUtil.CUSTOM_TASK_CODE_ZHILINK_PRINT;
    }

    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;

    @Override
    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                                      Object... args) {
        TaskDetail taskDetail = this.build(apiRequest, pageSetting, pcUiBotModel, args);
        return uiBotModelBuildService.buildModel(pageSetting, taskDetail, true);
    }

    @Override
    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                            Object... args) {
        // 通过ATDM调用zhilink.wo.product.item.summary.info.get，并将数据与uibot的bizData合并。
        // 合并原因：因为有些字段uibot没有返回，但app界面需要展示，所以这样处理
        // 注意这里把pcUiBotModel的pageData更新后，在对应提交的逻辑中，需要处理一下数据。详见ActionServiceImpl中对应的打印任务提交逻辑
        Map<String, Object> itemDataResponse =
                this.zhilinkService.woProductItemSummaryInfoGet(apiRequest, pcUiBotModel);
        List<Map<String, Object>> itemDataList =
                (List<Map<String, Object>>) itemDataResponse.get("item_data");
        if (null != itemDataList && !itemDataList.isEmpty()) {
            String schema = pcUiBotModel.searchBizDataSchema();
            pcUiBotModel.getPageData().put(schema, itemDataList);
        }

        return this.taskDetailBuildBizProcessStrategy.build(apiRequest, pageSetting, pcUiBotModel,
                args);
    }
}
