package com.digiwin.mobile.mobileuibot.task.strategy.custom.ssc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponentRelatedEnum;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.input.hidden.InputHidden;
import com.digiwin.mobile.mobileuibot.core.component.input.sign.InputSign;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBodyBizProcessBuilder;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.DigiwinAtdmRequest;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetailCustom;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildStrategy;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

import java.util.*;

/**
 * <p>功能描述：SSC应用员工考勤确认任务详情</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskDetailBuildSscEmployeeAttendanceConfirmationStrategy
 * @Author: Zaregoto
 * @Date: 2021/11/9 16:50
 */
@Slf4j
@Component("taskDetailBuildSscEmployeeAttendanceConfirmationStrategy")
public class TaskDetailBuildSscEmployeeAttendanceConfirmationStrategy implements TaskDetailBuildStrategy {

    @Autowired
    private LocaleService localeService;

    @Autowired
    private TitleBodyBizProcessBuilder titleBodyBizProcessBuilder;

    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;

    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;

    @Override
    public String getTaskDetailType() {
        return TaskStringUtil.CUSTOM_PROJECT_CODE_ATTENDANCE_CONFIRMATION
                + TaskStringUtil.LINK_SYMBOL
                + TaskStringUtil.CUSTOM_TASK_CODE_EMPLOYEE_ATTENDANCE_CONFIRMATION;
    }

    @Override
    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                                      Object... args) {
        TaskDetail taskDetail = this.build(apiRequest, pageSetting, pcUiBotModel, args);
        return uiBotModelBuildService.buildModel(pageSetting, taskDetail, true);
    }

    @Override
    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                            Object... args) {
        TaskDetailCustom taskDetailCustom = new TaskDetailCustom(this.localeService);

        // 找到实际明细数据的layout
        Optional<UiBotLayout> optUiBotLayout = pcUiBotModel.getLayout().stream().filter(
                uiBotLayout -> "employeeAttendanceConfirmation-task-detail-waitting".equals(
                        uiBotLayout.getType())).findFirst();
        UiBotLayout pcUiBotLayout = optUiBotLayout.orElseGet(UiBotLayout::new);
        String schema = "attendance_result_group";
        // 因为是TABLE类型的layout，所以数据一定是数组
        List<Map<String, Object>> bizData =
                (List<Map<String, Object>>) pcUiBotModel.getPageData().get(schema);
        Assert.notNull(bizData, "pagedata." + schema + " cannot be null");
        // FIXME 业务场景上只会有一条数据
        if (bizData.size() != 1) {
            return TaskDetailCustom.createEmpty();
        }

        UiBotModel pageSettingModel = pageSetting.getPageModel();
        Map<String, Object> pageData = pageSettingModel.getPageData();

        for (Map<String, Object> bizDataItem : bizData) {
            createBySingleBizDataItem(apiRequest, pageSetting, pcUiBotModel, taskDetailCustom,
                    pcUiBotLayout, schema, bizData, pageSettingModel, pageData, bizDataItem, args);
        }

        this.firstCheckDateUpdate(apiRequest, schema, pcUiBotLayout, bizData);

        return taskDetailCustom;
    }

    private void createBySingleBizDataItem(ApiRequest apiRequest, PageSetting pageSetting,
                                           UiBotModel pcUiBotModel, TaskDetailCustom taskDetailCustom, UiBotLayout pcUiBotLayout,
                                           String schema, List<Map<String, Object>> bizData, UiBotModel pageSettingModel,
                                           Map<String, Object> pageData, Map<String, Object> bizDataItem, Object... args) {
        int dynamicCreateLayoutIdx = -1;
        List<UiBotLayout> dynamicCreateLayoutList = new ArrayList<>();

        for (int i = 0; i < pageSettingModel.getLayout().size(); i++) {
            UiBotLayout pageSettingLayout = pageSettingModel.getLayout().get(i);
            String bizDataSchema = pageSettingLayout.getSchema();
            String type = pageSettingLayout.getType();
            if (type.equals(TitleBody.COMPONENT_TYPE)) {
                TitleBody titleBody =
                        this.titleBodyBizProcessBuilder.build(apiRequest, pageSetting, pcUiBotModel,
                                TitleBody.class, args);
                if (null != pageSettingLayout.getMLabelPosition()) {
                    titleBody.setLabelPosition(pageSettingLayout.getMLabelPosition());
                }
                taskDetailCustom.put(pageSettingLayout.getSchema(), titleBody);
            } else if (type.equals(Field.COMPONENT_TYPE)) {
                String fieldLabel = Optional.ofNullable(pageSettingLayout.getmLabelText())
                        .map(labelTextMap -> labelTextMap.get(apiRequest.getLocale()))
                        .orElse(bizDataSchema);
                Field fieldComponent =
                        Field.create(fieldLabel, null, String.valueOf(bizDataItem.get(bizDataSchema)),
                                bizDataSchema);
                // 只读的话，空值，移动不显示
                if (!fieldComponent.getValue().trim().isEmpty()) {
                    taskDetailCustom.put(bizDataSchema, fieldComponent);
                }
            } else if (type.equals(InputSign.COMPONENT_TYPE)) {
                String fieldLabel = Optional.ofNullable(pageSettingLayout.getmLabelText())
                        .map(labelTextMap -> labelTextMap.get(apiRequest.getLocale()))
                        .orElse(bizDataSchema);
                InputSign inputSign =
                        InputSign.create(apiRequest.getLocale(), fieldLabel, schema, bizDataItem,
                                Collections.emptyList());
                // 因此任务为定制，签名字段必填属性需单独设置
                inputSign.setRequired(true);
                taskDetailCustom.put(bizDataSchema, inputSign);
            } else if (type.equals(
                    MobileComponentRelatedEnum.DYNAMIC_CREATE_LAYOUT_TYPE.getValue())) {
                dynamicCreateLayoutIdx = i;
                /**
                 * 数据结构如下
                 * attendance_result_group_detail:[
                 *  {item_name: "应出勤", item_value: "21"},
                 *  {item_name: "实出勤", item_value: "20"},
                 *  {item_name: "请假时数", item_value: "8"},
                 *  {item_name: "加班时数", item_value: "24"},
                 *  {item_name: "迟到次数", item_value: "1"},
                 *  {item_name: "早退次数", item_value: "5"},
                 *  {item_name: "旷工次数", item_value: "1"}
                 *  ]
                 */
                List<Map<String, Object>> attendanceDetailList =
                        (List<Map<String, Object>>) bizDataItem.get("attendance_result_group_detail");
                attendanceDetailList.forEach(detail -> {
                    String itemName = detail.containsKey("item_name") ?
                            String.valueOf(detail.get("item_name")) :
                            "";
                    String itemValue = detail.containsKey("item_value") ?
                            String.valueOf(detail.get("item_value")) :
                            "";
                    Field detailField = Field.create(itemName, itemValue);
                    String tempDetailFieldSchema = Field.COMPONENT_TYPE + "_" + UUIDUtil.getUuid();
                    taskDetailCustom.put(tempDetailFieldSchema, detailField);

                    dynamicCreateLayoutList.add(
                            new UiBotLayout(tempDetailFieldSchema, Field.COMPONENT_TYPE));
                });
            } else if (type.equals(BottomButtonDigiwinAthena.COMPONENT_TYPE)) {
                UiBotAction customUiBotAction = null;
                if (null == pcUiBotLayout.getActions() || pcUiBotLayout.getActions().isEmpty()) {
                    customUiBotAction = new UiBotAction();
                    customUiBotAction.setTitle(
                            LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "提交"));
                } else {
                    customUiBotAction = pcUiBotLayout.getActions().get(0);
                }

                BottomButtonList bottomButtonList = new BottomButtonList();
                JSONArray bottomButtonDataArray =
                        (JSONArray) JSON.toJSON(pageData.get(bizDataSchema));
                for (int j = 0; j < bottomButtonDataArray.size(); j++) {
                    JSONObject bottomButtonJsonObj = bottomButtonDataArray.getJSONObject(j);
                    String id = bottomButtonJsonObj.getString("id");
                    BottomButtonDigiwinAthena bottomButton;
                    if ("submit".equalsIgnoreCase(id)) {
                        // 提交按钮
                        // action获取
                        JSONObject buttonActionJsonObj =
                                bottomButtonJsonObj.getJSONObject("action");
                        Integer buttonType = buttonActionJsonObj.getInteger("type");
                        Boolean screenShotSwitch =
                                buttonActionJsonObj.getBoolean("screenShotSwitch");
                        String screenShotSchema = buttonActionJsonObj.getString("screenShotSchema");

                        Action action = new Action();
                        action.setType(buttonType);
                        action.setScreenShotSwitch(screenShotSwitch);
                        action.setScreenShotSchema(screenShotSchema);

                        bottomButton =
                                BottomButtonDigiwinAthena.create(customUiBotAction, schema, bizData,
                                        null, action);
                        bottomButtonList.add(bottomButton);
                    }
                }
                taskDetailCustom.put(bizDataSchema, bottomButtonList);
            } else if (type.equals(InputHidden.COMPONENT_TYPE)) {
                taskDetailCustom.put(bizDataSchema, InputHidden.create(
                        LocaleUtil.getMobileTextByKey(apiRequest.getLocale(),
                                "该截图由页面提交时系统自动生成，截图排版与提交页面有少量差异。页面提交时间：")));
            } else {

            }

        }

        // 找到了动态创建layout的位置，替换为实际组件的layout
        if (dynamicCreateLayoutIdx > -1) {
            pageSettingModel.getLayout()
                    .addAll(dynamicCreateLayoutIdx + 1, dynamicCreateLayoutList);
            pageSettingModel.getLayout().remove(dynamicCreateLayoutIdx);
        }
    }

    /**
     * 考勤结果首次检查日期更新，调用ATDM的API
     *
     * @param apiRequest
     * @param schema
     * @param pcUiBotLayout
     * @param bizData
     */
    private void firstCheckDateUpdate(ApiRequest apiRequest, String schema,
                                      UiBotLayout pcUiBotLayout, List<Map<String, Object>> bizData) {
        UiBotAction action = pcUiBotLayout.getActions().get(0);

        JSONObject parameter = new JSONObject();
        for (int i = 0; i < bizData.size(); i++) {
            Map<String, Object> bizDataItem = bizData.get(i);
            JSONObject itemJsonObj = new JSONObject();
            itemJsonObj.put("attendance_result_group_id",
                    bizDataItem.getOrDefault("attendance_result_group_id", ""));
            itemJsonObj.put("employee_no", bizDataItem.getOrDefault("employee_no", ""));

            parameter.put(schema, itemJsonObj);
            if (!parameter.isEmpty()) {
                break;
            }
        }

        DigiwinAtdmRequest request =
                DigiwinAtdmRequest.create("attendance.result.first.check.date.update",
                        parameter,
                        (Map<String, Object>) action.get("executeContext"),
                        (Map<String, Object>) action.get("businessUnit")
                );

        this.digiwinAtdmProxyService.dataQueryByActionId(apiRequest.getLocale(),
                apiRequest.getIamUserToken(), JsonUtil.javaObjectToJsonString(request), apiRequest.getTenantId());
    }
}
