package com.digiwin.mobile.mobileuibot.task.strategy.custom.ssc;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildBizReportStrategy;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildStrategy;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * <p>功能描述：SSC应用员工入职任务详情</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskDetailBuildSscEmployeeInductionStrategy
 * @Author: Zaregoto
 * @Date: 2021/7/27 18:07
 */
@Slf4j
@Component("taskDetailBuildSscEmployeeInductionStrategy")
public class TaskDetailBuildSscEmployeeInductionStrategy implements TaskDetailBuildStrategy {

    @Autowired
    private TaskDetailBuildBizReportStrategy taskDetailBuildBizReportStrategy;

    @Override
    public String getTaskDetailType() {
        return TaskStringUtil.CUSTOM_PROJECT_CODE_EMPLOYEE_INDUCTION +
                TaskStringUtil.LINK_SYMBOL +
                TaskStringUtil.CUSTOM_TASK_CODE_EMPLOYEE_INDUCTION;
    }

    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;

    @Override
    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                                      Object... args) {
        TaskDetail taskDetail = this.build(apiRequest, pageSetting, pcUiBotModel, args);
        return uiBotModelBuildService.buildModel(pageSetting, taskDetail, true);
    }

    @Override
    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                            Object... args) {
        return this.taskDetailBuildBizReportStrategy.build(apiRequest, pageSetting, pcUiBotModel, args);
    }
}
