package com.digiwin.mobile.mobileuibot.task.strategy.custom.tbds;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumericTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRule;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author wuyang
 * @desc tbds-试验报告记录修改物料参数
 */
@Component("taskDetailBuildTbdsProductionProcessRecordModifyMaterialStrategy")
public class TaskDetailBuildTbdsProductionProcessRecordModifyMaterialStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(TaskDetailBuildTbdsProductionProcessRecordModifyMaterialStrategy.class);

    @Autowired
    private LocaleService localeService;


    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) {
        StopWatch stopWatch = new StopWatch("Build Tbds production progress record modify material");
        AppRequestContext.getContextEntity().setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        Map<String, Object> rawData = apiRequest.getRawData();
        Map<String, Object> data = (Map<String, Object>) rawData.get("data");
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case InputNumeric.COMPONENT_TYPE:
                    // 总用量限制小数点后两位
                    if ("total_qty".equalsIgnoreCase(schema)) {
                        Object totalQty = null;
                        if (data.get(schema) instanceof Integer) {
                            totalQty = Integer.parseInt(String.valueOf(MapUtil.getOrDefault(data, schema, 0)));
                        }
                        if (data.get(schema) instanceof Double) {
                            totalQty = MapUtil.getOrDefault(data, schema, 0.0);
                        }
                        String totalQtyStr = ModuleUtils.dealValue(totalQty, locale, localeService);
                        InputNumeric inputNumeric = InputNumeric.create(99999999, 2,
                                totalQtyStr, localeService.getLanguageValue(locale, layout.getLabel()), InputNumericTypeEnum.INTEGER.getValue(), true, "");
                        // 总用量禁用和去除必填
                        inputNumeric.setRequired(false);
                        inputNumeric.setEnable(false);
                        pageData.put(schema, inputNumeric);
                    }
                    // 组成用量限制小数点后六位
                    if ("component_qty".equalsIgnoreCase(schema)) {
                        Object componentQty = null;
                        if (data.get(schema) instanceof Integer) {
                            componentQty = Integer.parseInt(String.valueOf(MapUtil.getOrDefault(data, schema, 0)));
                        }
                        if (data.get(schema) instanceof Double) {
                            componentQty = MapUtil.getOrDefault(data, schema, 0.0);
                        }

                        String componentQtyStr = ModuleUtils.dealValue(componentQty, locale, localeService);
                        pageData.put(schema, InputNumeric.create(99999999, 6,
                                componentQtyStr, localeService.getLanguageValue(locale, layout.getLabel()), InputNumericTypeEnum.INTEGER.getValue(), true, ""));
                    }
                    break;
                case InputWindowSingleSelect.COMPONENT_TYPE:
                    Map<String, Object> selectRawData = new HashMap<>(2);
                    selectRawData.put("isTbds", true);
                    selectRawData.put("type", layout.getSchema());
                    pageData.put(schema, InputWindowSingleSelect.create(
                            localeService.getLanguageValue(locale, layout.getLabel()), schema,
                            AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list", locale,
                            selectRawData, (String) data.get("unit_no"), (String) data.get(schema), new RelationRule(), new HashMap<>(0)));
                    break;
                case InputMultiText.COMPONENT_TYPE:
                    // 批号
                    String lotNo = (String) MapUtil.getOrDefault(data, "lot_no", "");
                    InputMultiText inputMultiText = InputMultiText.create(layout.getSchema(), localeService.getLanguageValue(locale,
                                    layout.getLabel()), lotNo, true, false, false, locale,
                            100);
                    pageData.put(schema, inputMultiText);
                    break;
                case CustomGroup.COMPONENT_TYPE:
                    CustomGroup customGroup = JsonUtil.objectToJavaObject(pageData.get(schema), CustomGroup.class);
                    customGroup.setName(localeService.getLanguageValue(locale, customGroup.getName()));
                    List<Map<String, Object>> parameterDatas = (List<Map<String, Object>>) data.get(schema);
                    if (CollectionUtils.isEmpty(parameterDatas)) {
                        // 编辑参数没值就不显示
                        pageData.remove(schema);
                        continue;
                    }
                    pageData.put(schema, customGroup.buildTbdsParams(customGroup, parameterDatas, locale));
                    break;
                case Card.COMPONENT_TYPE:
                    Card card = JsonUtil.objectToJavaObject(pageData.get(schema), Card.class);
                    if ("trial_op_report_item".equalsIgnoreCase(schema)) {
                        Card.create(card, data, locale, localeService, true);
                    }
                    pageData.put(schema, card);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    BottomButtonList bottomButtonList = JsonUtil.objectToJavaObject(
                            pageSetting.getPageModel().getPageData().get(layout.getSchema()),
                            BottomButtonList.class);
                    bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                        String buttonName = bottomButtonDigiwinAthena.getName();
                        if (StringUtils.hasLength(buttonName)) {
                            bottomButtonDigiwinAthena.setName(localeService.getLanguageValue(locale, buttonName));
                        }
                        if (bottomButtonDigiwinAthena.getIsCheckButton()) {
                            Action action = bottomButtonDigiwinAthena.getAction();
                            rawData.put("biz_id", "TBDS");
                            rawData.put("pageId", apiRequest.getPageId());
                            rawData.put("refreshPageId", apiRequest.getRefreshPageId());
                            action.setRawData(rawData);
                        }
                    });
                    pageData.put(schema, bottomButtonList);
                    break;
                default:
                    break;
            }
        }
        uiBotModel.setCustomGroup();
        return uiBotModel;
    }


    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }


}
