package com.digiwin.mobile.mobileuibot.task.strategy.custom.tbds;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentRawDataDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.picture.Picture;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.dmc.config.DigiwinDmcConfig;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.search.SearchItemDetailStyleEnum;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author xujinc
 * @desc 北斗报工详情
 */
@Component("taskDetailBuildTbdsProductionProgressReportDetailStrategy")
public class TaskDetailBuildTbdsProductionProgressReportDetailStrategy implements UiBotModelBuildStrategy {
    private static final Logger logger =
            LoggerFactory.getLogger(TaskDetailBuildTbdsProductionProcessRecordModifyMaterialStrategy.class);

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build Tbds Production Progress Report Detail");
        AppRequestContext.getContextEntity().setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();

        ApiRawData apiRawData = apiRequest.getRawData();
        Map<String, Object> processData = (Map<String, Object>) apiRawData.get("data");
        // 有返工标识
        Boolean reworkTimes = (Integer) MapUtil.getOrDefault(processData, "rework_times", 0) > 0;
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case Field.COMPONENT_TYPE:
                    // 返工操作和返工原因在驳回情况下才展示
                    if (!reworkTimes && ("rework_operation".equalsIgnoreCase(schema) || "rework_reason".equalsIgnoreCase(schema))) {
                        continue;
                    }
                    String name = localeService.getLanguageValue(locale, layout.getLabel());
                    String data = String.valueOf(MapUtil.getOrDefault(processData, schema, StringUtils.EMPTY));
                    Field field = Field.createLabelLeftValueRightField(name, data);
                    pageData.put(schema, field);
                    break;
                case Picture.COMPONENT_TYPE:
                    Picture picture = new Picture();
                    Object picturePageData = null;
                    //工艺图片/视频
                    if ("resource_data".equalsIgnoreCase(schema)) {
                        if (Objects.isNull(processData.get("resource_data"))) {
                            continue;
                        }
                        List<Map<String, Object>> resourceDataList = (List<Map<String, Object>>) processData.get("resource_data");
                        // resource_base 0:工艺信息，1：报工信息
                        resourceDataList = resourceDataList.stream().filter(e -> "1".equals(e.get("resource_base"))).collect(Collectors.toList());
                        if (!CollectionUtils.isEmpty(resourceDataList)) {
                            Attachment attachment = Attachment.createTbdsFiles(resourceDataList, localeService.getLanguageValue(locale, layout.getLabel()));
                            attachment.setStyleType(AttachmentStyleTypeEnum.TITLE_WEAKENED.getValue());
                            attachment.setTitleStyleType(SearchItemDetailStyleEnum.TITLE_STYLE_TYPE_ONE.getValue());
                            BeanUtils.copyProperties(attachment, picture);
                            AttachmentRawDataDigiwinAthena pictureRawData = new AttachmentRawDataDigiwinAthena();
                            pictureRawData.setBuckets(DigiwinDmcConfig.TBDS_BUCKET);
                            picture.setRawData(pictureRawData);

                            picturePageData = picture;
                        } else {
                            layout.setType(Field.COMPONENT_TYPE);
                            picturePageData = Field.createLabelLeftValueRightField(localeService.getLanguageValue(locale, layout.getLabel()), StringUtils.EMPTY);
                        }
                    }
                    pageData.put(schema, picturePageData);
                    break;
                case Attachment.COMPONENT_TYPE:
                    Object attachmentPageData = null;
                    List<Map<String, Object>> documentInfoList = (List<Map<String, Object>>) MapUtil.getOrDefault(processData, "document_info", Collections.emptyList());
                    List<Map<String, Object>> attachmentData =
                            Optional
                                    .ofNullable(documentInfoList)
                                    .map(filesList ->
                                            filesList.stream()
                                                    .map(file -> Optional
                                                            .ofNullable((Map<String, Object>) file.get("attachment"))
                                                            .orElse(new HashMap<>()))
                                                    .map(attachmentInfo -> Optional
                                                            .ofNullable((List<Map<String, Object>>) attachmentInfo.get("data"))
                                                            .orElse(new ArrayList<>()))
                                                    .flatMap(Collection::stream)
                                                    .collect(Collectors.toList()))
                                    .orElse(new ArrayList<>());

                    // 历史附件
                    if ("historical_attachments".equalsIgnoreCase(schema)) {
                        List<Map<String, Object>> documentInfos = attachmentData.stream().filter(e -> DigiwinDmcConfig.TBDS_BUCKET.equals(e.get("category"))).collect(Collectors.toList());
                        if (!CollectionUtils.isEmpty(documentInfos)) {
                            attachmentPageData = Attachment.createTbdsFiles(documentInfos,
                                    AttachmentTypeEnum.READ_ONLY.getValue(),
                                    localeService.getLanguageValue(locale, layout.getLabel()), AttachmentStyleTypeEnum.TITLE_WEAKENED.getValue(), DigiwinDmcConfig.TBDS_BUCKET, SearchItemDetailStyleEnum.TITLE_STYLE_TYPE_ONE.getValue());
                        }
                    }

                    //附件
                    if ("attachments".equalsIgnoreCase(schema)) {
                        List<Map<String, Object>> documentInfos = attachmentData.stream().filter(e -> DigiwinDmcConfig.CTP_BUCKET.equals(e.get("category"))).collect(Collectors.toList());
                        if (!CollectionUtils.isEmpty(documentInfos)) {
                            attachmentPageData = Attachment.createTbdsFiles(documentInfos,
                                    AttachmentTypeEnum.READ_ONLY.getValue(),
                                    localeService.getLanguageValue(locale, layout.getLabel()), AttachmentStyleTypeEnum.TITLE_WEAKENED.getValue(), DigiwinDmcConfig.CTP_BUCKET, SearchItemDetailStyleEnum.TITLE_STYLE_TYPE_ONE.getValue());
                        } else {
                            layout.setType(Field.COMPONENT_TYPE);
                            attachmentPageData = Field.createLabelLeftValueRightField(localeService.getLanguageValue(locale, layout.getLabel()), StringUtils.EMPTY);
                        }
                    }
                    pageData.put(schema, attachmentPageData);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    List<BottomButtonDigiwinAthena> buttonList = new ArrayList<>(1);
                    BottomButtonDigiwinAthena cancelButton = BottomButtonDigiwinAthena.createNormalCancelButton(locale);
                    buttonList.add(cancelButton);
                    pageData.put(schema, buttonList);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
