package com.digiwin.mobile.mobileuibot.task.strategy.custom.tbds;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.component.breadcrumb.BreadCrumb;
import com.digiwin.mobile.mobileuibot.core.component.breadcrumb.BreadCrumbNode;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.processnode.ProcessNode;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.DigiwinAtdmRequest;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

import java.util.*;

/**
 * @author wuyang
 * @desc tbds-试验报告记录
 */
@Component("uiBotModelBuildTbdsProductionProgressRecordNextStepStrategy")
public class UiBotModelBuildTbdsProductionProgressRecordNextStepStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildTbdsProductionProgressRecordNextStepStrategy.class);

    @Autowired
    private LocaleService localeService;

    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;


    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) {
        StopWatch stopWatch = new StopWatch("Build Tbds production progress report");
        AppRequestContext.getContextEntity().setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        Map<String, Object> rawData = apiRequest.getRawData();
        BreadCrumb parentBreadCrumb = null;
        Boolean hasButton = true;
        Boolean isSubmit = false;
        if (rawData.get("isSubmit") != null) {
            isSubmit = (Boolean) rawData.get("isSubmit");
        }
        Boolean isRecipe = (Boolean) rawData.get("is_recipe");
        int processNo = 0;
        String reportNo = (String) rawData.get("report_no");
        if (rawData.get("hasButton") != null) {
            hasButton = (Boolean) rawData.get("hasButton");
        }
        if (!StringUtils.hasLength(reportNo) && hasButton) {
            return UiBotModel.emptyUibotModel(locale);
        }
        if (rawData.get("nodeNo") != null) {
            processNo = (int) rawData.get("nodeNo");
        }
        int crumbLength = 1;
        if (rawData.get("crumbLength") != null) {
            crumbLength = (int) rawData.get("crumbLength");
        } else {
            if (apiRequest.getCrumbLength() != null) {
                crumbLength = apiRequest.getCrumbLength();
            }
        }
        String breadName = (String) rawData.get("breadName");
        Map<String, Object> newParameter = (Map<String, Object>) rawData.get("newParameter");
        Map<String, Object> executeContext = (Map<String, Object>) rawData.get("executeContext");
        Map<String, Object> businessUnit = new HashMap<>();
        if (!CollectionUtils.isEmpty(executeContext)) {
            businessUnit = (Map<String, Object>) executeContext.get("businessUnit");
        }
        if (crumbLength > 0 && rawData.get("currentCrumb") != null) {
            parentBreadCrumb =
                    JsonUtil.objectToJavaObject(rawData.get("currentCrumb"), BreadCrumb.class);
            Map<String, Object> parentRawData = parentBreadCrumb.getData().get(crumbLength - 1).getRawData();
            String title = parentBreadCrumb.getData().get(crumbLength - 1).getTitle();
            if (parentRawData.get("breadName") == null && parentRawData.get("currentCrumb") != null) {
                parentBreadCrumb =
                        JsonUtil.objectToJavaObject(parentRawData.get("currentCrumb"), BreadCrumb.class);
                parentRawData = parentBreadCrumb.getData().get(crumbLength - 1).getRawData();
            }
            if (rawData.get("is_recipe") == null && parentRawData.get("is_recipe") != null) {
                isRecipe = (Boolean) parentRawData.get("is_recipe");
            }
            if (isSubmit && StringUtils.hasLength(title)) {
                breadName = title;
            }
            if (rawData.get("newParameter") == null) {
                newParameter = (Map<String, Object>) parentRawData.get("newParameter");
                if (rawData.get("currentNewParameter_" + crumbLength) != null) {
                    newParameter = (Map<String, Object>) rawData.get("currentNewParameter_" + crumbLength);
                } else {
                    Map<String, Object> findNew = parentBreadCrumb.searchCurrentNewParameter(parentBreadCrumb, crumbLength, newParameter);
                    if (!CollectionUtils.isEmpty(findNew)) {
                        newParameter = findNew;
                    }
                }

            }
            for (int i = crumbLength - 1; i < parentBreadCrumb.getData().size(); i++) {
                parentBreadCrumb.getData().remove(i);
            }
            if (rawData.get("executeContext") == null) {
                executeContext = (Map<String, Object>) parentRawData.get("executeContext");
            }
            businessUnit = (Map<String, Object>) executeContext.get("businessUnit");

        }
        String currentSeq = (String) ((List<Map<String, Object>>) newParameter.get("query_info")).get(0).get("parent_seq");
        if (io.micrometer.core.instrument.util.StringUtils.isEmpty(currentSeq)) {
            currentSeq = (String) ((List<Map<String, Object>>) newParameter.get("query_info")).get(0).get("parent_seq");
        } else {
            ((List<Map<String, Object>>) newParameter.get("query_info")).get(0).put("parent_seq", currentSeq);
        }
        DigiwinAtdmRequest request = DigiwinAtdmRequest.create("bm.opsc.trial.production.complete.get",
                newParameter, executeContext, businessUnit);

        List<Map<String, Object>> opDatas = digiwinAtdmProxyService.tbdsDataQueryByActionId(locale, iamUserToken,
                JsonUtil.javaObjectToJsonString(request), tenantId);
        if (CollectionUtils.isEmpty(opDatas) && (rawData.get("currentCrumb") == null || parentBreadCrumb == null || CollectionUtils.isEmpty(parentBreadCrumb.getData())) && !CollectionUtils.isEmpty((Collection<?>) rawData.get("rawDataList"))) {
            opDatas = (List<Map<String, Object>>) rawData.get("rawDataList");
        }
        if (CollectionUtils.isEmpty(opDatas)) {
            return UiBotModel.emptyImageUibotModel(locale, "暂无数据", 80, 74, "IMAGE_EMPTY_WIDGET");
        }
        Map<String, Object> opData = opDatas.get(0);
        List<UiBotLayout> newUibotlayouts = new ArrayList<>(3);
        Map<String, Object> commonRawData = uiBotModel.getCommonRawData();
        rawData.put("pageId", apiRequest.getPageId());
        if (isRecipe == null) {
            if (rawData.get("breadRecipt") != null) {
                isRecipe = (Boolean) rawData.get("breadRecipt");
            } else {
                if (breadName.contains(localeService.getLanguageValue(locale, "材料"))) {
                    isRecipe = false;
                } else {
                    isRecipe = true;
                }
            }
        }
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case ProcessNode.COMPONENT_TYPE:
                    if (isRecipe) {
                        newUibotlayouts.add(layout);
                        ProcessNode processNode = JsonUtil.objectToJavaObject(pageData.get(schema), ProcessNode.class);
                        pageData.put(schema, ProcessNode.create(uiBotModel, processNode, opDatas,
                                localeService, locale, digiwinAtdmProxyService,
                                apiRequest, hasButton, processNo, digiwinEspProxyService, reportNo));
                    }
                    break;
                case BreadCrumb.COMPONENT_TYPE:
                    newUibotlayouts.add(layout);
                    rawData.remove("currentCrumb");
                    BreadCrumb breadCrumb = new BreadCrumb();
                    if (parentBreadCrumb != null && !CollectionUtils.isEmpty(parentBreadCrumb.getData())) {
                        breadCrumb.getData().addAll(parentBreadCrumb.getData());
                    }
                    rawData.put("currentSeq", currentSeq);
                    rawData.put("is_recipe", isRecipe);
                    if (!rawData.containsKey("newParameter")) {
                        rawData.put("newParameter", newParameter);
                    }
                    breadCrumb.getData().add(new BreadCrumbNode(breadName,
                            rawData, "", "/mobile/v1/proxy/get/breadCrumb/data"));
                    uiBotModel.getCommonRawData().put("currentCrumb", breadCrumb);
                    pageData.put(schema, breadCrumb);
                    break;
                case CustomGroup.COMPONENT_TYPE:
                    if (!isRecipe) {
                        newUibotlayouts.add(layout);
                        CustomGroup customGroup = JsonUtil.objectToJavaObject(pageData.get(schema), CustomGroup.class);
                        customGroup.setStyleType(CustomGroupStyleTypeEnum.TEXT_OUTSIDE_THE_TITLE_GROUP.getValue());
                        customGroup.setName(localeService.getLanguageValue(locale, customGroup.getName()));
                        List<Map<String, Object>> itemList = (List<Map<String, Object>>) opData.get(schema);
                        uiBotModel.buildCommonRawData(commonRawData, opData, uiBotModel);
                        commonRawData.put("trial_op_report_item_list", itemList);
                        customGroup.buildTbdsItemList(customGroup, locale, localeService, itemList, rawData,
                                digiwinAtdmProxyService, apiRequest, hasButton,
                                false, false);
                        pageData.put(schema, customGroup);
                    }
                    break;
                default:
                    break;
            }
        }
        uiBotModel.setLayout(newUibotlayouts);
        uiBotModel.getCommonRawData().put("hasButton", hasButton);
        if (rawData.get("report_no") != null) {
            uiBotModel.getCommonRawData().put("report_no", rawData.get("report_no"));
            uiBotModel.getCommonRawData().put("executeContext", executeContext);
            uiBotModel.getCommonRawData().put("currentNewParameter_" + crumbLength, newParameter);
        }
        return uiBotModel;
    }


    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }

}
