package com.digiwin.mobile.mobileuibot.task.strategy.custom.tbds;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.InputWindowSelectStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.multi.InputWindowMultiSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.rule.JsRule;
import com.digiwin.mobile.mobileuibot.core.rule.JsRuleService;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author wuyang
 * @desc tbds-试验报告记录驳回
 */
@Component("uiBotModelBuildTbdsProductionProgressRecordRejectSubmitStrategy")
public class UiBotModelBuildTbdsProductionProgressRecordRejectSubmitStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildTbdsProductionProgressRecordRejectSubmitStrategy.class);

    @Autowired
    private LocaleService localeService;

    @Autowired
    private JsRuleService jsRuleService;


    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) {
        StopWatch stopWatch = new StopWatch("Build Tbds production progress report reject submit");
        AppRequestContext.getContextEntity().setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        // v2规则目前无法从km获取，先从mongodb获取
        List<JsRule> jsRuleList = jsRuleService.findByPageId(pageSetting.getPageId());
        if (!CollectionUtils.isEmpty(jsRuleList)) {
            List<UiBotRule> uiBotRuleList = new ArrayList<>(1);
            jsRuleList.forEach(jsRule -> {
                UiBotRule uiBotRule = new UiBotRule();
                BeanUtils.copyProperties(jsRule, uiBotRule);
                uiBotRuleList.add(uiBotRule);
            });
            if(uiBotModel != null){
                uiBotModel.setRules(uiBotRuleList);
            }
        }
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        Map<String, Object> rawData = apiRequest.getRawData();

        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case InputWindowSingleSelect.COMPONENT_TYPE:
                    if ("reject_to_op_seq".equals(schema)) {
                        Map<String, Object> mobileOpDatas = new HashMap<>(2);
                        mobileOpDatas.put("type", schema);
                        mobileOpDatas.put("isTbds", true);
                        mobileOpDatas.put("mobileOpDatas", rawData.get("mobileOpDatas"));
                        pageData.put(schema, InputWindowSingleSelect.create(
                                layout,
                                AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list",
                                locale,
                                mobileOpDatas, localeService, "", true, true));
                    }
                    break;
                case InputWindowMultiSelect.COMPONENT_TYPE:
                    Map<String, Object> mobileOpDatas = new HashMap<>(1);
                    mobileOpDatas.put("type", schema);
                    mobileOpDatas.put("isTbds", true);
                    mobileOpDatas.put("mobileOpDatas", rawData.get("mobileOpDatas"));

                    InputWindowMultiSelect inputWindowMultiSelect = InputWindowMultiSelect.create(layout,
                            AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list",
                            mobileOpDatas, locale, 1, InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue(),
                            true, true, localeService);
                    pageData.put(schema, inputWindowMultiSelect);
                    break;
                case InputMultiText.COMPONENT_TYPE:
                    pageData.put(schema, InputMultiText.create(schema, localeService.getLanguageValue(locale,
                            layout.getLabel()), "", true, false, true, locale,
                            100));
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    BottomButtonList bottomButtonList = JsonUtil.objectToJavaObject(
                            pageSetting.getPageModel().getPageData().get(layout.getSchema()),
                            BottomButtonList.class);
                    bottomButtonList.forEach(button -> {
                        button.setName(localeService.getLanguageValue(locale, button.getName()));
                        if (button.getIsCheckButton()) {
                            Action action = button.getAction();
                            rawData.put("pageId", apiRequest.getPageId());
                            rawData.put("biz_id", "TBDS");
                            action.setRawData(rawData);
                        }
                    });
                    pageData.put(schema, bottomButtonList);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }


    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }

}
