package com.digiwin.mobile.mobileuibot.task.strategy.custom.tbds;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldLabelStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldValueStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.*;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePicker;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePickerTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumericTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.picture.Picture;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.rule.JsRule;
import com.digiwin.mobile.mobileuibot.core.rule.JsRuleService;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRule;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.dmc.config.DigiwinDmcConfig;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserInfo;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.search.SearchItemDetailStyleEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author wuyang
 * @desc tbds-试验报告记录报工
 */
@Component("uiBotModelBuildTbdsProductionProgressRecordReportSubmitStrategy")
public class UiBotModelBuildTbdsProductionProgressRecordReportSubmitStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildTbdsProductionProgressRecordReportSubmitStrategy.class);

    @Autowired
    private LocaleService localeService;

    @Autowired
    private DigiwinIamProxyService digiwinIamProxyService;

    @Autowired
    private JsRuleService jsRuleService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) {
        StopWatch stopWatch = new StopWatch("Build Tbds production progress recode report submit");
        AppRequestContext.getContextEntity().setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        Map<String, Object> rawData = apiRequest.getRawData();
        rawData.put("pageId", PageSettingIdPresetEnum.MOBILE_ATHENA_TBDS_PRODUCTION_PROCESS_RECORD_REPORT_SUBMIT);
        Map<String, Object> opData = (Map<String, Object>) rawData.get("data");
        uiBotModel.setShowMore(true);
        /**
         * 强制报工标识
         */
        Boolean isForceReport = ModuleUtils.YES.equals((String) opData.get("is_force_report"));
        /**
         * 有返工标识
         */
        Boolean reworkTimes = (Integer) opData.get("rework_times") > 0;
        List<UiBotLayout> newUibotLayouts = new ArrayList<>(10);
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case Field.COMPONENT_TYPE:
                    newUibotLayouts.add(layout);
                    String userName;
                    if (StringUtils.hasLength((String) opData.get(schema))) {
                        userName = (String) opData.get(schema);
                    } else {
                        DigiwinIamUserInfo userInfo = digiwinIamProxyService.userInfoById(apiRequest.getUserId(),
                                apiRequest.getIamUserToken(), apiRequest.getLocale());
                        if (userInfo != null) {
                            userName = userInfo.getName();
                        } else {
                            userName = "-";
                        }
                    }
                    pageData.put(schema, Field.create(
                            localeService.getLanguageValue(locale, layout.getLabel()),
                            FieldLabelStyleTypeEnum.LABEL_GREY.getValue(),
                            FieldValueStyleTypeEnum.VALUE_BLACK.getValue(),
                            userName));
                    break;
                case InputDateTimePicker.COMPONENT_TYPE:
                    newUibotLayouts.add(layout);
                    String bizData;
                    if ("actual_start_time".equals(schema)) {
                        bizData = opData.get("plan_start_date") + " 00:00";
                    } else {
                        bizData = opData.get("plan_end_date") + " 00:00";
                    }
                    InputDateTimePicker picker = InputDateTimePicker.create(schema,
                            localeService.getLanguageValue(locale, layout.getLabel()), bizData, locale,
                            InputDateTimePickerTypeEnum.YEAR_MONTH_DATE_HOUR_MINUTE.getType(),
                            "actual_start_time", "actual_end_time");
                    if ("actual_start_time".equals(schema) || "actual_end_time".equals(schema)) {
                        //开始日期有变化则需要置空实际结束日期addOperator
                        RelationRule.buildTbdsRule(picker.getRelationRule().getRuleList());
                    }
                    pageData.put(schema, picker);
                    break;
                case InputNumeric.COMPONENT_TYPE:
                    newUibotLayouts.add(layout);
                    String data = String.valueOf(MapUtil.getOrDefault(opData, schema, 0));
                    if ("actual_work_hours".equalsIgnoreCase(schema)) {
                        pageData.put(schema, InputNumeric.create(11, 1,
                                data, localeService.getLanguageValue(locale, layout.getLabel()),
                                InputNumericTypeEnum.INTEGERWITHUNIT.getValue(), true,
                                localeService.getLanguageValue(locale, "小时")));
                    } else {
                        pageData.put(schema, InputNumeric.create(25, 6,
                                data, localeService.getLanguageValue(locale, layout.getLabel()),
                                InputNumericTypeEnum.INTEGERWITHUNIT.getValue(), false, ""));
                    }
                    break;
                case InputWindowSingleSelect.COMPONENT_TYPE:
                    Map<String, Object> selectRawData = new HashMap<>(2);
                    selectRawData.put("isTbds", true);
                    selectRawData.put("type", schema);

                    String defaultSelectId = (String) MapUtil.getOrDefault(opData, schema, "");
                    String defaultSelectVal = "";
                    if ("qualified_product_unit_no".equalsIgnoreCase(schema)) {
                        defaultSelectVal = (String) MapUtil.getOrDefault(opData, "qualified_product_unit_name", "");
                    } else if ("unqualified_product_unit_no".equalsIgnoreCase(schema)) {
                        defaultSelectVal = (String) MapUtil.getOrDefault(opData, "unqualified_product_unit_name", "");
                    }
                    InputWindowSingleSelect inputWindowSingleSelect = InputWindowSingleSelect.create(
                            localeService.getLanguageValue(locale, layout.getLabel()), schema,
                            AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list", locale,
                            selectRawData, defaultSelectId, defaultSelectVal, new RelationRule(), new HashMap<>(0));
                    inputWindowSingleSelect.setRequired(false);
                    pageData.put(schema, inputWindowSingleSelect);
                    break;
                case Picture.COMPONENT_TYPE:
                    newUibotLayouts.add(layout);
                    Picture picture = new Picture();
                    List<Map<String, Object>> pictureFiles = (List<Map<String, Object>>) opData.get("resource_data");
                    List<Map<String, Object>> newFiles = new ArrayList<>(3);
                    if (!CollectionUtils.isEmpty(pictureFiles)) {
                        pictureFiles.forEach(file -> {
                            if ("1".equals(file.get("resource_base"))) {
                                newFiles.add(file);
                            }
                        });
                    }
                    Attachment fileAttachment = Attachment.createTbdsFiles(newFiles, localeService.getLanguageValue(locale, layout.getLabel()));
                    BeanUtils.copyProperties(fileAttachment, picture);
                    if (isForceReport || reworkTimes) {
                        picture.setRequired(true);
                    } else {
                        picture.setRequired(false);
                    }
                    picture.setFileMaxSize(new FileMaxSize(1024 * 1024 * 10L, 1024 * 1024 * 200L));
                    picture.setLimit(9);
                    picture.setSupportImageAndVideoType();
                    picture.setType(2);
                    AttachmentRawDataDigiwinAthena pictureRawData = new AttachmentRawDataDigiwinAthena();
                    pictureRawData.setBuckets(DigiwinDmcConfig.TBDS_BUCKET);
                    pictureRawData.setDisableAam(true);
                    picture.setRawData(pictureRawData);
                    pageData.put(schema, picture);
                    break;
                case Attachment.COMPONENT_TYPE:
                    newUibotLayouts.add(layout);
                    Attachment attachment = new Attachment();
                    List<Map<String, Object>> files = (List<Map<String, Object>>) opData.get("document_info");
                    List<Map<String, Object>> attachmentData =
                            Optional
                                    .ofNullable(files)
                                    .map(filesList ->
                                            filesList.stream()
                                                    .map(file -> Optional
                                                            .ofNullable((Map<String, Object>) file.get("attachment"))
                                                            .orElse(new HashMap<>()))
                                                    .map(attachmentInfo -> Optional
                                                            .ofNullable((List<Map<String, Object>>) attachmentInfo.get("data"))
                                                            .orElse(new ArrayList<>()))
                                                    .flatMap(Collection::stream)
                                                    .collect(Collectors.toList()))
                                    .orElse(new ArrayList<>());
                    //历史附件 历史附件的bucket为tbds，历史附件没有的话，栏位不展示
                    if ("historical_attachments".equalsIgnoreCase(schema)) {
                        List<Map<String, Object>> documentInfos = attachmentData.stream().filter(e -> DigiwinDmcConfig.TBDS_BUCKET.equals(e.get("category"))).collect(Collectors.toList());
                        if (CollectionUtils.isEmpty(documentInfos)) {
                            continue;
                        }
                        attachment = Attachment.createTbdsFiles(
                                documentInfos,
                                AttachmentTypeEnum.READ_AND_WRITE.getValue(),
                                localeService.getLanguageValue(locale, layout.getLabel()), AttachmentStyleTypeEnum.TITLE_NORMAL.getValue(), DigiwinDmcConfig.TBDS_BUCKET, SearchItemDetailStyleEnum.TITLE_STYLE_TYPE_THREE.getValue());
                        attachment.setLimit(0);
                    }

                    //附件 附件的bucket为CTP
                    if ("attachments".equalsIgnoreCase(schema)) {
                        List<Map<String, Object>> documentInfos = attachmentData.stream().filter(e -> DigiwinDmcConfig.CTP_BUCKET.equals(e.get("category"))).collect(Collectors.toList());
                        attachment = Attachment.createTbdsFiles(
                                documentInfos,
                                AttachmentTypeEnum.READ_AND_WRITE.getValue(),
                                localeService.getLanguageValue(locale, layout.getLabel()), AttachmentStyleTypeEnum.TITLE_NORMAL.getValue(), DigiwinDmcConfig.CTP_BUCKET, SearchItemDetailStyleEnum.TITLE_STYLE_TYPE_THREE.getValue());
                        Long maxSize = 1024 * 1024 * 100L;
                        attachment.setFileMaxSize(new FileMaxSize(maxSize, maxSize, maxSize, maxSize));
                        attachment.setLimit(100);
                    }

                    attachment.setTitle(localeService.getLanguageValue(locale, layout.getLabel()));
                    attachment.setTitleStyleType(2);
                    attachment.setStyleType(AttachmentStyleTypeEnum.TITLE_NORMAL.getValue());
                    attachment.setType(AttachmentTypeEnum.READ_AND_WRITE.getValue());
                    attachment.setErrorMessage(localeService.getLanguageValue(locale, "上传失败"));
                    AttachmentRawDataDigiwinAthena attachmentRawData = new AttachmentRawDataDigiwinAthena();
                    attachmentRawData.setBuckets("attachments".equalsIgnoreCase(schema) ? DigiwinDmcConfig.CTP_BUCKET : DigiwinDmcConfig.TBDS_BUCKET);
                    attachment.setRawData(attachmentRawData);
                    pageData.put(schema, attachment);
                    break;
                case InputMultiText.COMPONENT_TYPE:
                    if ("problem_record".equals(schema)) {
                        newUibotLayouts.add(layout);
                        pageData.put(schema, InputMultiText.create(schema, localeService.getLanguageValue(locale,
                                        layout.getLabel()), (String) opData.get(schema), true, isForceReport || reworkTimes, false, locale,
                                100));
                    } else if ("rework_operation".equals(schema) && reworkTimes) {
                        newUibotLayouts.add(layout);
                        pageData.put(schema, InputMultiText.create(schema, localeService.getLanguageValue(locale,
                                        layout.getLabel()), (String) opData.get(schema), true, true, false, locale,
                                40));
                    } else if ("rework_reason".equals(schema) && reworkTimes) {
                        newUibotLayouts.add(layout);
                        pageData.put(schema, InputMultiText.create(schema, localeService.getLanguageValue(locale,
                                        layout.getLabel()), (String) opData.get(schema), true, true, false, locale,
                                40));
                    }
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    BottomButtonList bottomButtonList = JsonUtil.objectToJavaObject(
                            pageSetting.getPageModel().getPageData().get(layout.getSchema()),
                            BottomButtonList.class);
                    bottomButtonList.forEach(button -> {
                        button.setName(localeService.getLanguageValue(locale, button.getName()));
                        if (button.getIsCheckButton()) {
                            Action action = button.getAction();
                            action.setRefreshPageId(PageSettingIdPresetEnum.FLASH_MY_TODO.toString());
                            action.setRawData(rawData);
                        }
                    });
                    pageData.put(schema, bottomButtonList);
                    break;
                default:
                    break;
            }
        }
        uiBotModel.setCustomGroup();

        // v1转v2 h5 web端规则处理
        List<JsRule> jsRuleList = jsRuleService.findByPageId(pageSetting.getPageId());
        if (!CollectionUtils.isEmpty(jsRuleList)) {
            List<UiBotRule> uiBotRuleList = new ArrayList<>(2);
            jsRuleList.forEach(jsRule -> {
                UiBotRule uiBotRule = new UiBotRule();
                BeanUtils.copyProperties(jsRule, uiBotRule);
                uiBotRuleList.add(uiBotRule);
            });
            uiBotModel.setRules(uiBotRuleList);
        }
        return uiBotModel;
    }


    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }

}
