package com.digiwin.mobile.mobileuibot.task.strategy.custom.tbds;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.action.ConfirmPop;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.processnode.MobileProcess;
import com.digiwin.mobile.mobileuibot.core.component.processnode.ProcessNode;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTab;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabs;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.digiwin.mobile.mobileuibot.task.model.MobileProcessStatusEnum;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetail;
import com.digiwin.mobile.mobileuibot.task.model.TbdsOpStatusEnum;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildStrategy;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

/**
 * @author wuyang
 * @desc tbds-试验报告记录 op_show_status 未开始10 进行中20 已完成30
 */
@Component("uiBotModelBuildTbdsProductionProgressReportStrategy")
public class UiBotModelBuildTbdsProductionProgressReportStrategy implements TaskDetailBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildTbdsProductionProgressReportStrategy.class);

    private static final Integer FIRST_SORT_INDEX = 1;

    private static final String COMPLETE_STATUS = "30";

    private static final String IS_NOT_ASSOCIATE_PROJECT = "0";

    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;

    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;

    @Override
    public String getTaskDetailType() {
        return TaskStringUtil.CUSTOM_TASK_TYPE_PRODUCETION_PROGRESS_REPORT;
    }

    @Override
    public UiBotModel buildUibotModel(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object... args) {
        StopWatch stopWatch = new StopWatch("Build Tbds production progress report");
        AppRequestContext.getContextEntity().setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            DigiwinAtmcBacklogDetail backlogDetail = (DigiwinAtmcBacklogDetail) args[0];
            uiBotModel = this.doActually(pageSetting, apiRequest, pcUiBotModel, backlogDetail, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  UiBotModel pcUiBotModel, DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();

        // 用来匹配当前处理人，直接用apiRequest.getUserId()来匹配是不行的
        String eocId = digiwinEocProxyService.getEocId(apiRequest.getIamUserToken(), apiRequest.getUserId());
        String compareUserId = StringUtils.hasLength(eocId) ? eocId : apiRequest.getUserId();

        // 目前如果方案层下没有当前人可以处理的工艺，op_data不会展示该方案层信息，需要单独处理获取到
        List<Map<String, Object>> processList = getAllProcess(pcUiBotModel, apiRequest);

        Map<String, Object> currentOpData = this.getCurrentProcess(pcUiBotModel, processList, apiRequest, compareUserId);

        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case TitleBody.COMPONENT_TYPE:
                    //单头（任务名称、基础信息）
                    TitleBody titleBody = TitleBody.create(locale, digiwinAtmcBacklogDetail);
                    pageData.put(schema, titleBody);
                    break;
                case CustomTabs.COMPONENT_TYPE:
                    if (CollectionUtils.isEmpty(processList)) {
                        continue;
                    }

                    CustomTabs customTabs = JsonUtil.objectToJavaObject(pageData.get(schema), CustomTabs.class);
                    ProcessNode processNode = JsonUtil.objectToJavaObject(customTabs.get(0).getContent().get(0).getData(), ProcessNode.class);
                    customTabs.clear();

                    // 根据trial_wo_no 分组出方案层，value根据op_seq和sub_op_seq去重
                    Map<String, List<Map<String, Object>>> opDataMapByTrialWoNo = processList.stream().collect(Collectors.groupingBy(e -> (String) e.get("trial_wo_no"),
                            Collectors.collectingAndThen(
                                    Collectors.toCollection(() -> new TreeSet<>(
                                            Comparator.comparing(e -> e.get("op_seq") + "_" + e.get("sub_op_seq")))), ArrayList::new)
                    ));

                    // 方案层排序
                    Map<String, List<Map<String, Object>>> opDataMapBySortedTrialWoNo = opDataMapByTrialWoNo.entrySet().stream()
                            .sorted(Map.Entry.comparingByKey(Comparator.comparingLong(Long::parseLong)))
                            .collect(Collectors.toMap(
                                    Map.Entry::getKey,
                                    Map.Entry::getValue,
                                    (e1, e2) -> e1,
                                    LinkedHashMap::new));

                    List<Map<String, Object>> opDataList = (List<Map<String, Object>>) MapUtil.getOrDefault(pcUiBotModel.getPageData(), "op_data", Collections.emptyList());
                    Map<String, List<Map<String, Object>>> opDataMapByTrialWoNoAndOpSeq = opDataList.stream().collect(Collectors.groupingBy(e -> e.get("trial_wo_no") + "_" + e.get("op_seq")));

                    // allUnHandleCount获取当前用户所能操作的所有工艺数量， 用于提交后跳转哪一页，allUnHandleCount-1 > 0表示还可以继续处理而不是跳出任务卡详情页
                    List<Map<String, Object>> allOpDataList = opDataMapBySortedTrialWoNo.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
                    Long allUnHandleCountLong = allOpDataList.stream().filter(e -> isNeedCurrentPersonHandle(pcUiBotModel, e, compareUserId)).count();
                    int totalUnHandleCount = allUnHandleCountLong.intValue();

                    for (Map.Entry<String, List<Map<String, Object>>> opDataMapBySortedTrialWoNoItem : opDataMapBySortedTrialWoNo.entrySet()) {
                        List<Map<String, Object>> opDataMapBySortedTrialWoNoList = opDataMapBySortedTrialWoNoItem.getValue();
                        AtomicInteger totalUnHandleCountByTrialWoNo = new AtomicInteger();

                        CustomTabContentContainer customTabContentContainer = new CustomTabContentContainer();
                        ProcessNode copyProcessNode = JsonUtil.objectToJavaObject(processNode, ProcessNode.class);
                        copyProcessNode.setCmptUuid(customTabContentContainer.getCmptUuid());

                        // 构建 ProcessNode 节点
                        handleProcessNode(copyProcessNode, opDataMapBySortedTrialWoNoList, currentOpData,
                                pcUiBotModel, pageSetting, apiRequest, opDataMapByTrialWoNoAndOpSeq,
                                totalUnHandleCountByTrialWoNo, totalUnHandleCount, compareUserId);

                        customTabContentContainer.setContentCmptType(ProcessNode.COMPONENT_TYPE);
                        customTabContentContainer.setData(copyProcessNode);

                        CustomTab customTab = new CustomTab();
                        customTab.setName((String) MapUtil.getOrDefault(opDataMapBySortedTrialWoNoList.get(0), "trial_plan_name", ""));
                        customTab.setStyle(2);
                        customTab.setAlignmentType(1);
                        customTab.setIsSelected(opDataMapBySortedTrialWoNoItem.getKey().equals(currentOpData.get("trial_wo_no")));
                        customTab.setContent(Collections.singletonList(customTabContentContainer));
                        customTab.setUnHandleCount(totalUnHandleCountByTrialWoNo.get());
                        customTabs.add(customTab);
                    }
                    pageData.put(schema, customTabs);
                default:
                    break;
            }
        }
        return uiBotModel;
    }

    private void handleProcessNode(ProcessNode processNode, List<Map<String, Object>> opDataListByTrialWoNo, Map<String, Object> currentOpData,
                                   UiBotModel pcUiBotModel, PageSetting pageSetting, ApiRequest apiRequest, Map<String, List<Map<String, Object>>> opDataMapByTrialWoNoAndOpSeq,
                                   AtomicInteger totalUnHandleCountByTrialWoNo, int totalUnHandleCount, String compareUserId) {
        if (CollectionUtils.isEmpty(opDataListByTrialWoNo)) {
            return;
        }

        opDataListByTrialWoNo = opDataListByTrialWoNo.stream().sorted(
                Comparator.comparingInt(e -> (Integer) MapUtil.getOrDefault(e, "sort_index", 0))).collect(Collectors.toList());

        //试验过程记录
        MobileProcess mobileProcessRecord = processNode.getProcessList().get(0);

        //试验结果确认
        MobileProcess mobileProcessConfirm = processNode.getProcessList().get(1);

        List<MobileProcess> mobileProcessList = new ArrayList<>();
        for (Map<String, Object> processOpData : opDataListByTrialWoNo) {
            MobileProcess mobileCopyProcess;
            Boolean hasBottomButton;

            if (IS_NOT_ASSOCIATE_PROJECT.equals(processOpData.get("is_associate_project"))) {
                // 试验过程记录当前进行中节点如果没有report_no 需要请求接口获取
                if (!StringUtils.hasLength((String) MapUtil.getOrDefault(processOpData, "report_no", ""))) {
                    Map<String, Object> createTbdsTrialProductionParam = JsonUtil.objectToJavaObject(processOpData, Map.class);
                    List<Map<String, Object>> opDatas = digiwinEspProxyService.createTbdsTrialProductionReport(apiRequest.getIamUserToken(),
                            apiRequest.getTenantId(), apiRequest.getLocale(), Collections.singletonList(createTbdsTrialProductionParam));
                    if (!CollectionUtils.isEmpty(opDatas)) {
                        Map<String, Object> reportData = opDatas.get(0);
                        processOpData.put("report_no", reportData.get("report_no"));
                    }
                }
                mobileCopyProcess = JsonUtil.objectToJavaObject(mobileProcessRecord, MobileProcess.class);

                // 试验过程记录 底部按钮出现条件（报工详情，驳回，报工）需要是进行中或者已完成的节点
                hasBottomButton = (TbdsOpStatusEnum.IN_PROGRESS.getValue().equals(Integer.valueOf((String) processOpData.get("op_show_status"))) && isNeedCurrentPersonHandle(pcUiBotModel, processOpData, compareUserId))
                        || TbdsOpStatusEnum.COMPLETED.getValue().equals(Integer.valueOf((String) processOpData.get("op_show_status"))) ? true : false;
            } else {
                mobileCopyProcess = JsonUtil.objectToJavaObject(mobileProcessConfirm, MobileProcess.class);

                // 试验过程确认 底部按钮出现条件（提交）需要是进行中的节点且检测完成(检测完成即op_status=59)
                hasBottomButton = (TbdsOpStatusEnum.IN_PROGRESS.getValue().equals(Integer.valueOf((String) processOpData.get("op_show_status"))) && isNeedCurrentPersonHandle(pcUiBotModel, processOpData, compareUserId))
                        && TbdsOpStatusEnum.TEST_COMPLETED.getValue().equals(Integer.valueOf((String) processOpData.get("op_status"))) ? true : false;
            }

            // 该工艺当前处理人是否可以报工
            if (isNeedCurrentPersonHandle(pcUiBotModel, processOpData, compareUserId)) {
                mobileCopyProcess.setUnHandleCount(1);
                totalUnHandleCountByTrialWoNo.addAndGet(1);
            }
            mobileCopyProcess.setName((String) processOpData.get("op_name"));

            boolean isDefaultSelect = currentOpData.get("op_seq").equals(processOpData.get("op_seq")) && currentOpData.get("trial_wo_no").equals(processOpData.get("trial_wo_no"));
            mobileCopyProcess.setDefaultSelect(isDefaultSelect);
            mobileCopyProcess.setBottomButtonSchema("bottomButtons");
            mobileCopyProcess.setStatus(translateProcessStatus(Integer.valueOf((String) processOpData.get("op_show_status"))));

            // 编辑按钮出现条件，必须是当前系统操作人可操作且是进行中的工艺
            boolean hasEditButtom = isNeedCurrentPersonHandle(pcUiBotModel, processOpData, compareUserId)
                    && TbdsOpStatusEnum.IN_PROGRESS.getValue().equals(Integer.valueOf((String) processOpData.get("op_show_status"))) ? true : false;

            UiBotModel processDataUiBotModel = mobileCopyProcess.getData();
            Map<String, Object> commonRawData = processDataUiBotModel.getCommonRawData();
            processDataUiBotModel.buildCommonRawData(commonRawData, processOpData, pcUiBotModel);
            commonRawData.put("hasButton", hasEditButtom);

            // 构建每个ProcessNode里的uiBotModel信息
            buildPorcessNodeUiBotModel(processDataUiBotModel, processOpData, apiRequest, hasEditButtom, apiRequest.getLocale());

            // 底部按钮
            if (hasBottomButton) {
                List<Map<String, Object>> opDataListByTrialWoNoAndOpSeq = opDataMapByTrialWoNoAndOpSeq.get(processOpData.get("trial_wo_no") + "_" + processOpData.get("op_seq"));

                BottomButtonList bottomButtonList = buildBottonButtonList(pcUiBotModel, pageSetting, opDataListByTrialWoNo,
                        processOpData, opDataListByTrialWoNoAndOpSeq, totalUnHandleCount, apiRequest, hasEditButtom);
                mobileCopyProcess.setBottomButtonList(bottomButtonList);
            }
            mobileProcessList.add(mobileCopyProcess);
        }
        processNode.setProcessList(mobileProcessList);
    }

    /**
     * 构建每个ProcessNode里的uiBotModel信息
     */
    private void buildPorcessNodeUiBotModel(UiBotModel processDataUiBotModel, Map<String, Object> processOpData, ApiRequest apiRequest,
                                            Boolean hasEditButtom, String locale) {
        UiBotPageData processUiBotPageData = processDataUiBotModel.getPageData();
        Map<String, Object> commonRawData = processDataUiBotModel.getCommonRawData();

        for (UiBotLayout processDataLayout : processDataUiBotModel.getLayout()) {
            String processDataSchema = processDataLayout.getSchema();
            switch (processDataLayout.getType()) {
                case Card.COMPONENT_TYPE:
                    Card card = JsonUtil.objectToJavaObject(processUiBotPageData.get(processDataSchema), Card.class);
                    Map<String, Object> rawData = new HashMap<>(1);
                    if ("base_message".equals(processDataSchema)) {
                        Card.create(card, processOpData, locale, localeService, true);
                    } else if ("parameter_data".equals(processDataSchema)) {
                        List<Map<String, Object>> parameterDatas = (List<Map<String, Object>>) processOpData.get(processDataSchema);
                        if (CollectionUtils.isEmpty(parameterDatas)) {
                            processUiBotPageData.put(processDataSchema, Card.createCardEmpty(card, locale, localeService));
                            continue;
                        }
                        rawData.put("data", parameterDatas);
                        Action action = new Action();
                        if (hasEditButtom) {
                            action.setRefreshPageId(apiRequest.getPageId());
                            action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_TBDS_PRODUCTION_PROCESS_RECORD_MODIFY_PARAM.toString());
                            action.setJumpPageTitle(localeService.getLanguageValue(locale, "修改参数"));
                            action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
                            action.setRawData(rawData);

                        }
                        Card.create(card, parameterDatas, locale, localeService, action);
                    }
                    processUiBotPageData.put(processDataSchema, card);
                    break;
                case CustomGroup.COMPONENT_TYPE:
                    CustomGroup customGroup = JsonUtil.objectToJavaObject(processUiBotPageData.get(processDataSchema), CustomGroup.class);
                    customGroup.setName(localeService.getLanguageValue(locale, customGroup.getName()));

                    // 试验结果确认
                    if ("op_data".equals(processDataSchema) || "opData".equals(processDataSchema)) {
                        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_ZTB_SCAN_RECEIVE.getValue());

                        //已提交的从document_info获取检测报告，未提交的从接口查询获取
                        if ("op_data".equals(processDataSchema)
                                && !TbdsOpStatusEnum.COMPLETED.getValue().equals(Integer.valueOf((String) processOpData.get("op_show_status")))
                                && StringUtils.hasLength((String) processOpData.get("join_inspection_no"))) {
                            List<Map<String, Object>> bmQmscTestPlanReportInfos = digiwinEspProxyService.getBmQmscTestPlanReportInfo(apiRequest.getIamUserToken(),
                                    apiRequest.getTenantId(), locale, (String) processOpData.get("join_inspection_no"));
                            if (!CollectionUtils.isEmpty(bmQmscTestPlanReportInfos)) {
                                processOpData.put("document_info", bmQmscTestPlanReportInfos);
                                commonRawData.put("document_info", bmQmscTestPlanReportInfos);
                            }
                        }
                        customGroup.buildTbdsResult(customGroup, locale, localeService, processOpData);
                    } else {
                        customGroup.setStyleType(CustomGroupStyleTypeEnum.TEXT_OUTSIDE_THE_TITLE_GROUP.getValue());
                        List<Map<String, Object>> itemList = (List<Map<String, Object>>) processOpData.get(processDataSchema);
                        if (CollectionUtils.isEmpty(itemList)) {
                            processUiBotPageData.put(processDataSchema, CustomGroup.createEmptyGroup(locale, localeService.getLanguageValue(locale, processDataLayout.getLabel())));
                            continue;
                        }
                        customGroup.buildTbdsItemList(customGroup, locale, localeService,
                                itemList, commonRawData, digiwinAtdmProxyService, apiRequest, hasEditButtom, true, true);

                    }
                    processUiBotPageData.put(processDataSchema, customGroup);
                    break;
                default:
                    break;
            }
        }
    }

    /**
     * 底部按钮封装
     */
    private BottomButtonList buildBottonButtonList(UiBotModel pcUiBotModel, PageSetting pageSetting,
                                                   List<Map<String, Object>> opDataList, Map<String, Object> processOpData,
                                                   List<Map<String, Object>> opDataListByTrialWoNoAndOpSeq, int allUnHandleCount,
                                                   ApiRequest apiRequest, boolean hasEditButtom) {
        String locale = apiRequest.getLocale();
        BottomButtonList bottomButtonList = new BottomButtonList();
        UiBotLayout customLayout = UiBotModel.getCustomUibotLayout(pcUiBotModel.getLayout(), "TBDS_ProductionProcessRecord-task-detail-waitting");

        // 必须是当前系统操作人可操作且是进行中的工艺才展示驳回和报工按钮
        if (hasEditButtom) {

            // state !=1 代表驳回处理中，此时该工艺不可提交
            Map<String, Object> opDataMapByTrialWoNoAndOpSeq = null;
            if (!CollectionUtils.isEmpty(opDataListByTrialWoNoAndOpSeq)) {
                opDataMapByTrialWoNoAndOpSeq = opDataListByTrialWoNoAndOpSeq.stream().filter(e ->
                {
                    Map<String, Object> activityBackLogDataMap = (Map<String, Object>) MapUtil.getOrDefault(e, "activity__backLog__data", Collections.emptyMap());
                    List<Map<String, Object>> workitemList = (List<Map<String, Object>>) MapUtil.getOrDefault(activityBackLogDataMap, "workitemList", Collections.emptyList());
                    if (CollectionUtils.isEmpty(workitemList)) {
                        return false;
                    }
                    return Integer.valueOf(1).equals(MapUtils.getInteger(workitemList.get(0), "state"));
                }).findFirst().orElse(Collections.emptyMap());
                if (!CollectionUtils.isEmpty(opDataMapByTrialWoNoAndOpSeq)) {
                    // 提交和驳回需要对应的activity__backLog__data和activity__data__status
                    processOpData.put("activity__backLog__data", opDataMapByTrialWoNoAndOpSeq.get("activity__backLog__data"));
                    processOpData.put("activity__data__status", opDataMapByTrialWoNoAndOpSeq.get("activity__data__status"));
                }
            }

            // 试验过程记录只有驳回和报工按钮
            if (IS_NOT_ASSOCIATE_PROJECT.equals(processOpData.get("is_associate_project"))) {
                // 校验必填参数是否已经输入
                List<Map<String, Object>> parameterDataList = (List<Map<String, Object>>) MapUtil.getOrDefault(processOpData, "parameter_data", Collections.emptyList());
                boolean hasNotInput = parameterDataList.stream().anyMatch(e -> "Y".equals(e.get("is_required")) && StringUtil.isEmpty(e.get("parameter_value")));

                // 驳回按钮展示条件
                // 1.当前工艺不是第一道工艺且不是试验优测的卡
                // 2.前置工艺存在已完成且不是试验优测的数据
                List<Map<String, Object>> completeOpDataList = Collections.emptyList();
                if (!FIRST_SORT_INDEX.equals(processOpData.get("sort_index"))) {
                    completeOpDataList = opDataList.stream().filter(e ->
                            COMPLETE_STATUS.equals(e.get("op_show_status")) && IS_NOT_ASSOCIATE_PROJECT.equals(e.get("is_associate_project"))).collect(Collectors.toList());
                }
                if (!CollectionUtils.isEmpty(completeOpDataList)) {
                    BottomButtonDigiwinAthena bottomButtonDigiwinAthena = new BottomButtonDigiwinAthena();
                    Action action = new Action();

                    if (CollectionUtils.isEmpty(opDataMapByTrialWoNoAndOpSeq)) {
                        ConfirmPop confirmPop = new ConfirmPop();
                        confirmPop.setNeedConfirm(true);
                        confirmPop.setOnlyConfirmButton(true);
                        confirmPop.setContent(localeService.getLanguageValue(locale, "驳回处理中,请稍后刷新页面再进行提交"));
                        action.setConfirmPop(confirmPop);
                    } else {
                        Map<String, Object> buttonRawData = new HashMap<>(3);

                        if (customLayout.getActions() != null) {
                            Optional<UiBotAction> defaultActionOptional  = customLayout.getActions().stream().filter(ac -> !ac.getDefaultAction()).findFirst();
                            if(defaultActionOptional.isPresent()){
                                buttonRawData.put("action",defaultActionOptional.get());
                            }
                        }
                        buttonRawData.put("mobileOpDatas", completeOpDataList);
                        buttonRawData.put("operator_data", processOpData.get("operator_data"));

                        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_TBDS_PRODUCTION_PROCESS_RECORD_REJECT_SUBMIT.toString());
                        action.setJumpPageTitle(localeService.getLanguageValue(locale, "驳回"));
                        action.setRefreshPageId(PageSettingIdPresetEnum.FLASH_MY_TODO.toString());
                        action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());

                        buttonRawData.put("data", processOpData);
                        buttonRawData.put("biz_id", "TBDS");
                        buttonRawData.put("pageId", pageSetting.getPageId());
                        action.setRawData(buttonRawData);
                    }

                    bottomButtonDigiwinAthena.setType(BottomButtonStyleEnum.NORMAL.getValue());
                    bottomButtonDigiwinAthena.setName(localeService.getLanguageValue(locale, "驳回"));
                    bottomButtonDigiwinAthena.setAction(action);
                    bottomButtonList.add(bottomButtonDigiwinAthena);
                }

                // 报工按钮
                Action action = new Action();
                if (hasNotInput) {
                    ConfirmPop confirmPop = new ConfirmPop();
                    confirmPop.setNeedConfirm(true);
                    confirmPop.setOnlyConfirmButton(true);
                    confirmPop.setContent(localeService.getLanguageValue(locale, "工艺参数信息存在必填未填字段，请去编辑"));
                    action.setConfirmPop(confirmPop);
                } else if (CollectionUtils.isEmpty(opDataMapByTrialWoNoAndOpSeq)) {
                    ConfirmPop confirmPop = new ConfirmPop();
                    confirmPop.setNeedConfirm(true);
                    confirmPop.setOnlyConfirmButton(true);
                    confirmPop.setContent(localeService.getLanguageValue(locale, "驳回处理中,请稍后刷新页面再进行提交"));
                    action.setConfirmPop(confirmPop);
                } else {
                    action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_TBDS_PRODUCTION_PROCESS_RECORD_REPORT_SUBMIT.toString());
                    action.setJumpPageTitle(localeService.getLanguageValue(locale, "报工"));
                    action.setRefreshPageId(PageSettingIdPresetEnum.FLASH_MY_TODO.toString());
                    action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());

                    Map<String, Object> buttonRawData = new HashMap<>(3);
                    if (customLayout.getActions() != null) {
                        Optional<UiBotAction> AcActionOptional  = customLayout.getActions().stream().filter(ac -> ac.getDefaultAction()).findFirst();
                        if(AcActionOptional.isPresent()){
                            buttonRawData.put("action",AcActionOptional.get());
                        }
                    }
                    buttonRawData.put("data", processOpData);
                    buttonRawData.put("biz_id", "TBDS");
                    buttonRawData.put("pageId", pageSetting.getPageId());
                    buttonRawData.put("isNeedHandleNextProcess", allUnHandleCount - 1 > 0);
                    action.setRawData(buttonRawData);
                }

                BottomButtonDigiwinAthena bottomButtonDigiwinAthena = new BottomButtonDigiwinAthena();
                bottomButtonDigiwinAthena.setName(localeService.getLanguageValue(locale, "报工"));
                bottomButtonDigiwinAthena.setAction(action);
                bottomButtonList.add(bottomButtonDigiwinAthena);
            } else {
                // 试验结果确认只有提交按钮
                Map<String, Object> buttonRawData = new HashMap<>(3);
                buttonRawData.put("data", processOpData);
                buttonRawData.put("biz_id", "TBDS");
                buttonRawData.put("pageId", PageSettingIdPresetEnum.MOBILE_ATHENA_TBDS_RESULT_CONFIRMATION.toString());

                if (customLayout.getActions() != null) {
                    Optional<UiBotAction> defaultActionOptional = customLayout.getActions().stream()
                            .filter(ac -> ac.getDefaultAction())
                            .findFirst();
                    if (defaultActionOptional.isPresent()) {
                        buttonRawData.put("action", defaultActionOptional.get());
                    }
                }
                Action action = new Action();
                action.setRawData(buttonRawData);
                action.setType(ActionTypeEnum.CALL_API.getValue());

                BottomButtonDigiwinAthena bottomButtonDigiwinAthena = new BottomButtonDigiwinAthena();
                bottomButtonDigiwinAthena.setName(localeService.getLanguageValue(locale, "提交"));
                bottomButtonDigiwinAthena.setType(BottomButtonStyleEnum.STRESS.getValue());
                bottomButtonDigiwinAthena.setAction(action);
                bottomButtonList.add(bottomButtonDigiwinAthena);
            }
        } else if (IS_NOT_ASSOCIATE_PROJECT.equals(processOpData.get("is_associate_project"))
                && TbdsOpStatusEnum.COMPLETED.getValue().equals(Integer.valueOf((String) processOpData.get("op_show_status")))) {
            //试验过程记录的已完成的节点 展示报工详情按钮
            BottomButtonDigiwinAthena bottomButtonDigiwinAthena = new BottomButtonDigiwinAthena();
            Action action = new Action();
            action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_TBDS_PRODUCTION_PROGRESS_REPORT_DETAIL.toString());
            action.setRefreshPageId(PageSettingIdPresetEnum.FLASH_MY_TODO.toString());
            action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());

            Map<String, Object> buttonRawData = new HashMap<>(3);
            buttonRawData.put("data", processOpData);
            buttonRawData.put("biz_id", "TBDS");
            buttonRawData.put("pageId", pageSetting.getPageId());
            action.setRawData(buttonRawData);

            bottomButtonDigiwinAthena.setType(BottomButtonStyleEnum.STRESS.getValue());
            bottomButtonDigiwinAthena.setName(localeService.getLanguageValue(locale, "报工详情"));
            bottomButtonDigiwinAthena.setAction(action);
            bottomButtonList.add(bottomButtonDigiwinAthena);
        }
        return bottomButtonList;
    }

    // opShowStatus 转化为显示节点状态枚举
    private Integer translateProcessStatus(Integer opShowStatus) {
        Integer status = null;
        TbdsOpStatusEnum tbdsOpStatusEnum = TbdsOpStatusEnum.getEnumByValue(opShowStatus);
        switch (tbdsOpStatusEnum) {
            case NO_START:
                status = MobileProcessStatusEnum.NO_START.getStatus();
                break;
            case IN_PROGRESS:
                status = MobileProcessStatusEnum.IN_PROGRESS.getStatus();
                break;
            case COMPLETED:
                status = MobileProcessStatusEnum.COMPLETED.getStatus();
                break;
            default:
        }
        return status;
    }

    /**
     * 获取所有工艺
     */
    public List<Map<String, Object>> getAllProcess(UiBotModel pcUiBotModel, ApiRequest apiRequest) {
        UiBotExecuteContext executeContext = pcUiBotModel.getExecuteContext();
        Map<String, Object> bpmDataMap = (Map<String, Object>) executeContext.get("bpmData");
        List<Map<String, Object>> queryInfoList = (List<Map<String, Object>>) MapUtil.getOrDefault(bpmDataMap, "query_info", Collections.emptyList());
        if (CollectionUtils.isEmpty(queryInfoList)) {
            return Collections.emptyList();
        }
        Map<String, Object> queryParamMap = new HashMap<>();
        queryParamMap.put("eoc_company_id", MapUtils.getString(queryInfoList.get(0), "eoc_company_id"));
        queryParamMap.put("eoc_site_id", MapUtils.getString(queryInfoList.get(0), "eoc_site_id"));
        queryParamMap.put("item_no", MapUtils.getString(queryInfoList.get(0), "item_no"));
        queryParamMap.put("project_no", MapUtils.getString(queryInfoList.get(0), "project_no"));
        queryParamMap.put("sub_project_no", MapUtils.getString(queryInfoList.get(0), "sub_project_no"));
        List<Map<String, Object>> bmMoscTrialWoList = digiwinEspProxyService.getBmMoscTrialWo(apiRequest.getIamUserToken(), apiRequest.getTenantId(),
                apiRequest.getLocale(), Collections.singletonList(queryParamMap));
        if (CollectionUtils.isEmpty(bmMoscTrialWoList)) {
            return Collections.emptyList();
        }
        Map<String, String> trialWoNoByNameMap = bmMoscTrialWoList.stream().collect(Collectors.toMap(e -> MapUtils.getString(e, "trial_wo_no"), e -> MapUtils.getString(e, "trial_plan_name"), (key1, key2) -> key2));
        List<Map<String, Object>> tbdsTrialProductionCompleteList = digiwinEspProxyService.getTbdsTrialProductionCompleteList(apiRequest.getIamUserToken(), apiRequest.getTenantId(),
                apiRequest.getLocale(), bmMoscTrialWoList);

        // 有些数据方案名称没有
        if (!CollectionUtils.isEmpty(tbdsTrialProductionCompleteList)) {
            tbdsTrialProductionCompleteList.forEach(e -> {
                if (!StringUtils.hasLength(MapUtils.getString(e, "trial_plan_name"))) {
                    e.put("trial_plan_name", trialWoNoByNameMap.get(MapUtils.getString(e, "trial_wo_no")));
                }
            });
        }
        return tbdsTrialProductionCompleteList;
    }

    public Map<String, Object> getCurrentProcess(UiBotModel pcUiBotModel, List<Map<String, Object>> opDataList, ApiRequest apiRequest, String compareUserId) {
        // 入参为显示小红点的工艺集合
        List<Map<String, Object>> trialWoProcessList = opDataList.stream().filter(e -> isNeedCurrentPersonHandle(pcUiBotModel, e, compareUserId)).map(e -> {
            Map<String, Object> queryInfo = new HashMap<>();
            queryInfo.put("eoc_company_id", e.get("eoc_company_id"));
            queryInfo.put("eoc_site_id", e.get("eoc_site_id"));
            queryInfo.put("item_no", e.get("item_no"));
            queryInfo.put("op_no", e.get("op_no"));
            queryInfo.put("op_seq", e.get("op_seq"));
            queryInfo.put("project_no", e.get("project_no"));
            queryInfo.put("sub_op_seq", e.get("sub_op_seq"));
            queryInfo.put("sub_project_no", e.get("sub_project_no"));
            queryInfo.put("trial_wo_no", e.get("trial_wo_no"));
            return queryInfo;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(trialWoProcessList)) {
            return opDataList.get(0);
        }
        List<Map<String, Object>> earliestStartDateTrialWoProcessList = digiwinEspProxyService.getBmOpscEarliestStartDateTrialWoProcess(apiRequest.getIamUserToken(), apiRequest.getTenantId(),
                apiRequest.getLocale(), trialWoProcessList);
        if (CollectionUtils.isEmpty(earliestStartDateTrialWoProcessList)) {
            return opDataList.get(0);
        }
        Map<String, Object> earliestStartDateTrialWoProcess = earliestStartDateTrialWoProcessList.get(0);
        String trialWoNo = (String) MapUtil.getOrDefault(earliestStartDateTrialWoProcess, "trial_wo_no", "");
        String opSeq = (String) MapUtil.getOrDefault(earliestStartDateTrialWoProcess, "op_seq", "");
        return opDataList.stream().filter(e -> trialWoNo.equals(e.get("trial_wo_no")) && opSeq.equals(e.get("op_seq"))).findFirst().orElse(opDataList.get(0));
    }

    /**
     * 当前系统操作人是否可以操作当前工艺
     */
    private boolean isNeedCurrentPersonHandle(UiBotModel pcUiBotModel, Map<String, Object> processOpData, String compareUserId) {
        if ("30".equals(processOpData.get("card_status")) && !"30".equals(processOpData.get("op_status"))) {
            List<Map<String, Object>> allBpmData = (List<Map<String, Object>>) pcUiBotModel.getExecuteContext().get("allBpmData");

            boolean everyItemHasReworkTimes = allBpmData.stream().allMatch(e -> Objects.nonNull(e.get("rework_times")));
            boolean anyMatch = allBpmData.stream().anyMatch(e -> {
                List<Map<String, Object>> queryInfoList = (List<Map<String, Object>>) MapUtil.getOrDefault(e, "query_info", Collections.emptyList());
                if (CollectionUtils.isEmpty(queryInfoList)) {
                    return true;
                }
                Map<String, Object> queryInfo = queryInfoList.get(0);
                return queryInfo.get("trial_wo_no").equals(processOpData.get("trial_wo_no"))
                        && queryInfo.get("op_seq").equals(processOpData.get("op_seq"))
                        && (everyItemHasReworkTimes ? e.get("rework_times").equals(processOpData.get("rework_times")) : true);
            });
            return anyMatch;
        }
        return false;
    }

    /**
     * 当前系统操作人与工艺可处理人是否匹配
     */
    private boolean isCurrentPerson(Map<String, Object> processOpData, String compareUserId) {
        List<Map<String, Object>> operatorDataList = (List<Map<String, Object>>) MapUtil.getOrDefault(processOpData, "operator_data", Collections.emptyList());
        return operatorDataList.stream().anyMatch(i -> StringUtils.hasLength(compareUserId)
                && compareUserId.equals(i.get("operator_no")));
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }

    @Override
    public TaskDetail build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Object... args) {
        return null;
    }

}
