package com.digiwin.mobile.mobileuibot.task.strategy.custom.workreportinfo;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.*;
import com.digiwin.mobile.mobileuibot.core.component.basic.MessageBar;
import com.digiwin.mobile.mobileuibot.core.component.basic.MessageBarStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.layout.singlelistcontainer.SingleListContainer;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.designer.uibot.enums.SourceCategoryEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.model.db1.UserCardListFilter;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfig;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfigRepository;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.common.MobileDesignerConfigTypeEnum;
import com.digiwin.mobile.mobileuibot.mysql.model.UserCardListFilterQueryDTO;
import com.digiwin.mobile.mobileuibot.mysql.service.UserCardListFilterService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.button.UiBotQueryButton;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template.BusinessProcessPerformerImpl;
import com.fasterxml.jackson.core.type.TypeReference;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

/**
 * <p>功能描述：报工查询</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: taskDetailBuildPccWorkReportInfoStrategy
 * @Author: xujinc
 * @Date: 2024年04月23日 11点55分
 */
@Component("taskDetailBuildPccWorkReportInfoStrategy")
public class TaskDetailBuildPccWorkReportInfoStrategy implements UiBotModelBuildStrategy {
    private static final Logger logger =
            LoggerFactory.getLogger(TaskDetailBuildPccWorkReportInfoStrategy.class);

    private static final String TMACTIVITYID = "DataEntry_workreportinfo";

    @Autowired
    private MobileDesignerConfigRepository mobileDesignerConfigRepository;

    @Autowired
    private BusinessProcessPerformerImpl businessProcessPerformerImpl;

    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;

    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;

    @Autowired
    private UserCardListFilterService userCardListFilterService;

    @Autowired
    private UiBotDesignerRenderService uiBotDesignerRenderService;

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("Build Pcc Work Report Info Page");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());

        List<BaseMobileComponentWrapper<BaseMobileComponent>> bodyCmptList = new ArrayList<>();

        // 获取当前人员id
        String eocId = digiwinEocProxyService.getEocId(apiRequest.getIamUserToken(), apiRequest.getUserId());
        String employeeNo = StringUtils.hasLength(eocId) ? eocId : apiRequest.getUserId();

        Map<String, Object> employeeInfoMap = new HashMap<>();
        employeeInfoMap.put("employee_no", employeeNo);
        Map<String, Object> queryConditionMap = new HashMap<>();
        queryConditionMap.put("employee_info", Collections.singletonList(employeeInfoMap));

        // 接口数据量过大会查询失败，所以筛选使用接口增加查询条件来实现，而不是我们自己来筛选数据
        UserCardListFilter userCardListFilter = userCardListFilterService
                .getUserCardListFilterByTmActivityIdAndUserId(new UserCardListFilterQueryDTO()
                        .setTenantId(AppRequestContext.getContextEntity().getTenantId())
                        .setUserId(AppRequestContext.getContextEntity().getUserId())
                        .setTmActivityId(TMACTIVITYID));
        String data = Optional.ofNullable(userCardListFilter).map(UserCardListFilter::getData).orElse("");
        if (StringUtils.hasLength(data)) {
            Map dataMap = JsonUtil.jsonStringToObject(data, Map.class);
            queryConditionMap.putAll(dataMap);
            queryConditionMap.put("project_info", queryConditionMap.get("project_info_condition"));
            queryConditionMap.remove("project_info_condition");
        }

        Map<String, Object> parameter = new HashMap<>(1);
        parameter.put("query_condition", Collections.singletonList(queryConditionMap));

        Map<String, Object> params = new HashMap<>(2);
        params.put("parameter", parameter);
        params.put("actionId", "task.report.record.info.get");
        DigiwinAthenaApiResponse<JSONObject> getTaskReportRecordResp = digiwinAtdmProxyService.handleByActionId(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), null, params);
        List<Map<String, Object>> taskReportRecordInfoList = (List<Map<String, Object>>) MapUtil.getOrDefault(getTaskReportRecordResp.getResponse().getInnerMap(), "report_info", Collections.emptyList());

        // 存在errg_msg，返回滚动条展示错误，而不是暂无数据，用来区分是否是数据量过大的原因
        if (taskReportRecordInfoList.size() == 1 && StringUtils.hasLength(MapUtils.getString(taskReportRecordInfoList.get(0), "errg_msg"))) {
            String errgMsg = MapUtils.getString(taskReportRecordInfoList.get(0), "errg_msg");
            String emptyDateMsg = localeService.getLanguageValue(apiRequest.getLocale(), "暂无数据");

            // 如果pc返回的错误信息是暂时数据，不需要展示滚动条
            if (!emptyDateMsg.equals(errgMsg)) {
                BaseMobileComponentWrapper baseMobileComponentWrapper = new BaseMobileComponentWrapper<>(
                        MessageBar.create(errgMsg, MessageBarStyleTypeEnum.RED_WORD_PINK_BACKGROUDCOLOR.getType()),
                        "DW_" + MessageBar.COMPONENT_TYPE);
                bodyCmptList.add(baseMobileComponentWrapper);
            }
            taskReportRecordInfoList.clear();
        }

        //按报工时间从大到小排序
        taskReportRecordInfoList = taskReportRecordInfoList.stream().sorted((o1, o2) -> {
            LocalDateTime o1SDate = DateTimeUtil.parseUseDefaultPattern(MapUtils.getString(o1, "report_date"));
            LocalDateTime o2SDate = DateTimeUtil.parseUseDefaultPattern(MapUtils.getString(o2, "report_date"));
            return o2SDate.compareTo(o1SDate);
        }).collect(Collectors.toList());

        // 表格序号使用
        AtomicInteger index = new AtomicInteger(1);
        taskReportRecordInfoList.forEach(e -> {
            e.put("index", index.getAndIncrement());
            // 项目名称栏位显示项目名称+项目编号
            e.put("project_detail", e.get("project_name") + "[" + e.get("project_no") + "]");
            // 百分比显示处理
            e.put("translate_report_complete_rate", (new BigDecimal(String.valueOf(MapUtils.getDoubleValue(e, "report_complete_rate")))
                    .multiply(new BigDecimal(100))).stripTrailingZeros().toPlainString() + "%");
        });

        MobileDesignerConfig config = mobileDesignerConfigRepository.selectOneDsl(TMACTIVITYID, MobileDesignerConfigTypeEnum.DATA_ENTRY.getValue());
        List<UiBotPageLayout> uiBotPageLayoutList = Optional.ofNullable(config)
                .map(MobileDesignerConfig::getData)
                .map(r -> {
                    MobileRenderDataUtil.multilingualProcessing(r, AppRequestContext.getContextEntity().getLocale());
                    return r;
                })
                .map(r -> r.getJSONObject("pageDslMobile"))
                .map(r -> (Map) r.getJSONArray("layout").get(0))
                .map(r -> (Map) r.get("data"))
                .map(r -> r.get("data"))
                .map(r -> JsonUtil.objectToJavaObject(r, new TypeReference<List<UiBotPageLayout>>() {
                })).orElse(Collections.emptyList());
        if (!CollectionUtils.isEmpty(uiBotPageLayoutList)) {
            uiBotPageLayoutList.forEach(uiBotPageLayout -> uiBotPageLayout.convert(uiBotPageLayout.getComponentType()));
        }

        UiBotQueryButton queryButton = new UiBotQueryButton();
        queryButton.setPageLayout(uiBotPageLayoutList);

        List<Map<String, Object>> hooks = Optional.ofNullable(config)
                .map(MobileDesignerConfig::getData)
                .map(r -> r.getJSONObject("pageDslMobile"))
                .map(r -> (List) r.getJSONArray("hooks")).orElse(Collections.emptyList());
        queryButton.setHooks(hooks);

        PcUiBotDataSourceSetDTO pcUiBotDataSourceSetDTO = new PcUiBotDataSourceSetDTO();
        pcUiBotDataSourceSetDTO.setMainDatasource("report_info");
        queryButton.setDataSourceSet(JsonUtil.objectToJavaObject(pcUiBotDataSourceSetDTO, Map.class));

        UiBotPageData uiBotPageData = new UiBotPageData();
        uiBotPageData.put("report_info", taskReportRecordInfoList);
        uiBotModel.setPageData(uiBotPageData);

        PcUiBotExecuteContext pcUiBotExecuteContext = PcUiBotExecuteContext.create(apiRequest.getLocale(), apiRequest.getTenantId(), apiRequest.getDataId());
        pcUiBotExecuteContext.appendPageInfo(UiBotDesignerService.PAGECODE_TASK_DETAIL, null, apiRequest.getDataId(), PcUiBotActivityConstants.PERFORMER, Boolean.FALSE);
        pcUiBotExecuteContext.setTmActivityId(TMACTIVITYID);
        pcUiBotExecuteContext.setAuthoredUser(new PcUiBotAuthoredUser()
                .setUserId(apiRequest.getUserId()).setTenantId(apiRequest.getTenantId())
                .setToken(apiRequest.getIamUserToken()));

        ComponentContext cmptContext = JsonUtil.objectToJavaObject(apiRequest, ComponentContext.class);

        // 高级属性--构建主页面hooks与上下文中组件级hooks
        uiBotDesignerRenderService.buildMainPageHooksByQueryButton(queryButton, cmptContext, uiBotModel, null);

        MobilePageRawData mobilePageRawData = new MobilePageRawData();
        mobilePageRawData.setSourceCategory(SourceCategoryEnum.WORK_REPORT_INFO.name());

        List<BaseMobileComponentWrapper<BaseMobileComponent>> buildBodyCmptList =
                businessProcessPerformerImpl.buildBodyCmpt(pcUiBotExecuteContext, uiBotModel, cmptContext, queryButton, mobilePageRawData, null);
        if (!CollectionUtils.isEmpty(buildBodyCmptList)) {
            bodyCmptList.addAll(buildBodyCmptList);
        }

        if (CollectionUtils.isEmpty(bodyCmptList)) {
            // 添加空组件
            uiBotModel.getRenderData().addEmptyComponentToBody();
        } else {
            int bodyContainerType = UiBotDesignerRenderService.getBodyContainerType(bodyCmptList);
            if (bodyContainerType == 1) {
                SingleListContainer<BaseMobileComponent> singleListContainer = new SingleListContainer<>();
                singleListContainer.addAll(bodyCmptList);
                uiBotModel.getRenderData().addWrapperedComponentToBody(
                        new BaseMobileComponentWrapper<>(singleListContainer, "DW_" + singleListContainer.returnComponentType()));
            } else {
                uiBotModel.getRenderData().addWrapperedComponentListToBody(bodyCmptList);
            }

            // 构建bottom
            List<BaseMobileComponentWrapper<BaseMobileComponent>> bottomCmptList =
                    businessProcessPerformerImpl.buildBottomCmpt(pcUiBotExecuteContext, uiBotModel, cmptContext, queryButton, mobilePageRawData, null);
            if (!CollectionUtils.isEmpty(bottomCmptList)) {
                uiBotModel.getRenderData().addWrapperedComponentListToBottom(bottomCmptList);
            }
        }
        return uiBotModel;
    }

    public static String getTmactivityid() {
        return TMACTIVITYID;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
