package com.digiwin.mobile.mobileuibot.task.strategy.custom.workreportinfo;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderDataUtil;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer.AbstractUniversalParsingPageStrategy;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer.entity.AbstractEntity;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfig;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfigRepository;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.common.MobileDesignerConfigTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.Data;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.io.IOException;
import java.util.*;

/**
 * <p>功能描述：报工查询详情页</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: taskDetailBuildPccWorkReportInfoStrategy
 * @Author: xujinc
 * @Date: 2024年04月23日 11点55分
 */
@Component("taskDetailBuildPccWorkReportInfoUniversalParsingStrategy")
public class TaskDetailBuildPccWorkReportInfoUniversalParsingStrategy extends AbstractUniversalParsingPageStrategy<TaskDetailBuildPccWorkReportInfoUniversalParsingStrategy.WorkReportInfoEntity> {
    private static final Logger logger =
            LoggerFactory.getLogger(TaskDetailBuildPccWorkReportInfoUniversalParsingStrategy.class);

    private static final String TMACTIVITYID = "DataEntry_workreportinfo";

    @Autowired
    private MobileDesignerConfigRepository mobileDesignerConfigRepository;

    @Autowired
    private UiBotDesignerRenderService uiBotDesignerRenderService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        return super.buildModel(new TaskDetailBuildPccWorkReportInfoUniversalParsingStrategy.WorkReportInfoEntity(), pageSetting, apiRequest);
    }

    @Override
    protected void handleRawDataData(TaskDetailBuildPccWorkReportInfoUniversalParsingStrategy.WorkReportInfoEntity absEntity) {
        MobileDesignerConfig config = mobileDesignerConfigRepository.selectOneDsl(TMACTIVITYID, MobileDesignerConfigTypeEnum.DATA_ENTRY.getValue());
        List<Map<String, Object>> hooks = Optional.ofNullable(config)
                .map(MobileDesignerConfig::getData)
                .map(r -> r.getJSONObject("pageDslMobile"))
                .map(r -> (List) r.getJSONArray("hooks")).orElse(Collections.emptyList());
        PcUiBotPageDefine pageDefine = new PcUiBotPageDefine();
        pageDefine.setHooks(hooks);
        absEntity.setPageDefine(pageDefine);
    }

    @Override
    protected UiBotPageLayout bulidPageLayout(TaskDetailBuildPccWorkReportInfoUniversalParsingStrategy.WorkReportInfoEntity absEntity) {
        // pageId是随机字符串
        String pageId = absEntity.getApiRequest().getPageId();

        MobileDesignerConfig config = mobileDesignerConfigRepository.selectOneDsl(TMACTIVITYID, MobileDesignerConfigTypeEnum.DATA_ENTRY.getValue())
        ;
        List<UiBotPageLayout> uiBotPageLayoutList = Optional.ofNullable(config)
                .map(MobileDesignerConfig::getData)
                .map(r -> {
                    MobileRenderDataUtil.multilingualProcessing(r, AppRequestContext.getContextEntity().getLocale());
                    return r;
                })
                .map(r -> r.getJSONObject("pageDslMobile"))
                .map(r -> (Map) r.getJSONArray("layout").get(0))
                .map(r -> (Map) r.get("data"))
                .map(r -> r.get("data"))
                .map(r -> JsonUtil.objectToJavaObject(r, new TypeReference<List<UiBotPageLayout>>() {
                })).orElse(Collections.emptyList());
        if (!CollectionUtils.isEmpty(uiBotPageLayoutList)) {
            uiBotPageLayoutList.forEach(uiBotPageLayout -> uiBotPageLayout.convert(uiBotPageLayout.getComponentType()));
        }

        // 根据pageId获取设计态页面DSL
        return uiBotPageLayoutList
                .stream()
                .filter(pageLayout -> pageId.equals(pageLayout.getPageId()))
                .findFirst()
                .orElse(null);
    }

    @Override
    protected Map<String, Map<String, Object>> handlePageLayoutData(WorkReportInfoEntity absEntity) {
        return Optional.ofNullable(absEntity.getPageDefine())
                .map(PcUiBotPageDefine::getPageLayoutInfo)
                .orElse(new HashMap<>());
    }

    @Override
    protected void buildRule(TaskDetailBuildPccWorkReportInfoUniversalParsingStrategy.WorkReportInfoEntity absEntity) {
        // 走本地配置
        List<UiBotRule> rules = pcRuleService.buildRuleOfLocal(absEntity.getExecuteContext().getTmActivityId(), MobileDesignerConfigTypeEnum.DATA_ENTRY.getValue());
        if (!CollectionUtils.isEmpty(rules)) {
            absEntity.getUiBotModel().setRules(rules);
        }
    }

    @Data
    protected static
    class WorkReportInfoEntity extends AbstractEntity {
        private PcUiBotPageDefine pageDefine;
    }

    @Override
    protected Map<String, Object> buildHooks(WorkReportInfoEntity absEntity, UiBotPageLayout pageLayout, ComponentContext cmptContext) {
        List<Map<String, Object>> hooks = Optional.ofNullable(absEntity).map(WorkReportInfoEntity::getPageDefine)
                .map(PcUiBotPageDefine::getHooks).orElse(Collections.emptyList());
        return uiBotDesignerRenderService.buildHooks(hooks, pageLayout, cmptContext);
    }

    @Override
    protected PcUiBotPageDefine getPageDefine(WorkReportInfoEntity absEntity) {
        return absEntity.getPageDefine();
    }
}
