package com.digiwin.mobile.mobileuibot.test;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：${请输入当前Class的用途}</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TestController.java
 * @Author: wangjwc
 * @Date: created at 2024/8/21 13:43
 */
@Slf4j
@RestController
@RequestMapping("/mobile/v1/test")
public class TestController {
    /**
     * 年会特定租户：鼎新數智(正式)(88888888)
     * 新门户特殊处理不走audc服务与img服务
     */
    public static boolean specialHandleSwitch = false;

    @GetMapping(value = "/specialHandleSwitch")
    public ApiResponse<Boolean> specialHandleSwitch(@RequestParam(name = "specialHandleSwitch") Boolean specialHandleSwitch) {
        return ApiResponse.buildOK().setData(this.specialHandleSwitch = specialHandleSwitch);
    }

    public static boolean specialHandleSwitch() {
        return specialHandleSwitch && "88888888".equals(AppRequestContext.getContextEntity().getTenantId());
    }


    /**
     * v1转v2任务临时tmActivityIdList列表
     */
    @GetMapping(value = "/v1Tov2/list")
    public ApiResponse<List<String>> v1Tov2List() {
        return ApiResponse.buildOK().setData(TestV1ToV2Util.getTmActivityIdList());
    }

    /**
     * v1转v2任务临时tmActivityIdList列表数据重置
     */
    @PostMapping(value = "/v1Tov2/reset")
    public ApiResponse<List<String>> v1Tov2Reset(@RequestBody Map<String, Object> requestParam) {
        List<String> tmActivityIdList = (List<String>) requestParam.get("tmActivityIdList");
        TestV1ToV2Util.resetTmActivityIdList(tmActivityIdList);
        return ApiResponse.buildOK().setData(TestV1ToV2Util.getTmActivityIdList());
    }
}
