package com.digiwin.mobile.mobileuibot.test;


import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.pattern.CustomPatternTaskTypeEnum;
import com.google.common.collect.Lists;

import java.util.List;

/**
 * <p>功能描述：${请输入当前Class的用途}</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TestV1ToV2Util.java
 * @Author: wangjwc
 * @Date: created at 2024/8/21 14:03
 */
public class TestV1ToV2Util {

    /**
     * 异常结案：apc_abnormal_closecase
     * 异常回报：apc_abnormalReport
     * 支援需求：apc_support_needs
     * 工单上线：apc_workShopOnline
     * 工单变更：apc_team_dispatch
     */
    private static final List<String> TM_ACTIVITY_ID_LIST = Lists.newArrayList(
            "apc_abnormalReport", "apc_support_needs",
            "apc_team_dispatch", "apc_working_hour", "apc_hour_support");

    private static final String HEADER_MODEL_TYPE = "v1Tov2_1";

    public static List<String> getTmActivityIdList() {
        return TM_ACTIVITY_ID_LIST;
    }

    public static void resetTmActivityIdList(List<String> tmActivityIdList) {
        TM_ACTIVITY_ID_LIST.clear();
        TM_ACTIVITY_ID_LIST.addAll(tmActivityIdList);
    }

    public static boolean exist(String tmActivityId) {
        // 请求头存在（V1转V2标志）并且 tmActivityId存在tmActivityIdList中  -- 雳渊测试路线-走本地配置
        return HEADER_MODEL_TYPE.equals(AppRequestContext.getContextEntity().getModelType())
                && TM_ACTIVITY_ID_LIST.contains(tmActivityId);
    }

    public static void handleV1ToV2(ApiRequest apiRequest, String tempActivityId) {
        // 请求头存在（V1转V2标志） -- 雳渊测试路线
        if (HEADER_MODEL_TYPE.equals(AppRequestContext.getContextEntity().getModelType())) {
            return;
        }
        // 不存在tmActivityIdList中（V1转V2列表） -- 现有任务路线
        if (!TM_ACTIVITY_ID_LIST.contains(tempActivityId)) {
            return;
        }
        // 存在tmActivityIdList中（V1转V2列表） -- 重置属性 -- 客户场景路线（走V1流程）
        apiRequest.getPatternTaskInfo().setCustomPatternTaskType(CustomPatternTaskTypeEnum.NOT_EXIST_MOBILE_PAGE_AND_PC_ISCUSTOMIZE_FALSE);
    }

//    public static boolean checkV1ToV2(ApiRequest apiRequest) {
//        String tmActivityId = Optional.ofNullable(apiRequest).map(ApiRequest::getExtraParameter).map(ApiExtraParameter::getTmActivityId).orElse(null);
//        String appCode = Optional.ofNullable(apiRequest).map(ApiRequest::getExtraParameter).map(ApiExtraParameter::getAppCode).orElse(null);
//        if (StringUtils.isEmpty(tmActivityId) || StringUtils.isEmpty(appCode)) {
//            return false;
//        }
//        ActivityFilterService activityFilterService = SpringContextHolder.getBean(ActivityFilterService.class);
//        String tenantVersion = activityFilterService.tenantVersion(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
//        // 不存在mobileDesignerConfig表中 -- 走V1流程
//        Boolean exsitTmActivityId = activityFilterService.isExsitTmActivityIdOfMobileDesignerConfig(appCode, tmActivityId, MobileDesignerConfigTypeEnum.TASK.getValue(), apiRequest.getTenantId(), tenantVersion);
//        if (BooleanUtils.isNotTrue(exsitTmActivityId)) {
//            return false;
//        }
//        // 请求头存在（V1转V2标志） -- 走V2流程
//        if (HEADER_MODEL_TYPE.equals(AppRequestContext.getContextEntity().getModelType())) {
//            return true;
//        }
//        // 不存在tmActivityIdList中（V1转V2列表） -- 走V2流程
//        if (!TM_ACTIVITY_ID_LIST.contains(tmActivityId)) {
//            return true;
//        }
//        return false;
//    }

    public static boolean modelTypeMatch() {
        return HEADER_MODEL_TYPE.equals(AppRequestContext.getContextEntity().getModelType());
    }

    public static boolean activityIdMatch(String tmActivityId) {
        return TM_ACTIVITY_ID_LIST.contains(tmActivityId);
    }
}
