package com.digiwin.mobile.mobileuibot.user.enums;

import lombok.Getter;
import org.springframework.util.StringUtils;

/**
 * <p>功能描述：身份认证接受类型枚举类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: IdentityCodeAcceptTypeEnum.java
 * @Author: wangjwc
 * @Date: created at 2025/8/4 16:36
 */
@Getter
public enum IdentityCodeAcceptTypeEnum {
    /**
     * 邮箱验证(email)
     */
    EMAIL("email"),

    /**
     * 手机号验证(mobile)
     */
    MOBILE("mobile"),
    ;

    private final String value;

    IdentityCodeAcceptTypeEnum(String value) {
        this.value = value;
    }

    public static boolean isExist(String value) {
        if (!StringUtils.hasLength(value)) {
            return false;
        }
        for (IdentityCodeAcceptTypeEnum typeEnum : values()) {
            if (typeEnum.getValue().equals(value)) {
                return true;
            }
        }
        return false;
    }

    public static boolean notExist(String value) {
        return !isExist(value);
    }
}
