package com.digiwin.mobile.mobileuibot.user.enums;

import lombok.Getter;
import org.springframework.util.StringUtils;

/**
 * <p>功能描述：验证类型枚举类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: VerificationTypeEnum.java
 * @Author: wangjwc
 * @Date: created at 2025/8/5 15:51
 */
@Getter
public enum VerificationTypeEnum {
    /**
     * 邮箱(email)
     */
    EMAIL("email"),

    /**
     * 手机号(mobilephone)
     */
    MOBILEPHONE("mobilephone"),
    ;

    private final String value;

    VerificationTypeEnum(String value) {
        this.value = value;
    }

    public static boolean isExist(String value) {
        if (!StringUtils.hasLength(value)) {
            return false;
        }
        for (VerificationTypeEnum typeEnum : values()) {
            if (typeEnum.getValue().equals(value)) {
                return true;
            }
        }
        return false;
    }

    public static boolean notExist(String value) {
        return !isExist(value);
    }
}
