package com.digiwin.mobile.mobileuibot.user.request;

import com.digiwin.mobile.mobileuibot.api.BaseRequest;
import com.digiwin.mobile.mobileuibot.api.EnumConstraint;
import com.digiwin.mobile.mobileuibot.user.enums.VerificationTypeEnum;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * <p>功能描述：账号是否存在请求参数类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AccountExistCheckReq.java
 * @Author: wangjwc
 * @Date: created at 2025/8/5 15:48
 */
@Data
public class AccountExistCheckReq extends BaseRequest {
    private static final long serialVersionUID = 6132354149937845614L;

    /**
     * 类型，邮箱（email）手机号（mobilephone）
     * @see com.digiwin.mobile.mobileuibot.user.enums.VerificationTypeEnum
     */
    @NotBlank(message = "type字段不能为空")
    @EnumConstraint(
            enumClass = VerificationTypeEnum.class,
            valueMethod = "getValue",
            message = "字段 type 的输入值 '{value}' 不合法! 有效选项: {values}")
    private String type;
    // 账号：手机或邮箱
    @NotBlank(message = "account字段不能为空")
    private String account;
}
