package com.digiwin.mobile.mobileuibot.user.request;

import com.digiwin.mobile.mobileuibot.api.BaseRequest;
import com.digiwin.mobile.mobileuibot.api.EnumConstraint;
import com.digiwin.mobile.mobileuibot.proxy.emc.model.EmcVerificationCodeSceneEnum;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * <p>功能描述：验证验证码请求参数</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: CheckVerificationCodeReq.java
 * @Author: wangjwc
 * @Date: created at 2025/8/5 16:39
 */
@Data
public class CheckVerificationCodeReq extends BaseRequest {
    private static final long serialVersionUID = 2520188629266630697L;

    // 账号：手机或邮箱
    @NotBlank(message = "account字段不能为空")
    private String account;
    /**
     * 场景：注册(register)、修改密码(changepassword)、解冻账号(unfreezelogin)、验证码登录(verificationCodelogin)等
     * @see com.digiwin.mobile.mobileuibot.proxy.emc.model.EmcVerificationCodeSceneEnum
     */
    @NotBlank(message = "scene字段不能为空")
    @EnumConstraint(
            enumClass = EmcVerificationCodeSceneEnum.class,
            valueMethod = "getValue",
            message = "字段 scene 的输入值 '{value}' 不合法! 有效选项: {values}")
    private String scene;
    // 验证码
    @NotBlank(message = "identifyingCode字段不能为空")
    private String identifyingCode;
}
