package com.digiwin.mobile.mobileuibot.user.request;

import com.digiwin.mobile.mobileuibot.api.BaseRequest;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * <p>功能描述：密码更新请求类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PasswordUpdateReq.java
 * @Author: wangjwc
 * @Date: created at 2025/8/5 16:39
 */
@Data
public class PasswordUpdateReq extends BaseRequest {
    private static final long serialVersionUID = 7999433554766710211L;

    // 账号：手机或邮箱
    @NotBlank(message = "account字段不能为空")
    private String account;
    // 密码
    @NotBlank(message = "password字段不能为空")
    private String password;
    // 验证码
    @NotBlank(message = "verificationCode字段不能为空")
    private String verificationCode;
}
