package com.digiwin.mobile.mobileuibot.user.request;

import com.digiwin.mobile.mobileuibot.api.BaseRequest;
import com.digiwin.mobile.mobileuibot.api.EnumConstraint;
import com.digiwin.mobile.mobileuibot.proxy.emc.model.EmcVerificationCodeSceneEnum;
import com.digiwin.mobile.mobileuibot.user.enums.VerificationTypeEnum;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * <p>功能描述：获取验证码请求参数</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: VerificationCodeReq.java
 * @Author: wangjwc
 * @Date: created at 2025/8/5 16:39
 */
@Data
public class VerificationCodeReq extends BaseRequest {
    private static final long serialVersionUID = 1022613691584252931L;

    /**
     * 验证码类型，邮箱（email）手机号（mobilephone）
     * @see com.digiwin.mobile.mobileuibot.user.enums.VerificationTypeEnum
     */
    @NotBlank(message = "type字段不能为空")
    @EnumConstraint(
            enumClass = VerificationTypeEnum.class,
            valueMethod = "getValue",
            message = "字段 type 的输入值 '{value}' 不合法! 有效选项: {values}")
    private String type;
    // 账号：手机或邮箱
    @NotBlank(message = "account字段不能为空")
    private String account;
    /**
     * 场景：注册(register)、修改密码(changepassword)、解冻账号(unfreezelogin)、验证码登录(verificationCodelogin)等
     * @see com.digiwin.mobile.mobileuibot.proxy.emc.model.EmcVerificationCodeSceneEnum
     */
    @NotBlank(message = "scene字段不能为空")
    @EnumConstraint(
            enumClass = EmcVerificationCodeSceneEnum.class,
            valueMethod = "getValue",
            message = "字段 scene 的输入值 '{value}' 不合法! 有效选项: {values}")
    private String scene;
}
