package com.digiwin.mobile.mobileuibot.user.service;

import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamAccountRegisterResponse;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserInfo;
import com.digiwin.mobile.mobileuibot.user.request.*;

/**
 * <p>功能描述：用户服务接口</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UserService.java
 * @Author: wangjwc
 * @Date: created at 2025/8/5 15:14
 */
public interface UserService {

    /**
     * <p>功能描述：更新用户双重验证状态</p>
     *
     * @param request 请求参数
     * @param user 用户信息
     */
    void doubleCheckUpdate(DoubleCheckUpdateReq request, DigiwinIamUserInfo user);

    /**
     * <p>功能描述：检查邮箱、手机号是否存在</p>
     *
     * @param request 请求参数
     * @return 账号存在情况
     */
    DigiwinIamAccountRegisterResponse accountExistCheck(AccountExistCheckReq request);

    /**
     * <p>功能描述：发送验证码</p>
     *
     * @param request 验证码请求参数
     * @return 验证码发送结果
     */
    void verificationCode(VerificationCodeReq request);

    /**
     * <p>功能描述：检查验证码并返回新验证码</p>
     *
     * @param request 验证码请求参数
     * @return 新验证码
     */
    String checkVerificationCodeAndRenew(CheckVerificationCodeReq request);

    /**
     * <p>功能描述：忘记/修改密码（不需要旧密码）</p>
     *
     * @param request 密码更新请求参数
     */
    void passwordUpdate(PasswordUpdateReq request);
}
