package com.digiwin.mobile.mobileuibot.versionManage;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.api.PageResult;
import com.digiwin.mobile.mobileuibot.model.db2.AppConfig;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConfigAddRequest;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConfigPageRequest;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConfigUpdateRequest;

import java.util.List;

/**
 * <p>功能描述：版本管理系统 -- 应用管理服务接口</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: VersionManageApplicationService.java
 * @Author: wangjwc
 * @Date: created at 2025/8/8 17:48
 */
public interface VersionManageApplicationService {
    /**
     * <p>功能描述：获取应用列表</p>
     *
     * @param request 请求参数
     * @return List<AppConfig> 应用列表
     */
    List<AppConfig> list(AppConfigPageRequest request);

    /**
     * <p>功能描述：获取应用列表 -- 分页</p>
     *
     * @param pageRequest  请求参数
     * @return PageResult<AppConfig> 应用列表
     */
    PageResult<AppConfig> listPage(AppConfigPageRequest pageRequest);

    /**
     * <p>功能描述：根据ID获取应用详情</p>
     *
     * @param id 主键id
     * @return AppConfig 应用信息
     */
    AppConfig selectById(Long id);

    /**
     * <p>功能描述：新增应用</p>
     *
     * @param addRequest 新增参数
     * @return ApiResponse<Boolean> 新增结果
     */
    ApiResponse<Boolean> add(AppConfigAddRequest addRequest);

    /**
     * <p>功能描述：更新应用</p>
     *
     * @param updateRequest 更新参数
     * @return ApiResponse<AppConfig> 更新结果
     */
    ApiResponse<Boolean> update(AppConfigUpdateRequest updateRequest);

    /**
     * <p>功能描述：删除应用</p>
     *
     * @param id 主键id
     */
    void deleteById(Long id);

    /**
     * <p>功能描述：更新appId</p>
     *
     * @param id       主键id
     * @param appId    应用ID
     */
    void updateAppId(Long id, String appId);
}