package com.digiwin.mobile.mobileuibot.versionManage;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.api.PageResult;
import com.digiwin.mobile.mobileuibot.dto.AppClientPageDto;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppClientAddRequest;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppClientUpdateRequest;
import com.digiwin.mobile.mobileuibot.versionManage.response.AppClientResponse;
import com.digiwin.mobile.mobileuibot.versionManage.response.AppUpdateResponse;

import java.util.List;

/**
 * <p>功能描述：版本管理系统 -- 版本管理服务接口</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: VersionManageClientService.java
 * @Author: wangjwc
 * @Date: created at 2025/8/12 14:01
 */
public interface VersionManageClientService {
    /**
     * <p>功能描述：版本管理列表 -- 分页</p>
     *
     * @param pageRequest  请求参数
     * @return PageResult < AppClientResponse> 版本管理列表
     */
    PageResult<AppClientResponse> listPage(AppClientPageDto pageRequest);

    /**
     * <p>功能描述：版本管理详情</p>
     *
     * @param id 版本管理ID
     * @return AppClientResponse 版本管理详情
     */
    AppClientResponse queryById(Long id);

    /**
     * <p>功能描述：添加版本</p>
     *
     * @param addRequest 请求参数
     * @return ApiResponse<Boolean> 是否成功
     */
    ApiResponse<Boolean> add(AppClientAddRequest addRequest);

    /**
     * <p>功能描述：更新版本</p>
     *
     * @param updateRequest 请求参数
     * @return ApiResponse<Boolean> 是否成功
     */
    ApiResponse<Boolean> update(AppClientUpdateRequest updateRequest);

    /**
     * <p>功能描述：发布版本</p>
     *
     * @param releaseRequest 请求参数
     * @return ApiResponse<Boolean> 是否成功
     */
    ApiResponse<Boolean> release(AppClientUpdateRequest releaseRequest);

    /**
     * <p>功能描述：取消发布版本</p>
     *
     * @param id 待取消发布版本ID
     * @return ApiResponse<Boolean> 是否成功
     */
    ApiResponse<Boolean> unrelease(Long id);

    /**
     * <p>功能描述：删除版本</p>
     *
     * @param id 待删除版本ID
     * @return ApiResponse<Boolean> 是否成功
     */
    ApiResponse<Boolean> deleteById(Long id);

    /**
     * <p>功能描述：查询历史下发条件配置</p>
     *
     * @param id 待查询版本ID
     * @return ApiResponse<List<AppUpdateResponse>> 历史下发条件配置
     */
    ApiResponse<List<AppUpdateResponse>> updateHistoryById(Long id);
}