package com.digiwin.mobile.mobileuibot.versionManage;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.api.PageResult;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConditionAddRequest;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConditionPageRequest;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConditionUpdateRequest;
import com.digiwin.mobile.mobileuibot.versionManage.response.AppConditionResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * <p>功能描述：版本管理系统 -- 条件管理控制器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: VersionManageConditionController.java
 * @Author: wangjwc
 * @Date: created at 2025/8/11 15:49
 */
@Slf4j
@RestController
@RequestMapping("/mobile/v2/version/manage/condition")
public class VersionManageConditionController {
    @Autowired
    private VersionManageConditionService versionManageConditionService;
    @Autowired
    private LocaleService localeService;

    /**
     * <p>功能描述：获取应用列表</p>
     *
     * @param request 请求参数
     * @return ApiResponse<List < AppConfig>> 应用列表
     */
    @PostMapping(value = "/list")
    public ApiResponse<List<AppConditionResponse>> list(@RequestBody AppConditionPageRequest request) {
        return ApiResponse.buildOK(versionManageConditionService.list(request));
    }

    /**
     * <p>功能描述：获取条件列表 -- 分页</p>
     *
     * @param pageRequest  请求参数
     * @return ApiResponse<PageResult < AppConditionResponse>> 条件列表
     */
    @PostMapping(value = "/list/page")
    public ApiResponse<PageResult<AppConditionResponse>> listPage(@RequestBody AppConditionPageRequest pageRequest) {
        return ApiResponse.buildOK(versionManageConditionService.listPage(pageRequest));
    }

    /**
     * <p>功能描述：获取条件详情</p>
     *
     * @param id 条件id
     * @return ApiResponse<AppConditionResponse> 条件详情
     */
    @GetMapping(value = "/select/{id}")
    public ApiResponse<AppConditionResponse> selectById(@PathVariable("id") Long id) {
        if (null == id) {
            return ApiResponse.buildError(localeService.getLanguageValue("查询数据不存在"));
        }
        AppConditionResponse appConditionResponse = versionManageConditionService.selectById(id);
        if (null == appConditionResponse) {
            return ApiResponse.buildError(localeService.getLanguageValue("查询数据不存在"));
        }
        return ApiResponse.buildOK(appConditionResponse);
    }

    /**
     * <p>功能描述：添加条件</p>
     *
     * @param addRequest 添加条件参数
     * @return ApiResponse<Boolean> 添加结果
     */
    @PostMapping(value = "/add")
    public ApiResponse<Boolean> add(@Valid @RequestBody AppConditionAddRequest addRequest) {
        return versionManageConditionService.add(addRequest);
    }

    /**
     * <p>功能描述：更新条件</p>
     *
     * @param updateRequest 更新条件参数
     * @return ApiResponse<Boolean> 更新结果
     */
    @PostMapping(value = "/update")
    public ApiResponse<Boolean> update(@Valid @RequestBody AppConditionUpdateRequest updateRequest) {
        return versionManageConditionService.update(updateRequest);
    }

    /**
     * <p>功能描述：删除条件</p>
     *
     * @param id 条件id
     * @return ApiResponse<Boolean> 删除结果
     */
    @GetMapping(value = "/delete/{id}")
    public ApiResponse<Boolean> deleteById(@PathVariable("id") Long id) {
        if (null == id) {
            return ApiResponse.buildError(localeService.getLanguageValue("数据不存在"));
        }
        return versionManageConditionService.deleteById(id);
    }
}
