package com.digiwin.mobile.mobileuibot.versionManage;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.api.PageResult;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConditionAddRequest;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConditionPageRequest;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppConditionUpdateRequest;
import com.digiwin.mobile.mobileuibot.versionManage.response.AppConditionResponse;

import java.util.List;

/**
 * <p>功能描述：版本管理系统 -- 条件管理服务接口</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: VersionManageConditionService.java
 * @Author: wangjwc
 * @Date: created at 2025/8/11 15:50
 */
public interface VersionManageConditionService {
    /**
     * <p>功能描述：获取条件列表</p>
     *
     * @param request 请求参数
     * @return List<AppConditionResponse> 条件列表
     */
    List<AppConditionResponse> list(AppConditionPageRequest request);

    /**
     * <p>功能描述：获取条件列表 -- 分页</p>
     *
     * @param pageRequest  请求参数
     * @return PageResult<AppConditionResponse> 条件列表
     */
    PageResult<AppConditionResponse> listPage(AppConditionPageRequest pageRequest);

    /**
     * <p>功能描述：获取条件详情</p>
     *
     * @param id 条件ID
     * @return AppConditionResponse 条件详情
     */
    AppConditionResponse selectById(Long id);

    /**
     * <p>功能描述：添加条件</p>
     *
     * @param addRequest 添加条件参数
     * @return ApiResponse<Boolean> 添加结果
     */
    ApiResponse<Boolean> add(AppConditionAddRequest addRequest);

    /**
     * <p>功能描述：更新条件</p>
     *
     * @param updateRequest 更新条件参数
     * @return ApiResponse<Boolean> 更新结果
     */
    ApiResponse<Boolean> update(AppConditionUpdateRequest updateRequest);

    /**
     * <p>功能描述：删除条件</p>
     *
     * @param id 删除条件ID
     * @return ApiResponse<Boolean> 删除结果
     */
    ApiResponse<Boolean> deleteById(Long id);
}