package com.digiwin.mobile.mobileuibot.versionManage;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>功能描述：版本管理系统 -- 登录服务控制层</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: VersionManageLoginController.java
 * @Author: wangjwc
 * @Date: created at 2025/8/11 15:34
 */
@Slf4j
@RestController
@RequestMapping("/mobile/v2/version/manage/login")
public class VersionManageLoginController {
    @Autowired
    private VersionManageLoginService versionManageLoginService;

    /**
     * 检查账号是否在白名单中
     *
     * @return Boolean 是否在白名单中
     */
    @GetMapping("/whitelist/check")
    public ApiResponse<Boolean> checkWhitelist(@RequestParam(name = "userId") String userId) {
        return ApiResponse.buildOK(VersionManageLoginService.WHITELIST.contains(userId));
    }
}
