package com.digiwin.mobile.mobileuibot.versionManage;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.versionManage.request.AppUpgradeReq;
import com.digiwin.mobile.mobileuibot.versionManage.response.AppCheckResp;
import com.digiwin.mobile.mobileuibot.versionManage.response.AppUpgradeResp;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>功能描述：版本升级 控制器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: VersionUpgradeController.java
 * @Author: wangjwc
 * @Date: created at 2025/6/26 16:24
 */
@RestController
@RequestMapping("/mobile/v2/version")
@Slf4j
public class VersionUpgradeController {

    @Autowired
    private VersionUpgradeService versionUpgradeService;

    /**
     * <p>功能描述：版本升级</p>
     *
     * @param vo 请求参数
     * @return com.digiwin.mobile.mobileuibot.api.ApiResponse<com.digiwin.mobile.mobileuibot.versionManage.response.AppUpgradeResp>
     */
    @PostMapping(value = "/upgrade")
    public ApiResponse<AppUpgradeResp> upgrade(@RequestBody AppUpgradeReq vo) {
        log.info("版更接口请求参数：{}", JsonUtil.javaObjectToJsonString(vo));
        return ApiResponse.buildOK(versionUpgradeService.upgrade(vo));
    }

    /**
     * <p>功能描述：检查更新</p>
     *
     * @param appId   应用ID
     * @param version 客户端版本
     * @param arch    系统架构
     * @param brand   系统品牌
     * @param locale  语言别
     * @return com.digiwin.mobile.mobileuibot.api.ApiResponse<com.digiwin.mobile.mobileuibot.versionManage.response.AppUpgradeResp>
     */
    @GetMapping(value = "/check-update")
    public ApiResponse<AppCheckResp> checkUpdate(@RequestParam(name = "appId") String appId,
                                                 @RequestParam(name = "version") String version,
                                                 @RequestParam(name = "arch") String arch,
                                                 @RequestParam(name = "brand") String brand,
                                                 @RequestParam(name = "locale") String locale) {
        log.info("检查更新接口请求参数：appId:{}, version:{}, brand:{}, arch:{}, locale:{}", appId, version, brand, arch, locale);
        AppUpgradeReq vo = new AppUpgradeReq()
                .setAppId(appId)
                .setVersion(version)
                .setArch(arch)
                .setBrand(brand)
                .setLocale(locale);
        return ApiResponse.buildOK(versionUpgradeService.checkUpdate(vo));
    }
}
