package com.digiwin.mobile.mobileuibot.versionManage.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * <p>功能描述：品牌枚举类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: BrandEnum.java
 * @Author: wangjwc
 * @Date: created at 2025/6/27 15:58
 */
@Getter
public enum BrandEnum {
    /**
     * 小米
     */
    XIAOMI("xiaomi"),
    /**
     * 华为
     */
    HUAWEI("huawei"),
    /**
     * VIVO
     */
    VIVO("vivo"),
    /**
     * OPPO
     */
    OPPO("oppo"),
    ;

    private final String value;

    BrandEnum(String value) {
        this.value = value;
    }

    public static BrandEnum exist(String value) {
        if (StringUtils.isBlank(value)) {
            return null;
        }
        for (BrandEnum brandEnum : BrandEnum.values()) {
            if (Objects.equals(brandEnum.getValue(), value)) {
                return brandEnum;
            }
        }
        return null;
    }
}
