package com.digiwin.mobile.mobileuibot.versionManage.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * <p>功能描述：组件类型枚举类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ComponentEnum.java
 * @Author: wangjwc
 * @Date: created at 2025/6/27 15:58
 */
@Getter
public enum ComponentEnum {
    /**
     * 0单行文本
     */
    SINGLE_TEXT(0),
    /**
     * 1多行文本
     */
    MULTI_TEXT(1),
    /**
     * 2下拉单选
     */
    SELECT_SINGLE(2),
    /**
     * 3下拉多选
     */
    SELECT_MULTI(3),
    /**
     * 4租户选择框
     */
    SELECT_TENANT(4),
    ;

    private final Integer value;

    ComponentEnum(Integer value) {
        this.value = value;
    }

    public static ComponentEnum exist(Integer value) {
        if (null == value) {
            return null;
        }
        for (ComponentEnum componentEnum : ComponentEnum.values()) {
            if (Objects.equals(componentEnum.getValue(), value)) {
                return componentEnum;
            }
        }
        return null;
    }

}
