package com.digiwin.mobile.mobileuibot.versionManage.enums;

import lombok.Getter;

/**
 * <p>功能描述：操作符枚举类</p>
 * <p> eq = 'dj-完全匹配',
 *   not_eq = 'dj-不匹配',
 *   lt = 'dj-小于',
 *   le = 'dj-小于等于',
 *   gt = 'dj-大于',
 *   ge = 'dj-大于等于',
 *   in = 'dj-存在',
 *   not_in = 'dj-不存在',
 *   like = 'dj-包含',
 *   not_like = 'dj-不包含',
 *   null = 'dj-为空',
 *   not_null = 'dj-不为空',
 *   empty = 'dj-空字符串',
 *   not_empty = 'dj-不为空字符串',
 *   between = 'dj-介于',
 *   not_between = 'dj-未介于',
 *   start_like = 'dj-开头是',
 *   not_start_like = 'dj-开头不是',
 *   end_like = 'dj-结尾是',
 *   not_end_like = 'dj-结尾不是',</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: OperatorEnum.java
 * @Author: wangjwc
 * @Date: created at 2025/6/30 23:49
 */
@Getter
public enum OperatorEnum {
    // 完全匹配
    EQ("eq"),
    // 小于
    LT("lt"),
    // 小于等于
    LE("le"),
    // 大于
    GT("gt"),
    // 大于等于
    GE("ge"),
    ;

    private final String value;

    OperatorEnum(String value) {
        this.value = value;
    }

    public static OperatorEnum exist(String value) {
        for (OperatorEnum item : OperatorEnum.values()) {
            if (item.value.equals(value)) {
                return item;
            }
        }
        return null;
    }
}
