package com.digiwin.mobile.mobileuibot.versionManage.enums;

import lombok.Getter;

/**
 * <p>功能描述：更新范围枚举类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UpdateRangeEnum.java
 * @Author: wangjwc
 * @Date: created at 2025/6/27 16:09
 */
@Getter
public enum UpdateRangeEnum {
    /**
     * 0：全量
     */
    ALL(0),

    /**
     * 1：局部
     */
    PARTIAL(1),
    ;

    private final Integer value;

    UpdateRangeEnum(Integer value) {
        this.value = value;
    }

    public static UpdateRangeEnum getByValue(Integer value) {
        for (UpdateRangeEnum item : UpdateRangeEnum.values()) {
            if (item.value.equals(value)) {
                return item;
            }
        }
        return null;
    }
}
