package com.digiwin.mobile.mobileuibot.versionManage.model;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * <p>功能描述：app客户端下发条件项</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UpdateConditionItem.java
 * @Author: wangjwc
 * @Date: created at 2025/6/30 22:55
 */
@Data
@Accessors(chain = true)
public class UpdateConditionItem implements Serializable {
    private static final long serialVersionUID = 6790334682466731657L;
    /**
     * 下发条件项顺序
     */
    private Integer order;
    /**
    * 条件项ID -- 关联app_condition_item.id
    */
    private Long id;
    /**
    * schema--需要与端上约定（与入参一致）
    */
    private String schema;
    /**
    * 条件符：0不显示，1显示
    */
    private Integer symbol;
    /**
     * 条件值组件：0单行文本，1多行文本，2下拉单选，3下拉多选，4租户选择框
     * @see com.digiwin.mobile.mobileuibot.versionManage.enums.ComponentEnum
     */
    private Integer component;
    /**
     * 是否包含ops租户，component=4时有值
     */
    private Boolean opsTenant;
    /**
    * 操作符
     * @see com.digiwin.mobile.mobileuibot.versionManage.enums.OperatorEnum
    */
    private String operator;
    /**
    * 下发条件值
    */
    private List<String> value;
    /**
     * 逻辑信息 AND 或者 OR ，其他暂不支持
     */
    private String logic;
}