package com.digiwin.mobile.mobileuibot.versionManage.request;

import com.digiwin.mobile.mobileuibot.api.EnumConstraint;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.versionManage.enums.ReleaseTypeEnum;
import com.digiwin.mobile.mobileuibot.versionManage.enums.StrongUpdateEnum;
import com.digiwin.mobile.mobileuibot.versionManage.enums.UpdateMethodsEnum;
import com.digiwin.mobile.mobileuibot.versionManage.model.UpdateCondition;
import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：版本管理-客户端新增请求参数</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AppClientAddRequest.java
 * @Author: wangjwc
 * @Date: created at 2025/8/12 14:41
 */
@Data
public class AppClientAddRequest implements Serializable {
    private static final long serialVersionUID = 1141827585293843892L;
    /**
     * 应用ID（关联app_config.id）
     */
    @NotNull(message = "应用ID不能为空")
    private Long appId;
    /**
     * APP版本号
     */
    @NotBlank(message = "版本号不能为空")
    private String version;
    /**
     * 描述
     */
    private String descr;
    /**
     * 方式：0:apk上传方式，1链接方式
     * @see com.digiwin.mobile.mobileuibot.versionManage.enums.UpdateMethodsEnum
     */
    @NotNull(message = "上传方式不能为空")
    @EnumConstraint(
            enumClass = UpdateMethodsEnum.class,
            valueMethod = "getValue",
            message = "上传方式 的输入值 '{value}' 不合法! 有效选项: {values}")
    private Integer methods;
    /**
     *  下载地址（32位）
     */
    private String url32;
    /**
     *  下载地址（64位）
     */
    private String url64;
    /**
     *  MD5值（32位）
     */
    private String md532;
    /**
     *  MD5值（64位）
     */
    private String md564;
    /**
     * 跳转到应用商店的品牌：xiaomi,huawei,vivo,oppo
     * @see com.digiwin.mobile.mobileuibot.versionManage.enums.BrandEnum
     */
    private List<String> brand;
    /**
     * 提示标题
     */
    @NotBlank(message = "弹窗标题不能为空")
    private String tipsTitle;
    /**
     * 提示内容
     */
    @NotBlank(message = "弹窗内容不能为空")
    private String tips;
    /**
     * 多语言配置
     */
    @NotNull(message = "多语言配置不能为空")
    private Map<String, Map<String, String>> lang;

    //====================================app_update 表字段=======================================
    /**
     * 发布类型 0：局部发布，1：全量发布
     * 注意：局部发布下(条件必须配置），满足条件提示更新（强更/提示），不满足条件的一律不提示。
     * 全量发布下（未开启强更条件不可配置），开启强更，无条件全部强更，有条件不满足条件提示更新；关闭强更，没有条件都提示更新。
     * @see com.digiwin.mobile.mobileuibot.versionManage.enums.ReleaseTypeEnum
     */
    @NotNull(message = "发布类型不能为空")
    @EnumConstraint(
            enumClass = ReleaseTypeEnum.class,
            valueMethod = "getValue",
            message = "发布类型 的输入值 '{value}' 不合法! 有效选项: {values}")
    private Integer releaseType;
    /**
     * 强制版更 0：否，1：是
     * @see com.digiwin.mobile.mobileuibot.versionManage.enums.StrongUpdateEnum
     */
    @NotNull(message = "强制版更不能为空")
    @EnumConstraint(
            enumClass = StrongUpdateEnum.class,
            valueMethod = "getValue",
            message = "强制版更 的输入值 '{value}' 不合法! 有效选项: {values}")
    private Integer strongUpdate;
    /**
     * 强制版更范围 0：全量，1：局部。
     * 注意：type=1&&strong_update=1有值
     * @see com.digiwin.mobile.mobileuibot.versionManage.enums.UpdateRangeEnum
     */
    private Integer updateRange;
    /**
     * 下发条件配置
     */
    private List<UpdateCondition> conditions;

    /**
     * 转换 brand
     * @return String
     */
    public String convertBrand() {
        if (CollectionUtils.isEmpty(this.brand)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String b : brand) {
            sb.append(b).append(",");
        }
        return sb.substring(0, sb.length() - 1);
    }

    /**
     * 转换 lang
     * @return String
     */
    public String convertLang() {
        if (this.lang == null) {
            return "";
        }
        return JsonUtil.javaObjectToJsonString(this.lang);
    }

    /**
     * 转换 conditions
     * @return String
     */
    public String convertConditions() {
        if (CollectionUtils.isEmpty(this.conditions)) {
            return "";
        }
        return JsonUtil.javaObjectToJsonString(this.conditions);
    }
}
