package com.digiwin.mobile.mobileuibot.versionManage.request;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * <p>功能描述：条件配置新增请求类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AppConditionAddRequest.java
 * @Author: wangjwc
 * @Date: created at 2025/8/11 13:15
 */
@Data
@Accessors(chain = true)
public class AppConditionAddRequest implements Serializable {
    private static final long serialVersionUID = -8339175340762093202L;
    /**
     * 条件名称
     */
    @NotBlank(message = "名称不能为空")
    private String name;
    /**
     * 条件描述
     */
    private String descr;
    /**
     * 条件项
     */
    @NotEmpty(message = "条件项不能为空")
    @Valid
    private List<AppConditionItemRequest> item;
}