package com.digiwin.mobile.mobileuibot.versionManage.request;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * <p>功能描述：应用配置新增请求类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AppConfigAddRequest.java
 * @Author: wangjwc
 * @Date: created at 2025/8/11 13:15
 */
@Data
@Accessors(chain = true)
public class AppConfigAddRequest implements Serializable {
    private static final long serialVersionUID = -4963854617673205293L;
    @NotBlank(message = "应用名称不能为空")
    private String name;
    /**
     * 系统类型：android,ios
     */
    @NotBlank(message = "系统类型不能为空")
    private String osType;
    /**
     * 环境：华为正式区、微软测试区、微软正式区、华为测试区
     */
    @NotBlank(message = "环境不能为空")
    private String env;
    /**
     * 应用描述
     */
    private String descr;
    /**
     * 是否有效 0：无效  1：有效
     * @see com.digiwin.mobile.mobileuibot.versionManage.enums.ValidEnum
     */
    @NotNull(message = "状态不能为空")
    private Integer valid;
}