package com.digiwin.mobile.mobileuibot.versionManage.request;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * <p>功能描述：app upgrade请求参数封装类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AppUpgradeReq.java
 * @Author: wangjwc
 * @Date: created at 2025/6/27 11:24
 */
@Data
@Accessors(chain = true)
public class AppUpgradeReq implements Serializable {
    private static final long serialVersionUID = 144024183418071669L;
    private String locale;
    private String iamUserToken;

    // 应用ID
    private String appId;
    // 应用版本号
    private String version;
    /**
     * 架构类型
     * 注意：--- 其它 32位架构
     * armeabi-v7a: 32-bit ARM 架构（ARMv7）
     * arm64-v8a: 64-bit ARM 架构（ARMv8）
     */
    private String arch;
    // 品牌类型 -- 需后端判断具体品牌
    private String brand;
    // 设备ID(手机唯一)，如：cb93764a-7174-4b94-b5ca-9221fcb89a52
    private String deviceId;
    // 设备型号（model），如：iPhone14,3
    private String deviceType;
    // 系统版本,如：13,14等
    private String osVersion;
    // 系统类型，如：ios/android
    private String osType;
    // 应用包名
    private String packageName;
    // 租户ID
    private String tenantId;
    // 用户ID
    private String userId;
}