package com.digiwin.mobile.mobileuibot.versionManage.response;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.model.BaseModel;
import com.digiwin.mobile.mobileuibot.model.db2.AppConditionItem;
import com.digiwin.mobile.mobileuibot.versionManage.enums.ComponentEnum;
import com.digiwin.mobile.mobileuibot.versionManage.model.ConditionItemSelectContent;
import com.digiwin.mobile.mobileuibot.versionManage.model.ConditionItemTextVerify;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

/**
 * <p>功能描述：条件项返回对象</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AppConditionItemResponse.java
 * @Author: wangjwc
 * @Date: created at 2025/8/11 16:59
 */
@Data
public class AppConditionItemResponse extends BaseModel {
    private static final long serialVersionUID = 7377929371896532639L;
    /**
     * 主键id
     */
    private Long id;
    /**
     * 条件ID（关联app_condition.id）
     */
    private Long appConditionId;
    /**
     * schema--需要与端上约定（与入参一致）
     */
    private String schema;
    /**
     * 名称
     */
    private String name;
    /**
     * 条件符：0不显示，1显示
     */
    private Integer symbol;
    /**
     * 条件值组件：0单行文本，1多行文本，2下拉单选，3下拉多选，4租户选择框
     * @see com.digiwin.mobile.mobileuibot.versionManage.enums.ComponentEnum
     */
    private Integer component;
    /**
     * 条件值，component=2/3
     * ConditionItemSelectContent
     *  {
     *         "options": [
     *                   {
     *                     "id": "android",
     *                     "text": "Android"
     *                   },
     *                   {
     *                     "id": "ios",
     *                     "text": "iOS"
     *                   }
     *             ]
     * }
     */
    private Object content;
    /**
     * 条件值校验，component=0/1
     * ConditionItemTextVerify
     * {
     *         "msg": "" , // 文案
     *         "script": "" // 效验脚本
     * }
     */
    private Object verify;
    /**
     * 删除标志 0：未删除  1：已删除
     * @see com.digiwin.mobile.mobileuibot.mock.enums.DelFlagEnum
     */
    private Integer delFlag;

    public static AppConditionItemResponse convert(AppConditionItem appConditionItem) {
        if (appConditionItem == null) {
            return null;
        }
        AppConditionItemResponse appConditionItemResponse = new AppConditionItemResponse();
        appConditionItemResponse.setId(appConditionItem.getId());
        appConditionItemResponse.setAppConditionId(appConditionItem.getAppConditionId());
        appConditionItemResponse.setSchema(appConditionItem.getSchema());
        appConditionItemResponse.setName(appConditionItem.getName());
        appConditionItemResponse.setSymbol(appConditionItem.getSymbol());
        appConditionItemResponse.setComponent(appConditionItem.getComponent());
        appConditionItemResponse.setContent(convertContent(appConditionItem.getComponent(), appConditionItem.getContent()));
        appConditionItemResponse.setVerify(convertVerify(appConditionItem.getComponent(), appConditionItem.getVerify()));
        appConditionItemResponse.setDelFlag(appConditionItem.getDelFlag());
        appConditionItemResponse.setCreateTime(appConditionItem.getCreateTime());
        appConditionItemResponse.setUpdateTime(appConditionItem.getUpdateTime());
        return appConditionItemResponse;
    }

    /**
     * 转换条件值
     *
     * @param component 组件
     * @param content 条件值
     * @return 条件值
     */
    private static Object convertContent(Integer component, String content) {
        if (StringUtils.isBlank(content)) {
            return null;
        }
        // 条件值，component=2/3
        if (ComponentEnum.SELECT_SINGLE.getValue().equals(component) || ComponentEnum.SELECT_MULTI.getValue().equals(component)) {
            return JsonUtil.jsonStringToObject(content, ConditionItemSelectContent.class);
        }
        return null;
    }

    /**
     * 转换条件值校验
     *
     * @param component 组件
     * @param verify 条件值校验
     * @return 条件值校验
     */
    private static Object convertVerify(Integer component, String verify) {
        if (StringUtils.isBlank(verify)) {
            return null;
        }
        // 条件值校验，component=0/1
        if (ComponentEnum.SINGLE_TEXT.getValue().equals(component) || ComponentEnum.MULTI_TEXT.getValue().equals(component)) {
            return JsonUtil.jsonStringToObject(verify, ConditionItemTextVerify.class);
        }
        return null;
    }
}
