package com.digiwin.mobile.mobileuibot.versionManage.response;

import com.digiwin.mobile.mobileuibot.model.BaseModel;
import com.digiwin.mobile.mobileuibot.model.db2.AppCondition;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * <p>功能描述：条件管理返回值对象</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AppConditionResponse.java
 * @Author: wangjwc
 * @Date: created at 2025/8/11 16:17
 */
@Data
public class AppConditionResponse extends BaseModel {
    private static final long serialVersionUID = 5639518427718166908L;
    /**
     * 主键id
     */
    private Long id;
    /**
     * 条件名称
     */
    private String name;
    /**
     * 条件描述
     */
    private String descr;
    /**
     * 删除标志 0：未删除  1：已删除
     * @see com.digiwin.mobile.mobileuibot.mock.enums.DelFlagEnum
     */
    private Integer delFlag;

    // 条件项
    private List<AppConditionItemResponse> item;

    public static AppConditionResponse convert(AppCondition appCondition) {
        if (appCondition == null) {
            return null;
        }
        AppConditionResponse appConditionResponse = new AppConditionResponse();
        appConditionResponse.setId(appCondition.getId());
        appConditionResponse.setName(appCondition.getName());
        appConditionResponse.setDescr(appCondition.getDescr());
        appConditionResponse.setDelFlag(appCondition.getDelFlag());
        appConditionResponse.setCreateTime(appCondition.getCreateTime());
        appConditionResponse.setUpdateTime(appCondition.getUpdateTime());
        return appConditionResponse;
    }
}
