package com.digiwin.mobile.mobileuibot.versionManage.response;

import com.digiwin.mobile.mobileuibot.model.BaseModel;
import com.digiwin.mobile.mobileuibot.model.db2.AppUpdate;
import com.digiwin.mobile.mobileuibot.versionManage.model.UpdateCondition;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <p>功能描述：客户端版本更新配置返回对象</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AppUpdateResponse.java
 * @Author: wangjwc
 * @Date: created at 2025/9/5 18:15
 */
@Data
@Accessors(chain = true)
public class AppUpdateResponse extends BaseModel {
    private static final long serialVersionUID = -7404340121545039046L;
    /**
     * 主键id
     */
    private Long id;
    /**
     * 客户端ID（关联app_client.id）
     */
    private Long appClientId;
    /**
     * 发布类型 0：局部发布，1：全量发布
     * 注意：局部发布下(条件必须配置），满足条件提示更新（强更/提示），不满足条件的一律不提示。
     * 全量发布下（未开启强更条件不可配置），开启强更，无条件全部强更，有条件不满足条件提示更新；关闭强更，没有条件都提示更新。
     * @see com.digiwin.mobile.mobileuibot.versionManage.enums.ReleaseTypeEnum
     */
    private Integer releaseType;
    /**
     * 强制版更 0：否，1：是
     * @see com.digiwin.mobile.mobileuibot.versionManage.enums.StrongUpdateEnum
     */
    private Integer strongUpdate;
    /**
     * 强制版更范围 0：全量，1：局部。
     * 注意：type=1&&strong_update=1有值
     * @see com.digiwin.mobile.mobileuibot.versionManage.enums.UpdateRangeEnum
     */
    private Integer updateRange;
    /**
     * 下发条件配置
     */
    private List<UpdateCondition> conditions;

    public static AppUpdateResponse convert(AppUpdate appUpdate) {
        if (appUpdate == null) {
            return null;
        }
        AppUpdateResponse appUpdateResponse = new AppUpdateResponse();
        appUpdateResponse.setId(appUpdate.getId());
        appUpdateResponse.setAppClientId(appUpdate.getAppClientId());
        appUpdateResponse.setReleaseType(appUpdate.getReleaseType());
        appUpdateResponse.setStrongUpdate(appUpdate.getStrongUpdate());
        appUpdateResponse.setUpdateRange(appUpdate.getUpdateRange());
        appUpdateResponse.setConditions(AppClientResponse.convertConditions(appUpdate.getConditions()));
        appUpdateResponse.setCreateTime(appUpdate.getCreateTime());
        appUpdateResponse.setUpdateTime(appUpdate.getUpdateTime());
        return appUpdateResponse;
    }
}