package com.digiwin.mobile.mobileuibot.versionManage.response;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * <p>功能描述：app upgrade 响应对象</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AppUpgradeResp.java
 * @Author: wangjwc
 * @Date: created at 2025/6/27 11:24
 */
@Data
@Accessors(chain = true)
public class AppUpgradeResp implements Serializable {
    private static final long serialVersionUID = 7953564233783958906L;
    /**
     * 客户端最新版本号
     */
    private String latestVersion;
    /**
     * 客户端更新策略 value: 0.无需更新 1.推荐更新 2.强制更新
     * @see com.digiwin.mobile.mobileuibot.versionManage.enums.UpdateStrategyEnum
     */
    private Integer updateStrategy;
    /**
     * APP包的MD5值（用于校验文件完整性）
     */
    private String md5;
    /**
     * 跳转到应用商店，true:是，false：否
     */
    private Boolean store;
    /**
     * 客户端下载地址
     */
    private String url;
    /**
     * 更新提示标题 -- 多语言
     */
    private String title;
    /**
     * 更新提示内容 -- 多语言
     */
    private String tips;
}